/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.debug;

import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.apache.commons.lang.math.IntRange;
import org.apache.sysml.debug.DMLDebuggerException;
import org.apache.sysml.debug.DMLFrame;
import org.apache.sysml.debug.DMLProgramCounter;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.BreakPointInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class DMLDebuggerFunctions {
    public static final int DISPLAY_MAX_ROWS = 30;
    public static final int DISPLAY_MAX_COLUMNS = 8;

    public void listBreakpoints(TreeMap<Integer, BreakPointInstruction> breakpoints) {
        if (breakpoints == null) {
            System.out.println("No breakpoints are set for this program.");
            return;
        }
        int currBreakpoint = 1;
        int numVisibleBreakpoints = 0;
        for (Map.Entry<Integer, BreakPointInstruction> e : breakpoints.entrySet()) {
            Integer lineNumber = e.getKey();
            BreakPointInstruction inst = e.getValue();
            if (inst.getBPInstructionStatus() == BreakPointInstruction.BPINSTRUCTION_STATUS.ENABLED) {
                System.out.format("Breakpoint %2d, at line %4d (%s)\n", currBreakpoint++, lineNumber, "enabled");
                ++numVisibleBreakpoints;
                continue;
            }
            if (inst.getBPInstructionStatus() != BreakPointInstruction.BPINSTRUCTION_STATUS.DISABLED) continue;
            System.out.format("Breakpoint %2d, at line %4d (%s)\n", currBreakpoint++, lineNumber, "disabled");
            ++numVisibleBreakpoints;
        }
        if (numVisibleBreakpoints == 0) {
            System.out.println("No breakpoints are set for this program.");
        }
    }

    public void printLines(String[] lines, IntRange range) {
        for (int lineNumber = range.getMinimumInteger(); lineNumber <= range.getMaximumInteger(); ++lineNumber) {
            System.out.format("line %4d: %s\n", lineNumber, lines[lineNumber - 1]);
        }
    }

    public void printInstructions(String[] lines, TreeMap<Integer, ArrayList<Instruction>> DMLInstMap, IntRange range, boolean debug) {
        for (int lineNumber = range.getMinimumInteger(); lineNumber <= range.getMaximumInteger(); ++lineNumber) {
            System.out.format("line %4d: %s\n", lineNumber, lines[lineNumber - 1]);
            if (DMLInstMap.get(lineNumber) == null) continue;
            for (Instruction currInst : DMLInstMap.get(lineNumber)) {
                if (currInst instanceof CPInstruction) {
                    if (!debug) {
                        System.out.format("\t\t id %4d: %s\n", currInst.getInstID(), DMLDebuggerFunctions.prepareInstruction(currInst.toString()));
                        continue;
                    }
                    String[] instStr = DMLDebuggerFunctions.prepareInstruction(currInst.toString()).split(" ");
                    System.out.format("\t\t id %4d: %s %s\n", currInst.getInstID(), instStr[0], instStr[1]);
                    continue;
                }
                if (currInst instanceof MRJobInstruction) {
                    MRJobInstruction currMRInst = (MRJobInstruction)currInst;
                    System.out.format("\t\t id %4d: %s\n", currInst.getInstID(), DMLDebuggerFunctions.prepareInstruction(currMRInst.getMRString(debug)));
                    continue;
                }
                if (!(currInst instanceof BreakPointInstruction)) continue;
                BreakPointInstruction currBPInst = (BreakPointInstruction)currInst;
                System.out.format("\t\t id %4d: %s\n", currInst.getInstID(), currBPInst.toString());
            }
        }
    }

    public void printRuntimeInstructions(TreeMap<Integer, ArrayList<Instruction>> DMLInstMap, IntRange range) {
        for (int lineNumber = range.getMinimumInteger(); lineNumber <= range.getMaximumInteger(); ++lineNumber) {
            if (DMLInstMap.get(lineNumber) == null) continue;
            for (Instruction currInst : DMLInstMap.get(lineNumber)) {
                if (currInst instanceof CPInstruction) {
                    System.out.format("\t\t id %4d: %s\n", currInst.getInstID(), DMLDebuggerFunctions.prepareInstruction(currInst.toString()));
                    continue;
                }
                if (currInst instanceof MRJobInstruction) {
                    MRJobInstruction currMRInst = (MRJobInstruction)currInst;
                    System.out.format("\t\t id %4d: %s\n", currInst.getInstID(), DMLDebuggerFunctions.prepareInstruction(currMRInst.getMRString(false)));
                    continue;
                }
                if (!(currInst instanceof BreakPointInstruction)) continue;
                BreakPointInstruction currBPInst = (BreakPointInstruction)currInst;
                System.out.format("\t\t id %4d: %s\n", currInst.getInstID(), currBPInst.toString());
            }
        }
    }

    public void printPC(DMLProgramCounter pc) {
        if (pc != null) {
            System.out.println("  Current program counter at " + pc.toString());
        } else {
            System.out.println("DML runtime is currently inactive.");
        }
    }

    public void printFrameVariables(LocalVariableMap frameVariables) {
        if (frameVariables != null && !frameVariables.keySet().isEmpty()) {
            System.out.println("  Local variables:");
            System.out.format("\t%-40s %-40s", "Variable name", "Variable value");
            for (String varname : frameVariables.keySet()) {
                System.out.format("\n\t%-40s %-40s", varname, frameVariables.get(varname).toString());
            }
            System.out.println();
        } else {
            System.out.println("\tSymbol table for current frame is empty");
        }
    }

    public void printFrame(DMLFrame frame) {
        if (frame != null && frame.getPC() != null) {
            this.printPC(frame.getPC());
            this.printFrameVariables(frame.getVariables());
        } else {
            System.out.println("DML runtime is currently inactive.");
        }
    }

    public void printCallStack(DMLFrame currFrame, Stack<DMLFrame> callStack) {
        int frameID = 0;
        if (currFrame == null) {
            System.out.println("DML runtime is currently inactive.");
        } else {
            if (callStack != null) {
                for (DMLFrame frame : callStack) {
                    System.out.println("Frame id: " + frameID++);
                    this.printFrame(frame);
                }
            }
            System.out.println("Current frame id: " + frameID++);
            this.printFrame(currFrame);
        }
    }

    public void printScalarVariable(LocalVariableMap variables, String varname) {
        if (varname == null) {
            System.err.println("No scalar variable name entered.");
            return;
        }
        if (variables != null && !variables.keySet().isEmpty()) {
            if (variables.get(varname) != null) {
                if (variables.get(varname).getDataType() == Expression.DataType.SCALAR) {
                    System.out.println(varname + " = " + variables.get(varname).toString());
                } else {
                    System.out.println("Variable \"" + varname + "\" is not scalar variable.");
                }
            } else {
                System.out.println("DML scalar variable \"" + varname + "\" is not in the current frame scope. Try \"a\" to list all variables within current frame scope.");
            }
        } else {
            System.out.println("Symbol table for current frame is empty");
        }
    }

    public void setScalarValue(LocalVariableMap variables, String[] args) {
        String varname = args[0];
        if (variables != null && !variables.keySet().isEmpty()) {
            if (variables.get(varname) != null) {
                if (variables.get(varname).getDataType() == Expression.DataType.SCALAR) {
                    variables.put(varname, ScalarObjectFactory.createScalarObject(variables.get(varname).getValueType(), args[1]));
                    System.out.println(varname + " = " + variables.get(varname).toString());
                } else {
                    System.out.println("Variable \"" + varname + "\" is not scalar variable.");
                }
            } else {
                System.out.println("DML scalar variable \"" + varname + "\" is not in the current frame scope. Try \"a\" to list all variables within current frame scope.");
            }
        } else {
            System.out.println("Symbol table for current frame is empty");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void print(LocalVariableMap variables, String varname, String displayFunction, int rowIndex, int colIndex) {
        if (varname == null) {
            System.err.println("No matrix variable name entered.");
            return;
        }
        if (variables != null && !variables.keySet().isEmpty()) {
            if (variables.get(varname) != null) {
                if (variables.get(varname).getDataType() == Expression.DataType.MATRIX) {
                    try {
                        MatrixObject mo = null;
                        try {
                            mo = (MatrixObject)variables.get(varname);
                            if (mo.getStatus() == CacheableData.CacheStatus.EMPTY && (double)OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), mo.getSparsity()) > OptimizerUtils.getLocalMemBudget()) {
                                System.err.println("ERROR: Matrix dimensions are too large to fit in main memory.");
                                return;
                            }
                        }
                        catch (Exception fetchMatrixException) {
                            System.err.println("ERROR: While fetching the matrix from symbol table.");
                            return;
                        }
                        if (displayFunction.equals("value")) {
                            MatrixBlock mb = null;
                            try {
                                mb = (MatrixBlock)mo.acquireRead();
                                DMLDebuggerFunctions.prettyPrintMatrixBlock(mb, rowIndex, colIndex);
                                mo.release();
                                return;
                            }
                            catch (Exception fetchMatrixException) {
                                System.err.println("ERROR: Matrix dimensions are too large to fit in main memory.");
                                return;
                            }
                        }
                        if (!displayFunction.equals("metadata")) return;
                        System.out.println("Metadata of " + varname + ": matrix" + variables.get(varname).getMetaData().toString());
                        return;
                    }
                    catch (Exception e) {
                        String command = "";
                        command = displayFunction.equals("value") ? "print" : "whatis";
                        System.err.println("Error processing '" + command + "' command for variable " + varname + ".");
                        return;
                    }
                }
                if (variables.get(varname).getDataType() == Expression.DataType.SCALAR) {
                    if (displayFunction.equals("value")) {
                        System.out.println(varname + " = " + variables.get(varname).toString());
                        return;
                    } else {
                        if (!displayFunction.equals("metadata")) return;
                        System.out.println("Metadata of " + varname + ": DataType.SCALAR");
                    }
                    return;
                } else {
                    System.out.println("Variable \"" + varname + "\" is not a matrix or vector or scalar variable.");
                }
                return;
            }
            System.out.println("DML matrix variable \"" + varname + "\" is not in the current frame scope. Try \"info frame\" to list all variables within current frame scope.");
            return;
        }
        System.out.println("Symbol table for current frame is empty");
    }

    public void printMatrixVariable(LocalVariableMap variables, String varname) {
        if (varname == null) {
            System.err.println("No matrix variable name entered.");
            return;
        }
        if (variables != null && !variables.keySet().isEmpty()) {
            if (variables.get(varname) != null) {
                if (variables.get(varname).getDataType() == Expression.DataType.MATRIX) {
                    try {
                        MatrixObject mo = (MatrixObject)variables.get(varname);
                        if (mo.getStatus() == CacheableData.CacheStatus.EMPTY && (double)OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), mo.getSparsity()) > OptimizerUtils.getLocalMemBudget()) {
                            System.err.println("ERROR: DML matrix/vector dimensions are too large to fit in main memory.");
                            return;
                        }
                        MatrixBlock mb = (MatrixBlock)mo.acquireRead();
                        DMLDebuggerFunctions.prettyPrintMatrixBlock(mb, -1, -1);
                        mo.release();
                        if (mb.getNumRows() > 30 || mb.getNumColumns() > 8) {
                            System.out.format("WARNING: DML matrix/vector is too large to display on the screen.\nOnly a snapshot of %d row(s) and %d column(s) is being displayed.\n", DMLDebuggerFunctions.min(mb.getNumRows(), 30), DMLDebuggerFunctions.min(mb.getNumColumns(), 8));
                        }
                        System.out.println("Metadata: " + variables.get(varname).getMetaData().toString());
                    }
                    catch (Exception e) {
                        System.err.println("Error processing display DML matrix command for variable " + varname + ".");
                        return;
                    }
                } else {
                    System.out.println("Variable \"" + varname + "\" is not a matrix or vector variable.");
                }
            } else {
                System.out.println("DML matrix variable \"" + varname + "\" is not in the current frame scope. Try \"a\" to list all variables within current frame scope.");
            }
        } else {
            System.out.println("Symbol table for current frame is empty");
        }
    }

    public void printMatrixCell(LocalVariableMap variables, String[] args) {
        int columnIndex;
        int rowIndex;
        String varname = args[0];
        try {
            rowIndex = Integer.parseInt(args[1]);
            columnIndex = Integer.parseInt(args[2]);
        }
        catch (Exception e) {
            System.err.print("Invalid display cell arguments.");
            return;
        }
        if (variables != null && !variables.keySet().isEmpty()) {
            if (variables.get(varname) != null) {
                if (variables.get(varname).getDataType() == Expression.DataType.MATRIX) {
                    double cellValue;
                    try {
                        MatrixObject mo = (MatrixObject)variables.get(varname);
                        if (mo.getStatus() == CacheableData.CacheStatus.EMPTY && (double)OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), mo.getSparsity()) > OptimizerUtils.getLocalMemBudget()) {
                            System.err.println("ERROR: DML matrix/vector dimensions are too large to fit in main memory.");
                            return;
                        }
                        MatrixBlock mb = (MatrixBlock)mo.acquireRead();
                        cellValue = mb.getValue(rowIndex, columnIndex);
                        mo.release();
                    }
                    catch (Exception e) {
                        System.err.println("Error processing DML matrix variable " + varname + ". Certain matrix operations are disabled due to memory constraints or read-only restrictions.");
                        return;
                    }
                    System.out.println(varname + "[" + rowIndex + "," + columnIndex + "] = " + cellValue);
                } else {
                    System.out.println("Variable \"" + varname + "\" is not a matrix or vector variable.");
                }
            } else {
                System.out.println("DML matrix variable \"" + varname + "\" is not in the current frame scope. Try \"a\" to list all variables within current frame scope.");
            }
        } else {
            System.out.println("Symbol table for current frame is empty");
        }
    }

    public void setMatrixCell(LocalVariableMap variables, String[] args) {
        double value;
        int columnIndex;
        int rowIndex;
        String varname = args[0];
        try {
            rowIndex = Integer.parseInt(args[1]) - 1;
            columnIndex = Integer.parseInt(args[2]) - 1;
            value = Double.parseDouble(args[3]);
        }
        catch (Exception e) {
            System.err.print("Invalid set cell arguments.");
            return;
        }
        if (variables != null && !variables.keySet().isEmpty()) {
            if (variables.get(varname) != null) {
                if (variables.get(varname).getDataType() == Expression.DataType.MATRIX) {
                    double updatedCellValue;
                    try {
                        MatrixObject mo = (MatrixObject)variables.get(varname);
                        if (mo.getStatus() == CacheableData.CacheStatus.EMPTY && (double)OptimizerUtils.estimateSizeExactSparsity(mo.getNumRows(), mo.getNumColumns(), mo.getSparsity()) > OptimizerUtils.getLocalMemBudget()) {
                            System.err.println("ERROR: DML matrix/vector dimensions are too large to fit in main memory.");
                            return;
                        }
                        MatrixBlock mb = (MatrixBlock)mo.acquireRead();
                        mo.release();
                        mb.setValue(rowIndex, columnIndex, value);
                        updatedCellValue = mb.getValue(rowIndex, columnIndex);
                        mo.acquireModify(mb);
                        mo.release();
                    }
                    catch (Exception e) {
                        System.err.println("Error processing DML matrix variable " + varname + ". Certain matrix operations are disabled due to memory constraints or read-only restrictions.");
                        return;
                    }
                    System.out.println(varname + "[" + (rowIndex + 1) + "," + (columnIndex + 1) + "] = " + updatedCellValue);
                } else {
                    System.out.println("Variable \"" + varname + "\" is not a matrix or vector variable.");
                }
            } else {
                System.out.println("DML matrix variable \"" + varname + "\" is not in the current frame scope. Try \"a\" to list all variables within current frame scope.");
            }
        } else {
            System.out.println("Symbol table for current frame is empty");
        }
    }

    protected String getValue(String[] args) {
        String value = null;
        if (args != null) {
            if (args.length > 1) {
                System.err.println("Invalid number of argument values for this command. Try \"help\".");
            }
            value = args[0];
        }
        return value;
    }

    protected int getValue(String[] args, int length) {
        int lineNum = 0;
        if (args == null || args.length > 1) {
            System.err.print("Invalid argument value for this command. Parameter must be a positive integer <= " + length);
        } else {
            try {
                lineNum = Integer.parseInt(args[0]);
                if (lineNum <= 0 || lineNum > length) {
                    System.err.println("Invalid argument value for this command. Parameter must be a positive integer <= " + length);
                    lineNum = 0;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid integer format. Parameter must be a positive integer <= " + length);
                lineNum = 0;
            }
        }
        return lineNum;
    }

    protected IntRange getRange(String[] args, int length) throws DMLDebuggerException {
        IntRange range = new IntRange(1, length);
        if (args == null) {
            return range;
        }
        if (args.length == 2) {
            try {
                range = new IntRange(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
                if (range.getMinimumInteger() <= 0 || range.getMaximumInteger() > length) {
                    System.err.println("Invalid range values. Parameters <start end> must be two positive integers.");
                    range = new IntRange(0, 0);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid integer range format. Parameter must be a positive integer <= " + length);
                range = new IntRange(0, 0);
            }
        } else {
            System.err.println("Invalid range values. Parameters <start end> must be two positive integers.");
            range = new IntRange(0, 0);
        }
        return range;
    }

    private static int min(int a, int b) {
        return Math.min(a, b);
    }

    private static void prettyPrintMatrixBlock(MatrixBlock mb, int rowIndex, int colIndex) {
        if (rowIndex <= 0 && colIndex <= 0) {
            for (int i = 0; i < DMLDebuggerFunctions.min(mb.getNumRows(), 30); ++i) {
                for (int j = 0; j < DMLDebuggerFunctions.min(mb.getNumColumns(), 8); ++j) {
                    System.out.format("%.4f\t", mb.quickGetValue(i, j));
                }
                System.out.println();
            }
            if (mb.getNumRows() > 30 || mb.getNumColumns() > 8) {
                System.out.format("WARNING: DML matrix/vector is too large to display on the screen.\nOnly a snapshot of %d row(s) and %d column(s) is being displayed.\n", DMLDebuggerFunctions.min(mb.getNumRows(), 30), DMLDebuggerFunctions.min(mb.getNumColumns(), 8));
            }
        } else if (rowIndex >= 0 && colIndex >= 0) {
            System.out.format("%.4f\n", mb.quickGetValue(rowIndex - 1, colIndex - 1));
        } else if (rowIndex >= 0) {
            for (int j = 0; j < DMLDebuggerFunctions.min(mb.getNumColumns(), 8); ++j) {
                System.out.format("%.4f\t", mb.quickGetValue(rowIndex - 1, j));
            }
            System.out.println();
            if (mb.getNumColumns() > 8) {
                System.out.format("WARNING: the row of given DML matrix/vector is too large to display on the screen.\nOnly a snapshot of %d column(s) is being displayed.\n", DMLDebuggerFunctions.min(mb.getNumColumns(), 8));
            }
        } else if (colIndex >= 0) {
            for (int i = 0; i < DMLDebuggerFunctions.min(mb.getNumRows(), 30); ++i) {
                System.out.format("%.4f\t", mb.quickGetValue(i, colIndex - 1));
                System.out.println();
            }
            if (mb.getNumRows() > 30) {
                System.out.format("WARNING: the column of given DML matrix/vector is too large to display on the screen.\nOnly a snapshot of %d row(s) is being displayed.\n", DMLDebuggerFunctions.min(mb.getNumRows(), 30));
            }
        }
    }

    private static String prepareInstruction(String inst) {
        String tmp = inst;
        tmp = tmp.replaceAll("\u00b0", " ");
        tmp = tmp.replaceAll("\u00b7", ".");
        tmp = tmp.replaceAll("\u2021", ", ");
        return tmp;
    }
}

