/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Binary;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class TernaryAggregate
extends Lop {
    public static final String OPCODE_RC = "tak+*";
    public static final String OPCODE_C = "tack+*";
    private PartialAggregate.DirectionTypes _direction;
    private int _numThreads = -1;

    public TernaryAggregate(Lop input1, Lop input2, Lop input3, Aggregate.OperationTypes aggOp, Binary.OperationTypes binOp, PartialAggregate.DirectionTypes direction, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.TernaryAggregate, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this._direction = direction;
        this._numThreads = k;
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Operation: " + this.getOpCode();
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpCode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    private String getOpCode() {
        switch (this._direction) {
            case RowCol: {
                return OPCODE_RC;
            }
            case Col: {
                return OPCODE_C;
            }
        }
        throw new RuntimeException("Unsupported aggregation direction: " + (Object)((Object)this._direction));
    }
}

