/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class IndexSortStitchupMapper
extends MapReduceBase
implements Mapper<MatrixIndexes, MatrixBlock, MatrixIndexes, MatrixBlock> {
    private long[] _offsets = null;
    private long _rlen = -1L;
    private long _brlen = -1L;
    private MatrixBlock _tmpBlk = null;
    private MatrixIndexes _tmpIx = null;

    public void map(MatrixIndexes key, MatrixBlock value, OutputCollector<MatrixIndexes, MatrixBlock> out, Reporter reporter) throws IOException {
        int id = (int)key.getColumnIndex();
        long offset = this._offsets[id];
        int blksize = IndexSortStitchupMapper.computeOutputBlocksize(this._rlen, this._brlen, offset += (key.getRowIndex() - 1L) * this._brlen);
        if (offset % this._brlen == 0L && value.getNumRows() == blksize) {
            this._tmpIx.setIndexes(offset / this._brlen + 1L, 1L);
            out.collect((Object)this._tmpIx, (Object)value);
        } else {
            int loffset = (int)(offset % this._brlen);
            if ((long)(value.getNumRows() + loffset) > this._brlen) {
                long tmpnnz = 0L;
                this._tmpBlk.reset((int)this._brlen, 1);
                int i = 0;
                while ((long)i < this._brlen - (long)loffset) {
                    this._tmpBlk.quickSetValue(loffset + i, 0, value.quickGetValue(i, 0));
                    ++i;
                }
                tmpnnz += this._tmpBlk.getNonZeros();
                this._tmpIx.setIndexes(offset / this._brlen + 1L, 1L);
                out.collect((Object)this._tmpIx, (Object)this._tmpBlk);
                blksize = IndexSortStitchupMapper.computeOutputBlocksize(this._rlen, this._brlen, offset + (this._brlen - (long)loffset));
                this._tmpBlk.reset(blksize, 1);
                for (i = (int)this._brlen - loffset; i < value.getNumRows(); ++i) {
                    this._tmpBlk.quickSetValue(i - ((int)this._brlen - loffset), 0, value.quickGetValue(i, 0));
                }
                this._tmpIx.setIndexes(offset / this._brlen + 2L, 1L);
                out.collect((Object)this._tmpIx, (Object)this._tmpBlk);
                if ((tmpnnz += this._tmpBlk.getNonZeros()) != value.getNonZeros()) {
                    throw new IOException("Number of split non-zeros does not match non-zeros of original block (" + tmpnnz + " vs " + value.getNonZeros() + ")");
                }
            } else {
                this._tmpBlk.reset(blksize, 1);
                for (int i = 0; i < value.getNumRows(); ++i) {
                    this._tmpBlk.quickSetValue(loffset + i, 0, value.quickGetValue(i, 0));
                }
                this._tmpIx.setIndexes(offset / this._brlen + 1L, 1L);
                out.collect((Object)this._tmpIx, (Object)this._tmpBlk);
            }
        }
    }

    public void configure(JobConf job) {
        super.configure(job);
        this._offsets = IndexSortStitchupMapper.parseOffsets(job.get("sort.indexes.offsets"));
        this._rlen = MRJobConfiguration.getNumRows(job, (byte)0);
        this._brlen = MRJobConfiguration.getNumRowsPerBlock(job, (byte)0);
        this._tmpIx = new MatrixIndexes();
        this._tmpBlk = new MatrixBlock((int)this._brlen, 1, false);
    }

    private static long[] parseOffsets(String str) {
        String counts = str.substring(1, str.length() - 1);
        StringTokenizer st = new StringTokenizer(counts, ",");
        int len = st.countTokens();
        long[] ret = new long[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = Long.parseLong(st.nextToken().trim());
        }
        return ret;
    }

    private static int computeOutputBlocksize(long rlen, long brlen, long offset) {
        long rix = offset / brlen + 1L;
        int blksize = (int)Math.min(brlen, rlen - (rix - 1L) * brlen);
        return blksize;
    }
}

