/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.Arrays;
import java.util.List;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.RowIterator;

public class DenseRowIterator
extends RowIterator<double[]> {
    private final double[] _ret;

    public DenseRowIterator(int rl, int ru, List<ColGroup> colGroups, int clen) {
        super(rl, ru, colGroups);
        this._ret = new double[clen];
    }

    @Override
    public double[] next() {
        int blksz = 65536;
        int ix = this._rpos % 65536;
        boolean last = this._rpos + 1 == this._ru;
        Arrays.fill(this._ret, 0.0);
        for (int j = 0; j < this._iters.length; ++j) {
            this._iters[j].next(this._ret, this._rpos, ix, last);
        }
        ++this._rpos;
        return this._ret;
    }
}

