/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;

public final class ListIndexingCPInstruction
extends IndexingCPInstruction {
    protected ListIndexingCPInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(in, rl, ru, cl, cu, out, opcode, istr);
    }

    protected ListIndexingCPInstruction(CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, istr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        ScalarObject rl = ec.getScalarInput(this.rowLower);
        ScalarObject ru = ec.getScalarInput(this.rowUpper);
        if (opcode.equalsIgnoreCase("rightIndex")) {
            ListObject list = (ListObject)ec.getVariable(this.input1.getName());
            if (rl.getValueType() == Types.ValueType.STRING || ru.getValueType() == Types.ValueType.STRING) {
                ec.setVariable(this.output.getName(), list.slice(rl.getStringValue(), ru.getStringValue()));
                return;
            } else {
                ec.setVariable(this.output.getName(), list.slice((int)rl.getLongValue() - 1, (int)ru.getLongValue() - 1));
            }
            return;
        } else {
            if (!opcode.equalsIgnoreCase("leftIndex")) throw new DMLRuntimeException("Invalid opcode (" + opcode + ") encountered in ListIndexingCPInstruction.");
            ListObject lin = (ListObject)ec.getVariable(this.input1.getName());
            if (this.input2.getDataType().isList()) {
                ListObject rin = (ListObject)ec.getVariable(this.input2.getName());
                if (rl.getValueType() == Types.ValueType.STRING || ru.getValueType() == Types.ValueType.STRING) {
                    ec.setVariable(this.output.getName(), lin.copy().set(rl.getStringValue(), ru.getStringValue(), rin));
                    return;
                } else {
                    ec.setVariable(this.output.getName(), lin.copy().set((int)rl.getLongValue() - 1, (int)ru.getLongValue() - 1, rin));
                }
                return;
            } else if (this.input2.getDataType().isScalar()) {
                ScalarObject scalar = ec.getScalarInput(this.input2);
                if (rl.getValueType() == Types.ValueType.STRING) {
                    ec.setVariable(this.output.getName(), lin.copy().set(rl.getStringValue(), (Data)scalar));
                    return;
                } else {
                    ec.setVariable(this.output.getName(), lin.copy().set((int)rl.getLongValue() - 1, (Data)scalar));
                }
                return;
            } else {
                if (!this.input2.getDataType().isMatrix()) throw new DMLRuntimeException("Unsupported list left indexing rhs type: " + this.input2.getDataType().name());
                CacheableData<?> dat = ec.getCacheableData(this.input2);
                dat.enableCleanup(false);
                if (rl.getValueType() == Types.ValueType.STRING) {
                    ec.setVariable(this.output.getName(), lin.copy().set(rl.getStringValue(), dat));
                    return;
                } else {
                    ec.setVariable(this.output.getName(), lin.copy().set((int)rl.getLongValue() - 1, dat));
                }
            }
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3, this.rowLower, this.rowUpper)));
    }
}

