/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.KahanFunction;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.instructions.cp.KahanObject;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.utils.MemoryEstimates;

public class Dictionary
extends ADictionary {
    private final double[] _values;

    public Dictionary(double[] values) {
        this._values = values;
    }

    @Override
    public double[] getValues() {
        return this._values;
    }

    @Override
    public double getValue(int i) {
        return this._values[i];
    }

    @Override
    public long getInMemorySize() {
        return Dictionary.getInMemorySize(this._values.length);
    }

    protected static long getInMemorySize(int valuesCount) {
        return 16L + MemoryEstimates.doubleArrayCost(valuesCount);
    }

    @Override
    public int hasZeroTuple(int ncol) {
        int len = this._values.length / ncol;
        int i = 0;
        int off = 0;
        while (i < len) {
            boolean allZeros = true;
            for (int j = 0; j < ncol; ++j) {
                allZeros &= this._values[off + j] == 0.0;
            }
            if (allZeros) {
                return i;
            }
            ++i;
            off += ncol;
        }
        return -1;
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        int len = this._values.length;
        double ret = init;
        for (int i = 0; i < len; ++i) {
            ret = fn.execute(ret, this._values[i]);
        }
        return ret;
    }

    @Override
    public Dictionary apply(ScalarOperator op) {
        int len = this._values.length;
        for (int i = 0; i < len; ++i) {
            this._values[i] = op.executeScalar(this._values[i]);
        }
        return this;
    }

    @Override
    public Dictionary applyScalarOp(ScalarOperator op, double newVal, int numCols) {
        double[] values = Arrays.copyOf(this._values, this._values.length + numCols);
        for (int i = 0; i < this._values.length; ++i) {
            values[i] = op.executeScalar(values[i]);
        }
        Arrays.fill(values, this._values.length, this._values.length + numCols, newVal);
        return new Dictionary(values);
    }

    @Override
    public Dictionary clone() {
        return new Dictionary((double[])this._values.clone());
    }

    @Override
    public int getValuesLength() {
        return this._values.length;
    }

    public static Dictionary read(DataInput in) throws IOException {
        int numVals = in.readInt();
        double[] values = new double[numVals];
        for (int i = 0; i < numVals; ++i) {
            values[i] = in.readDouble();
        }
        return new Dictionary(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this._values.length);
        for (int i = 0; i < this._values.length; ++i) {
            out.writeDouble(this._values[i]);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        return 4 + 8 * this._values.length;
    }

    @Override
    public int getNumberOfValues(int ncol) {
        return this._values.length / ncol;
    }

    @Override
    protected double[] sumAllRowsToDouble(KahanFunction kplus, KahanObject kbuff, int nrColumns) {
        if (nrColumns == 1 && kplus instanceof KahanPlus) {
            return this.getValues();
        }
        int numVals = this._values.length / nrColumns;
        double[] ret = ColGroupValue.allocDVector(numVals, false);
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumRow(k, kplus, kbuff, nrColumns);
        }
        return ret;
    }

    @Override
    protected double sumRow(int k, KahanFunction kplus, KahanObject kbuff, int nrColumns) {
        kbuff.set(0.0, 0.0);
        int valOff = k * nrColumns;
        for (int i = 0; i < nrColumns; ++i) {
            kplus.execute2(kbuff, this._values[valOff + i]);
        }
        return kbuff._sum;
    }

    @Override
    protected void colSum(double[] c, int[] counts, int[] colIndexes, KahanFunction kplus) {
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        int k = 0;
        int valOff = 0;
        while (k < this._values.length) {
            int cntk = counts[k];
            for (int j = 0; j < colIndexes.length; ++j) {
                kbuff.set(c[colIndexes[j]], c[colIndexes[j] + colIndexes.length]);
                kplus.execute3(kbuff, this.getValue(valOff + j), cntk);
                c[colIndexes[j]] = kbuff._sum;
                c[colIndexes[j] + colIndexes.length] = kbuff._correction;
            }
            ++k;
            valOff += colIndexes.length;
        }
    }

    @Override
    protected double sum(int[] counts, int ncol, KahanFunction kplus) {
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        int k = 0;
        int valOff = 0;
        while (k < this._values.length) {
            int cntk = counts[k];
            for (int j = 0; j < ncol; ++j) {
                kplus.execute3(kbuff, this.getValue(valOff + j), cntk);
            }
            ++k;
            valOff += ncol;
        }
        return kbuff._sum;
    }
}

