/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.CompilerConfig;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.lops.Data;
import org.apache.sysds.lops.Federated;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.lops.Sql;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class DataOp
extends Hop {
    private static final Log LOG = LogFactory.getLog((String)DataOp.class.getName());
    private Types.OpOpData _op;
    private String _fileName = null;
    private Types.FileFormat _inFormat = Types.FileFormat.TEXT;
    private long _inBlocksize = -1L;
    private boolean _recompileRead = true;
    private HashMap<String, Integer> _paramIndexMap = new HashMap();

    private DataOp() {
    }

    public DataOp(String l, Types.DataType dt, Types.ValueType vt, Types.OpOpData dop, String fname, long dim1, long dim2, long nnz, int blen) {
        super(l, dt, vt);
        this._op = dop;
        this._fileName = fname;
        this.setDim1(dim1);
        this.setDim2(dim2);
        this.setBlocksize(blen);
        this.setNnz(nnz);
        if (dop == Types.OpOpData.TRANSIENTREAD) {
            this.setFileFormat(Types.FileFormat.BINARY);
        }
    }

    public DataOp(String l, Types.DataType dt, Types.ValueType vt, Types.OpOpData dop, String fname, long dim1, long dim2, long nnz, MatrixObject.UpdateType update, int blen) {
        this(l, dt, vt, dop, fname, dim1, dim2, nnz, blen);
        this.setUpdateType(update);
    }

    public DataOp(String l, Types.DataType dt, Types.ValueType vt, Types.OpOpData dop, HashMap<String, Hop> params) {
        super(l, dt, vt);
        this._op = dop;
        int index = 0;
        for (Map.Entry<String, Hop> e : params.entrySet()) {
            String s = e.getKey();
            Hop input = e.getValue();
            this.getInput().add(input);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("%15s - %s", s, input));
            }
            input.getParent().add(this);
            this._paramIndexMap.put(s, index);
            ++index;
        }
        if (dop == Types.OpOpData.TRANSIENTREAD) {
            this.setFileFormat(Types.FileFormat.BINARY);
        }
        if (params.containsKey("rows")) {
            this.setDim1(((LiteralOp)params.get("rows")).getLongValue());
        }
        if (params.containsKey("cols")) {
            this.setDim2(((LiteralOp)params.get("cols")).getLongValue());
        }
        if (params.containsKey("nnz")) {
            this.setNnz(((LiteralOp)params.get("nnz")).getLongValue());
        }
    }

    public DataOp(String l, Types.DataType dt, Types.ValueType vt, Hop in, Types.OpOpData dop, String fname) {
        super(l, dt, vt);
        this._op = dop;
        this.getInput().add(0, in);
        in.getParent().add(this);
        this._fileName = fname;
        if (dop == Types.OpOpData.TRANSIENTWRITE || dop == Types.OpOpData.FUNCTIONOUTPUT) {
            this.setFileFormat(Types.FileFormat.BINARY);
        }
    }

    public DataOp(String l, Types.DataType dt, Types.ValueType vt, Types.OpOpData dop, Hop in, HashMap<String, Hop> inputParameters) {
        super(l, dt, vt);
        this._op = dop;
        this.getInput().add(0, in);
        in.getParent().add(this);
        if (inputParameters != null) {
            int index = 1;
            for (Map.Entry<String, Hop> e : inputParameters.entrySet()) {
                String s = e.getKey();
                Hop input = e.getValue();
                this.getInput().add(input);
                input.getParent().add(this);
                this._paramIndexMap.put(s, index);
                ++index;
            }
        }
        if (dop == Types.OpOpData.TRANSIENTWRITE) {
            this.setFileFormat(Types.FileFormat.BINARY);
        }
    }

    @Override
    public void checkArity() {
        int sz = this._input.size();
        int pz = this._paramIndexMap.size();
        switch (this._op) {
            case PERSISTENTREAD: 
            case TRANSIENTREAD: 
            case SQLREAD: {
                HopsException.check(sz == pz, this, "in %s operator type has %d inputs and %d parameters", this._op.name(), sz, pz);
                break;
            }
            case PERSISTENTWRITE: 
            case TRANSIENTWRITE: 
            case FUNCTIONOUTPUT: {
                HopsException.check(sz == pz + 1, this, "in %s operator type has %d inputs and %d parameters (expect 1 more input for write operator type)", this._op.name(), sz, pz);
                break;
            }
        }
    }

    public Types.OpOpData getOp() {
        return this._op;
    }

    public void setDataOpType(Types.OpOpData type) {
        this._op = type;
    }

    public void setOutputParams(long dim1, long dim2, long nnz, MatrixObject.UpdateType update, int blen) {
        this.setDim1(dim1);
        this.setDim2(dim2);
        this.setNnz(nnz);
        this.setUpdateType(update);
        this.setBlocksize(blen);
    }

    public void setFileName(String fn) {
        this._fileName = fn;
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getParameterIndex(String name) {
        return this._paramIndexMap.get(name);
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        Types.ExecType et = this.optFindExecType();
        Lop l = null;
        HashMap<String, Lop> inputLops = new HashMap<String, Lop>();
        for (Map.Entry<String, Integer> cur : this._paramIndexMap.entrySet()) {
            inputLops.put(cur.getKey(), this.getInput().get(cur.getValue()).constructLops());
        }
        switch (this._op) {
            case TRANSIENTREAD: {
                l = new Data(this._op, null, inputLops, this.getName(), null, this.getDataType(), this.getValueType(), this.getFileFormat());
                this.setOutputDimensions(l);
                break;
            }
            case PERSISTENTREAD: {
                l = new Data(this._op, null, inputLops, this.getName(), null, this.getDataType(), this.getValueType(), this.getFileFormat());
                l.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this._inBlocksize, this.getNnz(), this.getUpdateType());
                break;
            }
            case PERSISTENTWRITE: 
            case FUNCTIONOUTPUT: {
                l = new Data(this._op, this.getInput().get(0).constructLops(), inputLops, this.getName(), null, this.getDataType(), this.getValueType(), this.getFileFormat());
                ((Data)l).setExecType(et);
                this.setOutputDimensions(l);
                break;
            }
            case TRANSIENTWRITE: {
                l = new Data(this._op, this.getInput().get(0).constructLops(), inputLops, this.getName(), null, this.getDataType(), this.getValueType(), this.getFileFormat());
                this.setOutputDimensions(l);
                break;
            }
            case SQLREAD: {
                l = new Sql(inputLops, this.getDataType(), this.getValueType());
                break;
            }
            case FEDERATED: {
                l = new Federated(inputLops, this.getDataType(), this.getValueType());
                break;
            }
            default: {
                throw new LopsException("Invalid operation type for Data LOP: " + (Object)((Object)this._op));
            }
        }
        this.setLineNumbers(l);
        this.setPrivacy(l);
        this.setLops(l);
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    public void setFileFormat(Types.FileFormat ft) {
        this._inFormat = ft;
    }

    public Types.FileFormat getFileFormat() {
        return this._inFormat;
    }

    public void setInputBlocksize(long blen) {
        this._inBlocksize = blen;
    }

    public long getInputBlocksize() {
        return this._inBlocksize;
    }

    public boolean isRead() {
        return this._op == Types.OpOpData.PERSISTENTREAD || this._op == Types.OpOpData.TRANSIENTREAD;
    }

    public boolean isWrite() {
        return this._op == Types.OpOpData.PERSISTENTWRITE || this._op == Types.OpOpData.TRANSIENTWRITE;
    }

    public boolean isPersistentReadWrite() {
        return this._op == Types.OpOpData.PERSISTENTREAD || this._op == Types.OpOpData.PERSISTENTWRITE;
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + this._op.toString();
        s = s + " " + this.getName();
        return s;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        if (this.getDataType() == Types.DataType.SCALAR) {
            switch (this.getValueType()) {
                case INT64: {
                    ret = 4.0;
                    break;
                }
                case FP64: {
                    ret = 8.0;
                    break;
                }
                case BOOLEAN: {
                    ret = 1.0;
                    break;
                }
                case STRING: {
                    ret = 100.0;
                    break;
                }
                case UNKNOWN: {
                    ret = OptimizerUtils.DEFAULT_SIZE;
                    break;
                }
                default: {
                    ret = 0.0;
                    break;
                }
            }
        } else if (this._op == Types.OpOpData.PERSISTENTREAD || this._op == Types.OpOpData.TRANSIENTREAD) {
            double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
            ret = OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
        }
        return ret;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 8192.0;
    }

    @Override
    protected DataCharacteristics inferOutputCharacteristics(MemoTable memo) {
        DataCharacteristics tmp;
        DataCharacteristics ret = null;
        if (this._op == Types.OpOpData.PERSISTENTWRITE || this._op == Types.OpOpData.TRANSIENTWRITE) {
            DataCharacteristics tmp2 = memo.getAllInputStats(this.getInput().get(0));
            if (tmp2.dimsKnown()) {
                ret = tmp2;
            }
        } else if (this._op == Types.OpOpData.TRANSIENTREAD && (tmp = memo.getAllInputStats(this)).dimsKnown()) {
            ret = tmp;
        }
        return ret;
    }

    @Override
    protected Types.ExecType optFindExecType() {
        Types.ExecType letype;
        Types.ExecType execType = letype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : null;
        if (this._op == Types.OpOpData.PERSISTENTWRITE || this._op == Types.OpOpData.TRANSIENTWRITE) {
            this.checkAndSetForcedPlatform();
            if (this.getDataType() == Types.DataType.SCALAR) {
                this._etypeForced = Types.ExecType.CP;
            }
            if (this._etypeForced != null) {
                this._etype = this._etypeForced;
            } else {
                this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? letype : (this.getInput().get(0).areDimsBelowThreshold() ? Types.ExecType.CP : Types.ExecType.SPARK);
                this.checkAndSetInvalidCPDimsAndSize();
            }
            this.setRequiresRecompileIfNecessary();
        } else {
            if (ConfigurationManager.isDynamicRecompilation() && !this.dimsKnown(true) && letype == Types.ExecType.SPARK && (this._recompileRead || this._requiresCheckpoint)) {
                this.setRequiresRecompile();
            }
            this._etype = letype;
        }
        return this._etype;
    }

    @Override
    public boolean isFederated() {
        return super.isFederated() || this.getOp() == Types.OpOpData.FEDERATED;
    }

    @Override
    public void refreshSizeInformation() {
        if (this._op == Types.OpOpData.PERSISTENTWRITE || this._op == Types.OpOpData.TRANSIENTWRITE) {
            Hop input1 = this.getInput().get(0);
            this.setDim1(input1.getDim1());
            this.setDim2(input1.getDim2());
            this.setNnz(input1.getNnz());
        } else if (this._op == Types.OpOpData.FEDERATED) {
            Hop ranges = this.getInput().get(this.getParameterIndex("ranges"));
            long nrow = -1L;
            long ncol = -1L;
            for (Hop c : ranges.getInput()) {
                if (!(c.getInput(0) instanceof LiteralOp) || !(c.getInput(1) instanceof LiteralOp)) {
                    return;
                }
                nrow = Math.max(nrow, HopRewriteUtils.getIntValueSafe(c.getInput(0)));
                ncol = Math.max(ncol, HopRewriteUtils.getIntValueSafe(c.getInput(1)));
            }
            this.setDim1(nrow);
            this.setDim2(ncol);
        }
    }

    public void disableRecompileRead() {
        this._recompileRead = false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataOp ret = new DataOp();
        ret.clone(this, false);
        ret._op = this._op;
        ret._fileName = this._fileName;
        ret._inFormat = this._inFormat;
        ret._inBlocksize = this._inBlocksize;
        ret._recompileRead = this._recompileRead;
        ret._paramIndexMap = (HashMap)this._paramIndexMap.clone();
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof DataOp)) {
            return false;
        }
        DataOp that2 = (DataOp)that;
        boolean bl = ret = OptimizerUtils.ALLOW_COMMON_SUBEXPRESSION_ELIMINATION && ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_CSE_PERSISTENT_READS) && this._op == that2._op && this._op == Types.OpOpData.PERSISTENTREAD && this._fileName.equals(that2._fileName) && this._inFormat == that2._inFormat && this._inBlocksize == that2._inBlocksize && this._paramIndexMap != null && that2._paramIndexMap != null;
        if (ret) {
            for (Map.Entry<String, Integer> e : this._paramIndexMap.entrySet()) {
                String key1 = e.getKey();
                int pos1 = e.getValue();
                int pos2 = that2._paramIndexMap.get(key1);
                ret &= that2.getInput().get(pos2) != null && this.getInput().get(pos1) == that2.getInput().get(pos2);
            }
        }
        return ret;
    }

    public void removeInput(String inputName) {
        int inputIndex = this.getParameterIndex(inputName);
        Hop tmp = (Hop)this._input.remove(inputIndex);
        tmp._parent.remove(this);
        this._paramIndexMap.remove(inputName);
        for (Map.Entry<String, Integer> entry : this._paramIndexMap.entrySet()) {
            if (entry.getValue() <= inputIndex) continue;
            this._paramIndexMap.put(entry.getKey(), entry.getValue() - 1);
        }
    }
}

