/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class CoCodeCost
extends AColumnCoCoder {
    private final int largestDistinct;
    private static final int toSmallForAnalysis = 64;

    protected CoCodeCost(CompressedSizeEstimator sizeEstimator, CompressionSettings cs) {
        super(sizeEstimator, cs);
        this.largestDistinct = Math.min(4096, Math.max(256, (int)((double)sizeEstimator.getNumRows() * cs.coCodePercentage)));
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        colInfos.setInfo(this.join(colInfos.getInfo()));
        return colInfos;
    }

    private List<CompressedSizeInfoColGroup> join(List<CompressedSizeInfoColGroup> currentGroups) {
        Comparator<CompressedSizeInfoColGroup> comp = Comparator.comparing(CompressedSizeInfoColGroup::getNumVals);
        PriorityQueue<CompressedSizeInfoColGroup> que = new PriorityQueue<CompressedSizeInfoColGroup>(currentGroups.size(), comp);
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>();
        for (CompressedSizeInfoColGroup g : currentGroups) {
            if (g == null) continue;
            que.add(g);
        }
        CompressedSizeInfoColGroup l = (CompressedSizeInfoColGroup)que.poll();
        while (que.peek() != null) {
            CompressedSizeInfoColGroup r = (CompressedSizeInfoColGroup)que.peek();
            int worstCaseJoinedSize = l.getNumVals() * r.getNumVals();
            if (worstCaseJoinedSize < 64) {
                que.poll();
                que.add(this.joinWithoutAnalysis(l, r));
            } else if (worstCaseJoinedSize < this.largestDistinct) {
                CompressedSizeInfoColGroup g = this.joinWithAnalysis(l, r);
                if (g != null && g.getNumVals() < this.largestDistinct) {
                    que.poll();
                    que.add(g);
                } else {
                    ret.add(l);
                }
            } else {
                ret.add(l);
            }
            l = (CompressedSizeInfoColGroup)que.poll();
        }
        if (l != null) {
            ret.add(l);
        }
        for (CompressedSizeInfoColGroup g : que) {
            ret.add(g);
        }
        return ret;
    }
}

