/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.util.SortUtils;

public class ColGroupUncompressed
extends AColGroup {
    private static final long serialVersionUID = 4870546053280378891L;
    private MatrixBlock _data;

    protected ColGroupUncompressed() {
    }

    public ColGroupUncompressed(int[] colIndicesList, MatrixBlock rawBlock, boolean transposed) {
        super(colIndicesList);
        int _numRows;
        int n = _numRows = transposed ? rawBlock.getNumColumns() : rawBlock.getNumRows();
        if (colIndicesList.length == 1) {
            int col = colIndicesList[0];
            if (transposed) {
                this._data = rawBlock.slice(col, col, 0, rawBlock.getNumColumns() - 1);
                this._data = LibMatrixReorg.transposeInPlace(this._data, InfrastructureAnalyzer.getLocalParallelism());
            } else {
                this._data = rawBlock.slice(0, rawBlock.getNumRows() - 1, col, col);
            }
            return;
        }
        if (rawBlock.isInSparseFormat() && transposed) {
            this._data = new MatrixBlock();
            this._data.setNumRows(_numRows);
            this._data.setNumColumns(colIndicesList.length);
        }
        this._data = new MatrixBlock(_numRows, this._colIndexes.length, rawBlock.isInSparseFormat());
        if (!SortUtils.isSorted(0, this._colIndexes.length, this._colIndexes)) {
            Arrays.sort(this._colIndexes);
        }
        if (rawBlock.isEmptyBlock(false)) {
            return;
        }
        if (!transposed && this._data.getNumColumns() == rawBlock.getNumColumns()) {
            this._data.copy(rawBlock);
            return;
        }
        int m = _numRows;
        int n2 = this._colIndexes.length;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n2; ++j) {
                double val = transposed ? rawBlock.quickGetValue(this._colIndexes[j], i) : rawBlock.quickGetValue(i, this._colIndexes[j]);
                this._data.appendValue(i, j, val);
            }
        }
        this._data.examSparsity();
    }

    protected ColGroupUncompressed(int[] colIndices, MatrixBlock data) {
        super(colIndices);
        this._data = data;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.UNCOMPRESSED;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.UNCOMPRESSED;
    }

    public MatrixBlock getData() {
        return this._data;
    }

    @Override
    public long estimateInMemorySize() {
        return ColGroupSizes.estimateInMemorySizeUncompressed(this._data.getNumRows(), this.getNumCols(), this._data.getSparsity());
    }

    @Override
    public void decompressToBlockSafe(MatrixBlock target, int rl, int ru, int offT) {
        this.decompressToBlockUnSafe(target, rl, ru, offT);
        target.setNonZeros(this._data.getNonZeros() + target.getNonZeros());
    }

    @Override
    public void decompressToBlockUnSafe(MatrixBlock target, int rl, int ru, int offT) {
        double[] c = target.getDenseBlockValues();
        int nCol = this._colIndexes.length;
        int tCol = target.getNumColumns();
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            if (sb == null) {
                return;
            }
            int row = rl;
            while (row < ru) {
                if (!sb.isEmpty(row)) {
                    int apos = sb.pos(row);
                    int alen = sb.size(row) + apos;
                    int[] aix = sb.indexes(row);
                    double[] avals = sb.values(row);
                    for (int col = apos; col < alen; ++col) {
                        int n = this._colIndexes[aix[col]] + offT;
                        c[n] = c[n] + avals[col];
                    }
                }
                ++row;
                offT += tCol;
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            offT *= tCol;
            int offS = rl * nCol;
            int row = rl;
            while (row < ru) {
                for (int j = 0; j < nCol; ++j) {
                    int n = offT + this._colIndexes[j];
                    c[n] = c[n] + values[offS + j];
                }
                ++row;
                offT += tCol;
                offS += nCol;
            }
        }
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            return 0.0;
        }
        return this._data.quickGetValue(r, ix);
    }

    @Override
    public void leftMultByMatrix(MatrixBlock matrix, MatrixBlock result, int rl, int ru) {
        MatrixBlock tmpRet = new MatrixBlock(ru - rl, this._data.getNumColumns(), false);
        tmpRet.allocateDenseBlock();
        MatrixBlock leftSlice = matrix.slice(rl, ru - 1, false);
        LibMatrixMult.matrixMult(leftSlice, this._data, tmpRet);
        int offT = result.getNumColumns() * rl;
        double[] resV = result.getDenseBlockValues();
        if (tmpRet.isEmpty()) {
            return;
        }
        if (tmpRet.isInSparseFormat()) {
            SparseBlock sb = tmpRet.getSparseBlock();
            int rowIdx = 0;
            while (rowIdx < ru - rl) {
                if (!sb.isEmpty(rowIdx)) {
                    int apos = sb.pos(rowIdx);
                    int alen = sb.size(rowIdx) + apos;
                    int[] aix = sb.indexes(rowIdx);
                    double[] avals = sb.values(rowIdx);
                    for (int col = apos; col < alen; ++col) {
                        int n = offT + this._colIndexes[aix[col]];
                        resV[n] = resV[n] + avals[col];
                    }
                }
                ++rowIdx;
                offT += result.getNumColumns();
            }
        } else {
            double[] tmpRetV = tmpRet.getDenseBlockValues();
            int j = rl;
            int offTemp = 0;
            while (j < ru) {
                for (int i = 0; i < this._colIndexes.length; ++i) {
                    int n = offT + this._colIndexes[i];
                    resV[n] = resV[n] + tmpRetV[offTemp + i];
                }
                ++j;
                offTemp += this._colIndexes.length;
                offT += result.getNumColumns();
            }
        }
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        MatrixBlock retContent = this._data.scalarOperations(op, new MatrixBlock());
        if (retContent.isEmpty()) {
            return new ColGroupEmpty(this._colIndexes, this._data.getNumRows());
        }
        return new ColGroupUncompressed(this.getColIndices(), retContent);
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        double[] selectedValues = new double[this._colIndexes.length];
        for (int i = 0; i < this._colIndexes.length; ++i) {
            selectedValues[i] = v[this._colIndexes[i]];
        }
        DenseBlockFP64 b = new DenseBlockFP64(new int[]{1, this._colIndexes.length}, selectedValues);
        MatrixBlock that = new MatrixBlock(1, this._colIndexes.length, b);
        that.setNonZeros(this._colIndexes.length);
        MatrixBlock resultBlock = new MatrixBlock();
        if (left) {
            that.binaryOperations(op, this._data, resultBlock);
        } else {
            this._data.binaryOperations(op, that, resultBlock);
        }
        return new ColGroupUncompressed(this._colIndexes, resultBlock);
    }

    @Override
    public void unaryAggregateOperations(AggregateUnaryOperator op, double[] ret) {
        this.unaryAggregateOperations(op, ret, 0, this._data.getNumRows());
    }

    @Override
    public void unaryAggregateOperations(AggregateUnaryOperator op, double[] result, int rl, int ru) {
        LOG.warn((Object)"Inefficient Unary Aggregate because of Uncompressed ColumnGroup");
        MatrixBlock tmpData = this._data.slice(rl, ru - 1, false);
        MatrixBlock tmp = tmpData.aggregateUnaryOperations(op, new MatrixBlock(), this._data.getNumRows(), new MatrixIndexes(1L, 1L), true);
        if (tmp.isEmpty()) {
            if (op.aggOp.increOp.fn instanceof Builtin) {
                Builtin b = (Builtin)op.aggOp.increOp.fn;
                if (op.indexFn instanceof ReduceRow) {
                    for (int i = 0; i < this._colIndexes.length; ++i) {
                        result[this._colIndexes[i]] = b.execute(result[this._colIndexes[i]], 0.0);
                    }
                } else if (op.indexFn instanceof ReduceAll) {
                    result[0] = b.execute(result[0], 0.0);
                } else {
                    for (int row = rl; row < ru; ++row) {
                        result[row] = b.execute(result[row], 0.0);
                    }
                }
            }
            return;
        }
        tmp.sparseToDense();
        double[] tmpV = tmp.getDenseBlockValues();
        if (op.aggOp.increOp.fn instanceof Builtin) {
            Builtin b = (Builtin)op.aggOp.increOp.fn;
            if (op.indexFn instanceof ReduceRow) {
                for (int i = 0; i < tmpV.length; ++i) {
                    result[this._colIndexes[i]] = b.execute(result[this._colIndexes[i]], tmpV[i]);
                }
            } else if (op.indexFn instanceof ReduceAll) {
                result[0] = b.execute(result[0], tmpV[0]);
            } else {
                int i = 0;
                int row = rl;
                while (i < tmpV.length) {
                    result[row] = b.execute(result[row], tmpV[i]);
                    ++i;
                    ++row;
                }
            }
        } else if (op.indexFn instanceof ReduceRow) {
            for (int i = 0; i < tmpV.length; ++i) {
                int n = this._colIndexes[i];
                result[n] = result[n] + tmpV[i];
            }
        } else if (op.indexFn instanceof ReduceAll) {
            result[0] = result[0] + tmpV[0];
        } else {
            int row = rl;
            for (int i = 0; i < tmpV.length; ++i) {
                int n = row++;
                result[n] = result[n] + tmpV[i];
            }
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this._data = new MatrixBlock();
        this._data.readFields(in);
        int numCols = this._data.getNumColumns();
        this._colIndexes = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            this._colIndexes[i] = in.readInt();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this._data.write(out);
        int len = this._data.getNumColumns();
        for (int i = 0; i < len; ++i) {
            out.writeInt(this._colIndexes[i]);
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        return this._data.getExactSizeOnDisk() + (long)(4 * this._data.getNumColumns());
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            int n = i - rl;
            rnnz[n] = (int)((long)rnnz[n] + this._data.recomputeNonZeros(i, i, 0, this._data.getNumColumns() - 1));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\n");
        sb.append(" numCols : " + this._data.getNumColumns());
        sb.append(" numRows : " + this._data.getNumRows());
        sb.append(" nonZeros: " + this._data.getNonZeros());
        sb.append(" Sparse  : " + this._data.isInSparseFormat());
        sb.append("\n");
        if (!this._data.isInSparseFormat() && this._data.getNumRows() < 100000) {
            sb.append(Arrays.toString(this._data.getDenseBlockValues()));
        } else if (this._data.getNumRows() < 100) {
            sb.append(this._data.toString());
        } else {
            sb.append(" dont print uncompressed matrix because it is to big.");
        }
        return sb.toString();
    }

    @Override
    public MatrixBlock getValuesAsBlock() {
        return this._data;
    }

    @Override
    public double[] getValues() {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            if (sb == null || sb.isEmpty(0)) {
                return null;
            }
            return this._data.getSparseBlock().values(0);
        }
        return this._data.getDenseBlock().values(0);
    }

    @Override
    public boolean isLossy() {
        return false;
    }

    @Override
    public double getMin() {
        return this._data.min();
    }

    @Override
    public double getMax() {
        return this._data.max();
    }

    @Override
    public void tsmm(double[] result, int numColumns) {
        int tCol = this._colIndexes.length;
        MatrixBlock tmp = new MatrixBlock(tCol, tCol, true);
        LibMatrixMult.matrixMultTransposeSelf(this._data, tmp, true, false);
        if (tmp.getDenseBlock() == null && tmp.getSparseBlock() == null) {
            return;
        }
        if (tmp.isInSparseFormat()) {
            throw new NotImplementedException("not Implemented sparse output of tsmm in compressed ColGroup.");
        }
        double[] tmpV = tmp.getDenseBlockValues();
        int row = 0;
        int offTmp = 0;
        while (row < tCol) {
            int offRet = this._colIndexes[row] * numColumns;
            for (int col = row; col < tCol; ++col) {
                int n = offRet + this._colIndexes[col];
                result[n] = result[n] + tmpV[offTmp + col];
            }
            ++row;
            offTmp += tCol;
        }
    }

    @Override
    public void tsmm(double[] result, int numColumns, int idxStart, int idxEnd) {
        throw new NotImplementedException();
    }

    @Override
    public AColGroup copy() {
        MatrixBlock newData = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), this._data.isInSparseFormat());
        newData.copy(this._data);
        return new ColGroupUncompressed(this._colIndexes, newData);
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._data.containsValue(pattern);
    }

    @Override
    public long getNumberNonZeros() {
        return this._data.getNonZeros();
    }

    @Override
    public int getNumRows() {
        return this._data.getNumRows();
    }

    @Override
    public boolean isDense() {
        return !this._data.isInSparseFormat();
    }

    @Override
    public void leftMultByAColGroup(AColGroup lhs, MatrixBlock result) {
        if (lhs instanceof ColGroupEmpty) {
            return;
        }
        if (lhs instanceof ColGroupUncompressed) {
            ColGroupUncompressed lhsUC = (ColGroupUncompressed)lhs;
            MatrixBlock tmpRet = new MatrixBlock(lhs.getNumCols(), this._colIndexes.length, 0L);
            if (lhsUC._data == this._data) {
                LibMatrixMult.matrixMultTransposeSelf(this._data, tmpRet, true, InfrastructureAnalyzer.getLocalParallelism());
            } else {
                LOG.warn((Object)"Inefficient Left Matrix Multiplication with transpose of left hand side : t(l) %*% r");
                MatrixBlock lhData = lhsUC._data;
                MatrixBlock transposed = new MatrixBlock(lhData.getNumColumns(), lhData.getNumRows(), false);
                LibMatrixReorg.transpose(lhData, transposed, InfrastructureAnalyzer.getLocalParallelism());
                transposed.setNonZeros(lhData.getNonZeros());
                LibMatrixMult.matrixMult(transposed, this._data, tmpRet);
            }
            double[] resV = result.getDenseBlockValues();
            if (tmpRet.isEmpty()) {
                return;
            }
            if (tmpRet.isInSparseFormat()) {
                SparseBlock sb = tmpRet.getSparseBlock();
                for (int row = 0; row < lhs._colIndexes.length; ++row) {
                    if (sb.isEmpty(row)) continue;
                    int apos = sb.pos(row);
                    int alen = sb.size(row) + apos;
                    int[] aix = sb.indexes(row);
                    double[] avals = sb.values(row);
                    int offRes = lhs._colIndexes[row] * result.getNumColumns();
                    for (int col = apos; col < alen; ++col) {
                        int n = offRes + this._colIndexes[aix[col]];
                        resV[n] = resV[n] + avals[col];
                    }
                }
            } else {
                double[] tmpRetV = tmpRet.getDenseBlockValues();
                for (int row = 0; row < lhs._colIndexes.length; ++row) {
                    int offRes = lhs._colIndexes[row] * result.getNumColumns();
                    int offTmp = lhs._colIndexes.length * row;
                    for (int col = 0; col < this._colIndexes.length; ++col) {
                        int n = offRes + this._colIndexes[col];
                        resV[n] = resV[n] + tmpRetV[offTmp + col];
                    }
                }
            }
        } else {
            LOG.warn((Object)"\nInefficient transpose of uncompressed to fit to t(AColGroup) %*% UncompressedColGroup mult by colGroup uncompressed column\nCurrently solved by t(t(Uncompressed) %*% AColGroup)");
            MatrixBlock ucCG = this.getData();
            MatrixBlock tmpTransposedResult = new MatrixBlock(ucCG.getNumColumns(), result.getNumColumns(), false);
            tmpTransposedResult.allocateDenseBlock();
            MatrixBlock tmp = new MatrixBlock(ucCG.getNumColumns(), ucCG.getNumRows(), ucCG.isInSparseFormat());
            LibMatrixReorg.transpose(ucCG, tmp, InfrastructureAnalyzer.getLocalParallelism());
            lhs.leftMultByMatrix(tmp, tmpTransposedResult);
            tmpTransposedResult.setNonZeros(ucCG.getNumColumns() * result.getNumColumns());
            double[] resV = result.getDenseBlockValues();
            int[] lhsC = lhs._colIndexes;
            int[] rhsC = this._colIndexes;
            if (tmpTransposedResult.isEmpty()) {
                return;
            }
            if (tmpTransposedResult.isInSparseFormat()) {
                throw new NotImplementedException();
            }
            double[] tmpV = tmpTransposedResult.getDenseBlockValues();
            int nCol = result.getNumColumns();
            for (int row = 0; row < rhsC.length; ++row) {
                int offR = rhsC[row];
                int offT = row * nCol;
                for (int col = 0; col < lhsC.length; ++col) {
                    int n = offR + lhsC[col] * nCol;
                    resV[n] = resV[n] + tmpV[offT + lhsC[col]];
                }
            }
        }
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        return this.sliceMultiColumns(idx, idx + 1, new int[]{0});
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, int[] outputCols) {
        try {
            MatrixBlock newData = this._data.slice(0, this._data.getNumRows() - 1, idStart, idEnd - 1, true);
            if (newData.isEmpty()) {
                return new ColGroupEmpty(outputCols, newData.getNumRows());
            }
            return new ColGroupUncompressed(outputCols, newData);
        }
        catch (Exception e) {
            throw new DMLCompressionException("Error in slicing of uncompressed column group", e);
        }
    }

    @Override
    public AColGroup rightMultByMatrix(MatrixBlock right) {
        MatrixBlock subBlockRight;
        int nColR = right.getNumColumns();
        int[] outputCols = new int[nColR];
        for (int i = 0; i < outputCols.length; ++i) {
            outputCols[i] = i;
        }
        if (this._data.isEmpty() || right.isEmpty()) {
            return new ColGroupEmpty(outputCols, this._data.getNumRows());
        }
        if (right.isInSparseFormat()) {
            subBlockRight = new MatrixBlock(this._data.getNumColumns(), nColR, true);
            subBlockRight.allocateSparseRowsBlock();
            SparseBlock sbR = right.getSparseBlock();
            SparseBlock subR = subBlockRight.getSparseBlock();
            for (int i = 0; i < this._colIndexes.length; ++i) {
                subR.set(i, sbR.get(this._colIndexes[i]), false);
            }
        } else {
            subBlockRight = new MatrixBlock(this._data.getNumColumns(), nColR, false);
            subBlockRight.allocateDenseBlock();
            double[] sbr = subBlockRight.getDenseBlockValues();
            double[] rightV = right.getDenseBlockValues();
            for (int i = 0; i < this._colIndexes.length; ++i) {
                int offSubBlock = i * nColR;
                int offRight = this._colIndexes[i] * nColR;
                System.arraycopy(rightV, offRight, sbr, offSubBlock, nColR);
            }
        }
        subBlockRight.setNonZeros(this._data.getNumColumns() * nColR);
        MatrixBlock out = new MatrixBlock(this._data.getNumRows(), nColR, false);
        LibMatrixMult.matrixMult(this._data, subBlockRight, out, InfrastructureAnalyzer.getLocalParallelism());
        return new ColGroupUncompressed(outputCols, out);
    }

    @Override
    public int getNumValues() {
        return this._data.getNumRows();
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        MatrixBlock replaced = this._data.replaceOperations(new MatrixBlock(), pattern, replace);
        return new ColGroupUncompressed(this._colIndexes, replaced);
    }
}

