/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu.context;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageGPUCacheEviction;
import org.apache.sysds.utils.GPUStatistics;

public class GPUMemoryEviction
implements Runnable {
    int numEvicts = 0;

    public GPUMemoryEviction(int num) {
        this.numEvicts = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long t0;
        ArrayList<LineageCacheEntry> lockedOrLiveEntries = new ArrayList<LineageCacheEntry>();
        int count = 0;
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        while (!LineageGPUCacheEviction.isGPUCacheEmpty() && count < this.numEvicts && !LineageCacheConfig.STOPBACKGROUNDEVICTION) {
            LineageCacheEntry le = LineageGPUCacheEviction.pollFirstEntry();
            GPUObject cachedGpuObj = le.getGPUObject();
            GPUObject headGpuObj = cachedGpuObj.lineageCachedChainHead != null ? cachedGpuObj.lineageCachedChainHead : cachedGpuObj;
            boolean lockedOrLive = false;
            GPUObject nextgpuObj = headGpuObj;
            while (nextgpuObj != null) {
                if (!nextgpuObj.isrmVarPending() || nextgpuObj.isLocked()) {
                    lockedOrLive = true;
                }
                nextgpuObj = nextgpuObj.nextLineageCachedEntry;
            }
            if (lockedOrLive) {
                lockedOrLiveEntries.add(le);
                continue;
            }
            boolean copied = false;
            nextgpuObj = headGpuObj;
            while (nextgpuObj != null) {
                if (!nextgpuObj.isrmVarPending() && nextgpuObj.isDirty()) {
                    nextgpuObj.copyFromDeviceToHost(null, true, true);
                    copied = true;
                }
                nextgpuObj.setIsLinCached(false);
                nextgpuObj = nextgpuObj.nextLineageCachedEntry;
            }
            LineageGPUCacheEviction.copyToHostCache(le, null, copied);
            nextgpuObj = headGpuObj;
            boolean freed = false;
            HashSet<GPUObject> hashSet = nextgpuObj.getGPUContext().getMemoryManager().getGPUMatrixMemoryManager().gpuObjects;
            synchronized (hashSet) {
                while (nextgpuObj != null) {
                    if (nextgpuObj.isrmVarPending() || !nextgpuObj.isDirty()) {
                        if (!freed) {
                            nextgpuObj.clearData(null, true);
                            freed = true;
                        } else {
                            nextgpuObj.clearGPUObject();
                        }
                    }
                    nextgpuObj = nextgpuObj.nextLineageCachedEntry;
                }
            }
            GPUObject currgpuObj = headGpuObj;
            while (currgpuObj.nextLineageCachedEntry != null) {
                nextgpuObj = currgpuObj.nextLineageCachedEntry;
                currgpuObj.lineageCachedChainHead = null;
                currgpuObj.nextLineageCachedEntry = null;
                nextgpuObj.lineageCachedChainHead = null;
                currgpuObj = nextgpuObj;
            }
            if (DMLScript.STATISTICS) {
                LineageCacheStatistics.incrementGpuAsyncEvicts();
            }
            ++count;
        }
        if (!lockedOrLiveEntries.isEmpty()) {
            LineageGPUCacheEviction.addEntryList(lockedOrLiveEntries);
        }
        if (DMLScript.STATISTICS) {
            GPUStatistics.cudaEvictTime.add(System.nanoTime() - t0);
        }
    }
}

