/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.SPInstructionParser;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstructionUtils;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.utils.Statistics;

public abstract class SPInstruction
extends Instruction {
    protected final SPType _sptype;
    protected final boolean _requiresLabelUpdate;

    protected SPInstruction(SPType type, String opcode, String istr) {
        this(type, null, opcode, istr);
    }

    protected SPInstruction(SPType type, Operator op, String opcode, String istr) {
        super(op);
        this._sptype = type;
        this.instString = istr;
        this.instOpcode = opcode;
        this._requiresLabelUpdate = super.requiresLabelUpdate();
    }

    @Override
    public Instruction.IType getType() {
        return Instruction.IType.SPARK;
    }

    public SPType getSPInstructionType() {
        return this._sptype;
    }

    @Override
    public boolean requiresLabelUpdate() {
        return this._requiresLabelUpdate;
    }

    @Override
    public String getGraphString() {
        return this.getOpcode();
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) {
        Instruction tmp = super.preprocessInstruction(ec);
        if (tmp.requiresLabelUpdate()) {
            String updInst = CPInstruction.updateLabels(tmp.toString(), ec.getVariables());
            tmp = SPInstructionParser.parseSingleInstruction(updInst);
        }
        tmp = FEDInstructionUtils.checkAndReplaceSP(tmp, ec);
        return tmp;
    }

    @Override
    public abstract void processInstruction(ExecutionContext var1);

    @Override
    public void postprocessInstruction(ExecutionContext ec) {
        Statistics.incrementNoOfExecutedSPInst();
        super.postprocessInstruction(ec);
    }

    public static enum SPType {
        MAPMM,
        MAPMMCHAIN,
        CPMM,
        RMM,
        TSMM,
        TSMM2,
        PMM,
        ZIPMM,
        PMAPMM,
        MatrixIndexing,
        Reorg,
        Binary,
        Ternary,
        AggregateUnary,
        AggregateTernary,
        Reblock,
        CSVReblock,
        LIBSVMReblock,
        Builtin,
        Unary,
        BuiltinNary,
        MultiReturnBuiltin,
        Checkpoint,
        Compression,
        DeCompression,
        Cast,
        CentralMoment,
        Covariance,
        QSort,
        QPick,
        ParameterizedBuiltin,
        MAppend,
        RAppend,
        GAppend,
        GAlignedAppend,
        Rand,
        MatrixReshape,
        Ctable,
        Quaternary,
        CumsumAggregate,
        CumsumOffset,
        BinUaggChain,
        UaggOuterChain,
        Write,
        SpoofFused,
        Dnn;

    }
}

