/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.util.UtilFunctions;

public class ColumnEncoderFeatureHash
extends ColumnEncoder {
    private static final long serialVersionUID = 7435806042138687342L;
    private long _K;

    public ColumnEncoderFeatureHash(int colID, long K) {
        super(colID);
        this._K = K;
    }

    public ColumnEncoderFeatureHash() {
        super(-1);
        this._K = 0L;
    }

    private long getCode(String key) {
        return (long)key.hashCode() % this._K;
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public List<Callable<Object>> getPartialBuildTasks(FrameBlock in, int blockSize) {
        return null;
    }

    @Override
    public void mergeBuildPartial(List<Future<Object>> futurePartials, int start, int end) {
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol) {
        return this.apply(in, out, outputCol, 0, -1);
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        for (int i = rowStart; i < UtilFunctions.getEndIndex(in.getNumRows(), rowStart, blk); ++i) {
            String key;
            Object okey = in.get(i, this._colID - 1);
            String string = key = okey != null ? okey.toString() : null;
            if (key == null) {
                throw new DMLRuntimeException("Missing Value encountered in input Frame for FeatureHash");
            }
            long code = this.getCode(key);
            out.quickSetValueThreadSafe(i, outputCol, code >= 0L ? (double)code : Double.NaN);
        }
        return out;
    }

    @Override
    public MatrixBlock apply(MatrixBlock in, MatrixBlock out, int outputCol, int rowStart, int blk) {
        int end = blk <= 0 ? in.getNumRows() : (in.getNumRows() < rowStart + blk ? in.getNumRows() : rowStart + blk);
        for (int i = rowStart; i < end; ++i) {
            Double okey = in.quickGetValueThreadSafe(i, this._colID - 1);
            String key = ((Object)okey).toString();
            long code = this.getCode(key);
            out.quickSetValueThreadSafe(i, outputCol, code >= 0L ? (double)code : Double.NaN);
        }
        return out;
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (other instanceof ColumnEncoderFeatureHash) {
            assert (other._colID == this._colID);
            if (((ColumnEncoderFeatureHash)other)._K != 0L && this._K == 0L) {
                this._K = ((ColumnEncoderFeatureHash)other)._K;
            }
            return;
        }
        super.mergeAt(other);
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        if (!this.isApplicable()) {
            return meta;
        }
        meta.ensureAllocatedColumns(1);
        meta.set(0, this._colID - 1, String.valueOf(this._K));
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        this._K = UtilFunctions.parseToLong(meta.get(0, this._colID - 1).toString());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this._K);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        this._K = in.readLong();
    }
}

