/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupSDCSingle
extends ColGroupValue {
    private static final long serialVersionUID = -32043916423465004L;
    protected AOffset _indexes;

    protected ColGroupSDCSingle(int numRows) {
        super(numRows);
    }

    protected ColGroupSDCSingle(int[] colIndices, int numRows, ADictionary dict, int[] indexes, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = OffsetFactory.create(indexes, numRows);
        this._zeros = false;
    }

    protected ColGroupSDCSingle(int[] colIndices, int numRows, ADictionary dict, AOffset offsets, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = offsets;
        this._zeros = false;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCSingle;
    }

    @Override
    protected void decompressToBlockUnSafeDenseDictionary(MatrixBlock target, int rl, int ru, int offT, double[] values) {
        int j;
        int nCol = this._colIndexes.length;
        int tCol = target.getNumColumns();
        int offsetToDefault = values.length - nCol;
        double[] c = target.getDenseBlockValues();
        offT *= tCol;
        int i = rl;
        AIterator it = this._indexes.getIterator();
        it.skipTo(rl);
        while (i < ru && it.hasNext()) {
            if (it.value() == i) {
                for (j = 0; j < nCol; ++j) {
                    int n = offT + this._colIndexes[j];
                    c[n] = c[n] + values[j];
                }
                it.next();
            } else {
                for (j = 0; j < nCol; ++j) {
                    int n = offT + this._colIndexes[j];
                    c[n] = c[n] + values[offsetToDefault + j];
                }
            }
            ++i;
            offT += tCol;
        }
        while (i < ru) {
            for (j = 0; j < nCol; ++j) {
                int n = offT + this._colIndexes[j];
                c[n] = c[n] + values[offsetToDefault + j];
            }
            ++i;
            offT += tCol;
        }
    }

    @Override
    protected void decompressToBlockUnSafeSparseDictionary(MatrixBlock target, int rl, int ru, int offT, SparseBlock values) {
        throw new NotImplementedException();
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in group.");
        }
        AIterator it = this._indexes.getIterator(r);
        if (it.value() == r) {
            return this._dict.getValue(ix);
        }
        return this._dict.getValue(this._colIndexes.length + ix);
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
        int rix;
        double[] vals = this._dict.sumAllRowsToDouble(square, this._colIndexes.length);
        AIterator it = this._indexes.getIterator();
        it.skipTo(rl);
        for (rix = rl; rix < ru && it.hasNext(); ++rix) {
            if (it.value() != rix) {
                int n = rix;
                c[n] = c[n] + vals[1];
                continue;
            }
            int n = rix;
            c[n] = c[n] + vals[0];
            it.next();
        }
        while (rix < ru) {
            int n = rix++;
            c[n] = c[n] + vals[1];
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int rix;
        double[] vals = this._dict.aggregateTuples(builtin, this._colIndexes.length);
        AIterator it = this._indexes.getIterator();
        it.skipTo(rl);
        for (rix = rl; rix < ru && it.hasNext(); ++rix) {
            if (it.value() != rix) {
                c[rix] = builtin.execute(c[rix], vals[1]);
                continue;
            }
            c[rix] = builtin.execute(c[rix], vals[0]);
            it.next();
        }
        while (rix < ru) {
            c[rix] = builtin.execute(c[rix], vals[1]);
            ++rix;
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        counts[0] = this._indexes.getSize();
        counts[1] = this._numRows - counts[0];
        return counts;
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        AIterator it = this._indexes.getIterator();
        it.skipTo(rl);
        while (it.hasNext() && it.value() < ru) {
            it.next();
            counts[0] = counts[0] + 1;
        }
        counts[1] = ru - rl - counts[0];
        return counts;
    }

    @Override
    protected void preAggregate(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        if (m.isInSparseFormat()) {
            this.preAggregateSparse(m.getSparseBlock(), preAgg, rl, ru);
        } else {
            this.preAggregateDense(m, preAgg, rl, ru);
        }
    }

    private void preAggregateDense(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        double[] mV = m.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            AIterator it = this._indexes.getIterator();
            int def = offOut + 1;
            int rc = 0;
            int offLeft = rowLeft * this._numRows;
            while (rc < this._numRows) {
                if (it.value() == rc) {
                    int n = offOut;
                    preAV[n] = preAV[n] + mV[offLeft];
                    it.next();
                } else {
                    int n = def;
                    preAV[n] = preAV[n] + mV[offLeft];
                }
                ++rc;
                ++offLeft;
            }
            while (rc < this._numRows) {
                int n = def;
                preAV[n] = preAV[n] + mV[offLeft];
                ++rc;
                ++offLeft;
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    private void preAggregateSparse(SparseBlock sb, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            if (!sb.isEmpty(rowLeft)) {
                int j;
                AIterator it = this._indexes.getIterator();
                int apos = sb.pos(rowLeft);
                int alen = sb.size(rowLeft) + apos;
                int[] aix = sb.indexes(rowLeft);
                double[] avals = sb.values(rowLeft);
                int def = offOut + 1;
                for (j = apos; it.hasNext() && j < alen; ++j) {
                    int index = aix[j];
                    it.skipTo(index);
                    if (index == it.value()) {
                        int n = offOut;
                        preAV[n] = preAV[n] + avals[j];
                        it.next();
                        continue;
                    }
                    int n = def;
                    preAV[n] = preAV[n] + avals[j];
                }
                while (j < alen) {
                    int n = def;
                    preAV[n] = preAV[n] + avals[j];
                    ++j;
                }
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size += this._indexes.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        return new ColGroupSDCSingle(this._colIndexes, this._numRows, this.applyScalarOp(op), this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        return new ColGroupSDCSingle(this._colIndexes, this._numRows, this.applyBinaryRowOp(op, v, true, left), this._indexes, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._indexes = OffsetFactory.readIn(in);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        return ret += this._indexes.getExactSizeOnDisk();
    }

    @Override
    public boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupSDCSingle && ((ColGroupSDCSingle)that)._indexes == this._indexes;
    }

    @Override
    public int getIndexStructureHash() {
        return this._indexes.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s ", "Indexes: "));
        sb.append(this._indexes.toString());
        return sb.toString();
    }

    @Override
    public Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        if (preModified) {
            while (itThat.hasNext() && itThis.hasNext()) {
                if (itThat.value() == itThis.value()) {
                    int fr = that.getIndex(itThat.getDataIndexAndIncrement());
                    that._dict.addToEntry(ret, fr, 1, nCol);
                    continue;
                }
                if (itThat.value() < itThis.value()) {
                    itThat.next();
                    continue;
                }
                itThis.next();
            }
        } else {
            throw new NotImplementedException();
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary ret, boolean preModified) {
        int to;
        int i;
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        if (preModified) {
            while (itThat.hasNext() && itThis.hasNext()) {
                if (itThat.value() == itThis.value()) {
                    itThat.next();
                    itThis.next();
                    that._dict.addToEntry(ret, 1, 0, nCol);
                    continue;
                }
                if (itThat.value() < itThis.value()) {
                    itThat.next();
                    continue;
                }
                itThis.next();
            }
            return ret;
        }
        for (i = 0; i < this._numRows && itThat.hasNext() && itThis.hasNext(); ++i) {
            to = 0;
            if (itThis.value() == i) {
                itThis.next();
                to = 1;
            }
            int fr = 0;
            if (itThat.value() == i) {
                itThat.next();
                fr = 1;
            }
            that._dict.addToEntry(ret, fr, to, nCol);
        }
        if (itThat.hasNext()) {
            while (i < this._numRows && itThat.hasNext()) {
                int fr = 0;
                if (itThat.value() == i) {
                    itThat.next();
                    fr = 1;
                }
                that._dict.addToEntry(ret, fr, 1, nCol);
                ++i;
            }
        }
        if (itThis.hasNext()) {
            while (i < this._numRows && itThis.hasNext()) {
                to = 0;
                if (itThis.value() == i) {
                    itThis.next();
                    to = 1;
                }
                that._dict.addToEntry(ret, 1, to, nCol);
                ++i;
            }
        }
        while (i < this._numRows) {
            that._dict.addToEntry(ret, 1, 1, nCol);
            ++i;
        }
        return ret;
    }
}

