/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.util.ArrayList;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CacheBlockFactory {
    public static CacheBlock newInstance(int code) {
        switch (code) {
            case 0: {
                return new MatrixBlock();
            }
            case 1: {
                return new FrameBlock();
            }
            case 2: {
                return new TensorBlock();
            }
        }
        throw new RuntimeException("Unsupported cache block type: " + code);
    }

    public static int getCode(CacheBlock block) {
        if (block instanceof MatrixBlock) {
            return 0;
        }
        if (block instanceof FrameBlock) {
            return 1;
        }
        if (block instanceof TensorBlock) {
            return 2;
        }
        throw new RuntimeException("Unsupported cache block type: " + block.getClass().getName());
    }

    public static ArrayList<?> getPairList(CacheBlock block) {
        int code = CacheBlockFactory.getCode(block);
        switch (code) {
            case 0: {
                return new ArrayList();
            }
            case 1: {
                return new ArrayList();
            }
            case 2: {
                return new ArrayList();
            }
        }
        throw new RuntimeException("Unsupported cache block type: " + code);
    }
}

