/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedLocalData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.CM;
import org.apache.sysds.runtime.functionobjects.KahanFunction;
import org.apache.sysds.runtime.functionobjects.Mean;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.SimpleOperator;

public class FederationUtils {
    protected static Logger log = Logger.getLogger(FederationUtils.class);
    private static final IDSequence _idSeq = new IDSequence();

    public static void resetFedDataID() {
        _idSeq.reset();
    }

    public static long getNextFedDataID() {
        return _idSeq.getNextID();
    }

    public static FederatedRequest callInstruction(String inst, CPOperand varOldOut, CPOperand[] varOldIn, long[] varNewIn, boolean rmFedOutFlag) {
        long id = FederationUtils.getNextFedDataID();
        String linst = InstructionUtils.instructionStringFEDPrepare(inst, varOldOut, id, varOldIn, varNewIn, rmFedOutFlag);
        return new FederatedRequest(FederatedRequest.RequestType.EXEC_INST, id, linst);
    }

    public static FederatedRequest callInstruction(String inst, CPOperand varOldOut, CPOperand[] varOldIn, long[] varNewIn) {
        return FederationUtils.callInstruction(inst, varOldOut, varOldIn, varNewIn, false);
    }

    public static FederatedRequest[] callInstruction(String[] inst, CPOperand varOldOut, CPOperand[] varOldIn, long[] varNewIn) {
        long id = FederationUtils.getNextFedDataID();
        String[] linst = inst;
        FederatedRequest[] fr = new FederatedRequest[inst.length];
        for (int j = 0; j < inst.length; ++j) {
            for (int i = 0; i < varOldIn.length; ++i) {
                linst[j] = linst[j].replace(Types.ExecType.SPARK.name(), Types.ExecType.CP.name());
                linst[j] = linst[j].replace("\u00b0" + varOldOut.getName() + "\u00b7", "\u00b0" + String.valueOf(id) + "\u00b7");
                if (varOldIn[i] == null) continue;
                linst[j] = linst[j].replace("\u00b0" + varOldIn[i].getName() + "\u00b7", "\u00b0" + String.valueOf(varNewIn[i]) + "\u00b7");
                linst[j] = linst[j].replace("=" + varOldIn[i].getName(), "=" + String.valueOf(varNewIn[i]));
            }
            fr[j] = new FederatedRequest(FederatedRequest.RequestType.EXEC_INST, id, linst[j]);
        }
        return fr;
    }

    public static FederatedRequest callInstruction(String inst, CPOperand varOldOut, long outputId, CPOperand[] varOldIn, long[] varNewIn) {
        String linst = InstructionUtils.replaceOperand(inst, 0, Types.ExecType.CP.name());
        linst = linst.replace("\u00b0" + varOldOut.getName() + "\u00b7", "\u00b0" + outputId + "\u00b7");
        for (int i = 0; i < varOldIn.length; ++i) {
            if (varOldIn[i] == null) continue;
            linst = linst.replace("\u00b0" + varOldIn[i].getName() + "\u00b7", "\u00b0" + varNewIn[i] + "\u00b7");
            linst = linst.replace("=" + varOldIn[i].getName(), "=" + varNewIn[i]);
        }
        return new FederatedRequest(FederatedRequest.RequestType.EXEC_INST, outputId, linst);
    }

    public static MatrixBlock aggAdd(Future<FederatedResponse>[] ffr) {
        try {
            SimpleOperator op = new SimpleOperator(Plus.getPlusFnObject());
            MatrixBlock[] in = new MatrixBlock[ffr.length];
            for (int i = 0; i < ffr.length; ++i) {
                in[i] = (MatrixBlock)ffr[i].get().getData()[0];
            }
            return MatrixBlock.naryOperations(op, in, new ScalarObject[0], new MatrixBlock());
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock aggMean(Future<FederatedResponse>[] ffr, FederationMap map) {
        try {
            FederatedRange[] ranges = map.getFederatedRanges();
            BinaryOperator bop = InstructionUtils.parseBinaryOperator("+");
            ScalarOperator sop1 = InstructionUtils.parseScalarBinaryOperator("*", false);
            MatrixBlock ret = null;
            long size = 0L;
            for (int i = 0; i < ffr.length; ++i) {
                Object input = ffr[i].get().getData()[0];
                MatrixBlock tmp = input instanceof ScalarObject ? new MatrixBlock(((ScalarObject)input).getDoubleValue()) : (MatrixBlock)input;
                size += ranges[i].getSize(0);
                sop1 = sop1.setConstant(ranges[i].getSize(0));
                tmp = tmp.scalarOperations(sop1, new MatrixBlock());
                ret = ret == null ? tmp : ret.binaryOperationsInPlace(bop, tmp);
            }
            ScalarOperator sop2 = InstructionUtils.parseScalarBinaryOperator("/", false);
            sop2 = sop2.setConstant(size);
            return ret.scalarOperations(sop2, new MatrixBlock());
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock[] getResults(Future<FederatedResponse>[] ffr) {
        try {
            MatrixBlock[] ret = new MatrixBlock[ffr.length];
            for (int i = 0; i < ffr.length; ++i) {
                ret[i] = (MatrixBlock)ffr[i].get().getData()[0];
            }
            return ret;
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock bind(Future<FederatedResponse>[] ffr, boolean cbind) {
        try {
            MatrixBlock[] tmp = FederationUtils.getResults(ffr);
            return tmp[0].append(Arrays.copyOfRange(tmp, 1, tmp.length), new MatrixBlock(), cbind);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock aggMinMax(Future<FederatedResponse>[] ffr, boolean isMin, boolean isScalar, Optional<FederationMap.FType> fedType) {
        try {
            if (!fedType.isPresent() || fedType.get() == FederationMap.FType.OTHER) {
                double res = isMin ? Double.MAX_VALUE : -1.7976931348623157E308;
                for (Future<FederatedResponse> fr : ffr) {
                    double v = isScalar ? ((ScalarObject)fr.get().getData()[0]).getDoubleValue() : (isMin ? ((MatrixBlock)fr.get().getData()[0]).min() : ((MatrixBlock)fr.get().getData()[0]).max());
                    res = isMin ? Math.min(res, v) : Math.max(res, v);
                }
                return new MatrixBlock(1, 1, res);
            }
            MatrixBlock[] tmp = FederationUtils.getResults(ffr);
            int dim = fedType.get() == FederationMap.FType.COL ? tmp[0].getNumRows() : tmp[0].getNumColumns();
            for (int i = 0; i < ffr.length - 1; ++i) {
                for (int j = 0; j < dim; ++j) {
                    if (fedType.get() == FederationMap.FType.COL) {
                        tmp[i + 1].setValue(j, 0, isMin ? Double.min(tmp[i].getValue(j, 0), tmp[i + 1].getValue(j, 0)) : Double.max(tmp[i].getValue(j, 0), tmp[i + 1].getValue(j, 0)));
                        continue;
                    }
                    tmp[i + 1].setValue(0, j, isMin ? Double.min(tmp[i].getValue(0, j), tmp[i + 1].getValue(0, j)) : Double.max(tmp[i].getValue(0, j), tmp[i + 1].getValue(0, j)));
                }
            }
            return tmp[ffr.length - 1];
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock aggProd(Future<FederatedResponse>[] ffr, FederationMap fedMap, AggregateUnaryOperator aop) {
        try {
            boolean rowFed = fedMap.getType() == FederationMap.FType.ROW;
            MatrixBlock ret = rowFed ? new MatrixBlock(ffr.length, (int)fedMap.getFederatedRanges()[0].getEndDims()[1], 1.0) : new MatrixBlock((int)fedMap.getFederatedRanges()[0].getEndDims()[0], ffr.length, 1.0);
            MatrixBlock res = rowFed ? new MatrixBlock(1, (int)fedMap.getFederatedRanges()[0].getEndDims()[1], 1.0) : new MatrixBlock((int)fedMap.getFederatedRanges()[0].getEndDims()[0], 1, 1.0);
            for (int i = 0; i < ffr.length; ++i) {
                MatrixBlock tmp = (MatrixBlock)ffr[i].get().getData()[0];
                if (rowFed) {
                    ret.copy(i, i, 0, ret.getNumColumns() - 1, tmp, true);
                    continue;
                }
                ret.copy(0, ret.getNumRows() - 1, i, i, tmp, true);
            }
            LibMatrixAgg.aggregateUnaryMatrix(ret, res, aop);
            return res;
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock aggMinMaxIndex(Future<FederatedResponse>[] ffr, boolean isMin, FederationMap map) {
        try {
            MatrixBlock prev = (MatrixBlock)ffr[0].get().getData()[0];
            int size = 0;
            for (int i = 1; i < ffr.length; ++i) {
                MatrixBlock next = (MatrixBlock)ffr[i].get().getData()[0];
                size = map.getFederatedRanges()[i - 1].getEndDimsInt()[1];
                for (int j = 0; j < prev.getNumRows(); ++j) {
                    next.setValue(j, 0, next.getValue(j, 0) + (double)size);
                    if (!(prev.getValue(j, 1) > next.getValue(j, 1) && !isMin) && (!(prev.getValue(j, 1) < next.getValue(j, 1)) || !isMin)) continue;
                    next.setValue(j, 0, prev.getValue(j, 0));
                    next.setValue(j, 1, prev.getValue(j, 1));
                }
                prev = next;
            }
            return prev.slice(0, prev.getNumRows() - 1, 0, 0, true, new MatrixBlock());
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock aggVar(Future<FederatedResponse>[] ffr, Future<FederatedResponse>[] meanFfr, FederationMap map, boolean isRowAggregate, boolean isScalar) {
        try {
            FederatedRange[] ranges = map.getFederatedRanges();
            BinaryOperator plus = InstructionUtils.parseBinaryOperator("+");
            BinaryOperator minus = InstructionUtils.parseBinaryOperator("-");
            ScalarOperator mult1 = InstructionUtils.parseScalarBinaryOperator("*", false);
            ScalarOperator dev1 = InstructionUtils.parseScalarBinaryOperator("/", false);
            ScalarOperator pow = InstructionUtils.parseScalarBinaryOperator("^2", false);
            long size1 = isScalar ? ranges[0].getSize() : ranges[0].getSize(isRowAggregate ? 1 : 0);
            MatrixBlock var1 = (MatrixBlock)ffr[0].get().getData()[0];
            MatrixBlock mean1 = (MatrixBlock)meanFfr[0].get().getData()[0];
            for (int i = 0; i < ffr.length - 1; ++i) {
                MatrixBlock var2 = (MatrixBlock)ffr[i + 1].get().getData()[0];
                MatrixBlock mean2 = (MatrixBlock)meanFfr[i + 1].get().getData()[0];
                long size2 = isScalar ? ranges[i + 1].getSize() : ranges[i + 1].getSize(isRowAggregate ? 1 : 0);
                mult1 = mult1.setConstant(size1);
                var1 = var1.scalarOperations(mult1, new MatrixBlock());
                mult1 = mult1.setConstant(size2);
                var1 = var1.binaryOperationsInPlace(plus, var2.scalarOperations(mult1, new MatrixBlock()));
                dev1 = dev1.setConstant(size1 + size2);
                var1 = var1.scalarOperations(dev1, new MatrixBlock());
                MatrixBlock tmp1 = new MatrixBlock(mean1);
                tmp1 = tmp1.binaryOperationsInPlace(minus, mean2);
                tmp1 = tmp1.scalarOperations(dev1, new MatrixBlock());
                tmp1 = tmp1.scalarOperations(pow, new MatrixBlock());
                mult1 = mult1.setConstant(size1 * size2);
                tmp1 = tmp1.scalarOperations(mult1, new MatrixBlock());
                var1 = tmp1.binaryOperationsInPlace(plus, var1);
                mult1 = mult1.setConstant(size1);
                tmp1 = mean1.scalarOperations(mult1, new MatrixBlock());
                mult1 = mult1.setConstant(size2);
                mean1 = tmp1.binaryOperationsInPlace(plus, mean2.scalarOperations(mult1, new MatrixBlock()));
                mean1 = mean1.scalarOperations(dev1, new MatrixBlock());
                size1 += size2;
            }
            return var1;
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static ScalarObject aggScalar(AggregateUnaryOperator aop, Future<FederatedResponse>[] ffr, Future<FederatedResponse>[] meanFfr, FederationMap map) {
        if (!(aop.aggOp.increOp.fn instanceof KahanFunction || aop.aggOp.increOp.fn instanceof CM || aop.aggOp.increOp.fn instanceof Builtin && (((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN || ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX) || aop.aggOp.increOp.fn instanceof Mean)) {
            throw new DMLRuntimeException("Unsupported aggregation operator: " + aop.aggOp.increOp.getClass().getSimpleName());
        }
        try {
            if (aop.aggOp.increOp.fn instanceof Builtin) {
                boolean isMin = ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN;
                return new DoubleObject(FederationUtils.aggMinMax(ffr, isMin, true, Optional.empty()).getValue(0, 0));
            }
            if (aop.aggOp.increOp.fn instanceof Mean) {
                return new DoubleObject(FederationUtils.aggMean(ffr, map).getValue(0, 0));
            }
            if (aop.aggOp.increOp.fn instanceof CM) {
                double var = ((ScalarObject)ffr[0].get().getData()[0]).getDoubleValue();
                double mean = ((ScalarObject)meanFfr[0].get().getData()[0]).getDoubleValue();
                long size = map.getFederatedRanges()[0].getSize();
                for (int i = 0; i < ffr.length - 1; ++i) {
                    long l = size + map.getFederatedRanges()[i + 1].getSize();
                    double k = ((double)size * var + (double)map.getFederatedRanges()[i + 1].getSize() * ((ScalarObject)ffr[i + 1].get().getData()[0]).getDoubleValue()) / (double)l;
                    var = k + (double)(size * map.getFederatedRanges()[i + 1].getSize()) * Math.pow((mean - ((ScalarObject)meanFfr[i + 1].get().getData()[0]).getDoubleValue()) / (double)l, 2.0);
                    mean = (mean * (double)size + ((ScalarObject)meanFfr[i + 1].get().getData()[0]).getDoubleValue() * (double)map.getFederatedRanges()[i + 1].getSize()) / (double)l;
                    size = l;
                }
                return new DoubleObject(var);
            }
            double sum = 0.0;
            for (Future<FederatedResponse> fr : ffr) {
                sum += ((ScalarObject)fr.get().getData()[0]).getDoubleValue();
            }
            return new DoubleObject(sum);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock aggMatrix(AggregateUnaryOperator aop, Future<FederatedResponse>[] ffr, Future<FederatedResponse>[] meanFfr, FederationMap map) {
        if (aop.isRowAggregate() && map.getType() == FederationMap.FType.ROW) {
            return FederationUtils.bind(ffr, false);
        }
        if (aop.isColAggregate() && map.getType() == FederationMap.FType.COL) {
            return FederationUtils.bind(ffr, true);
        }
        if (aop.aggOp.increOp.fn instanceof KahanFunction) {
            return FederationUtils.aggAdd(ffr);
        }
        if (aop.aggOp.increOp.fn instanceof Mean) {
            return FederationUtils.aggMean(ffr, map);
        }
        if (aop.aggOp.increOp.fn instanceof Builtin && (((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN || ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX)) {
            boolean isMin = ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN;
            return FederationUtils.aggMinMax(ffr, isMin, false, Optional.of(map.getType()));
        }
        if (aop.aggOp.increOp.fn instanceof CM) {
            return FederationUtils.aggVar(ffr, meanFfr, map, aop.isRowAggregate(), !aop.isColAggregate() && !aop.isRowAggregate());
        }
        throw new DMLRuntimeException("Unsupported aggregation operator: " + aop.aggOp.increOp.fn.getClass().getSimpleName());
    }

    public static void waitFor(List<Future<FederatedResponse>> responses) {
        try {
            for (Future<FederatedResponse> fr : responses) {
                fr.get();
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static ScalarObject aggScalar(AggregateUnaryOperator aop, Future<FederatedResponse>[] ffr) {
        return FederationUtils.aggScalar(aop, ffr, null);
    }

    public static ScalarObject aggScalar(AggregateUnaryOperator aop, Future<FederatedResponse>[] ffr, FederationMap map) {
        if (!(aop.aggOp.increOp.fn instanceof KahanFunction || aop.aggOp.increOp.fn instanceof Builtin && (((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN || ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX) || aop.aggOp.increOp.fn instanceof Mean || aop.aggOp.increOp.fn instanceof Multiply)) {
            throw new DMLRuntimeException("Unsupported aggregation operator: " + aop.aggOp.increOp.getClass().getSimpleName());
        }
        try {
            if (aop.aggOp.increOp.fn instanceof Multiply) {
                MatrixBlock ret = new MatrixBlock(ffr.length, 1, false);
                MatrixBlock res = new MatrixBlock(0.0);
                for (int i = 0; i < ffr.length; ++i) {
                    ret.setValue(i, 0, ((ScalarObject)ffr[i].get().getData()[0]).getDoubleValue());
                }
                LibMatrixAgg.aggregateUnaryMatrix(ret, res, new AggregateUnaryOperator(new AggregateOperator(1.0, Multiply.getMultiplyFnObject()), ReduceAll.getReduceAllFnObject()));
                return new DoubleObject(res.quickGetValue(0, 0));
            }
            if (aop.aggOp.increOp.fn instanceof Builtin) {
                boolean isMin = ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN;
                return new DoubleObject(FederationUtils.aggMinMax(ffr, isMin, true, Optional.empty()).getValue(0, 0));
            }
            if (aop.aggOp.increOp.fn instanceof Mean) {
                return new DoubleObject(FederationUtils.aggMean(ffr, map).getValue(0, 0));
            }
            double sum = 0.0;
            for (Future<FederatedResponse> fr : ffr) {
                sum += ((ScalarObject)fr.get().getData()[0]).getDoubleValue();
            }
            return new DoubleObject(sum);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public static MatrixBlock aggMatrix(AggregateUnaryOperator aop, Future<FederatedResponse>[] ffr, FederationMap map) {
        if (aop.isRowAggregate() && map.getType() == FederationMap.FType.ROW) {
            return FederationUtils.bind(ffr, false);
        }
        if (aop.isColAggregate() && map.getType() == FederationMap.FType.COL) {
            return FederationUtils.bind(ffr, true);
        }
        if (aop.aggOp.increOp.fn instanceof KahanFunction) {
            return FederationUtils.aggAdd(ffr);
        }
        if (aop.aggOp.increOp.fn instanceof Mean) {
            return FederationUtils.aggMean(ffr, map);
        }
        if (aop.aggOp.increOp.fn instanceof Multiply) {
            return FederationUtils.aggProd(ffr, map, aop);
        }
        if (aop.aggOp.increOp.fn instanceof Builtin) {
            if (((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN || ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX) {
                boolean isMin = ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN;
                return FederationUtils.aggMinMax(ffr, isMin, false, Optional.of(map.getType()));
            }
            if (((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MININDEX || ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAXINDEX) {
                boolean isMin = ((Builtin)aop.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MININDEX;
                return FederationUtils.aggMinMaxIndex(ffr, isMin, map);
            }
            throw new DMLRuntimeException("Unsupported aggregation operator: " + aop.aggOp.increOp.fn.getClass().getSimpleName());
        }
        throw new DMLRuntimeException("Unsupported aggregation operator: " + aop.aggOp.increOp.fn.getClass().getSimpleName());
    }

    public static FederationMap federateLocalData(CacheableData<?> data) {
        long id = FederationUtils.getNextFedDataID();
        FederatedLocalData federatedLocalData = new FederatedLocalData(id, data);
        ArrayList<Pair<FederatedRange, FederatedData>> fedMap = new ArrayList<Pair<FederatedRange, FederatedData>>();
        fedMap.add(Pair.of((Object)new FederatedRange(new long[2], new long[]{data.getNumRows(), data.getNumColumns()}), (Object)federatedLocalData));
        return new FederationMap(id, fedMap);
    }

    public static MatrixBlock bindResponses(List<Pair<FederatedRange, Future<FederatedResponse>>> readResponses, long[] dims) throws Exception {
        MatrixBlock ret = new MatrixBlock((int)dims[0], (int)dims[1], false);
        for (Pair<FederatedRange, Future<FederatedResponse>> readResponse : readResponses) {
            FederatedRange range = (FederatedRange)readResponse.getLeft();
            FederatedResponse response = (FederatedResponse)((Future)readResponse.getRight()).get();
            int[] beginDimsInt = range.getBeginDimsInt();
            int[] endDimsInt = range.getEndDimsInt();
            MatrixBlock multRes = (MatrixBlock)response.getData()[0];
            ret.copy(beginDimsInt[0], endDimsInt[0] - 1, beginDimsInt[1], endDimsInt[1] - 1, multRes, false);
            ret.setNonZeros(ret.getNonZeros() + multRes.getNonZeros());
        }
        return ret;
    }

    public static MatrixBlock aggregateResponses(List<Pair<FederatedRange, Future<FederatedResponse>>> readResponses) {
        ArrayList<Object> dataParts = new ArrayList<Object>();
        for (Pair<FederatedRange, Future<FederatedResponse>> readResponse : readResponses) {
            dataParts.add(readResponse.getValue());
        }
        return FederationUtils.aggAdd(dataParts.toArray(new Future[0]));
    }
}

