/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.data.IndexedTensorBlock;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.data.TensorIndexes;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.instructions.spark.functions.FilterNonEmptyBlocksFunction;
import org.apache.sysds.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import scala.Tuple2;

public class MatrixReshapeSPInstruction
extends UnarySPInstruction {
    private final CPOperand _opRows;
    private final CPOperand _opCols;
    private final CPOperand _opByRow;
    private final boolean _outputEmptyBlocks;

    private MatrixReshapeSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, boolean outputEmptyBlocks, String opcode, String istr) {
        super(SPInstruction.SPType.MatrixReshape, op, in1, out, opcode, istr);
        this._opRows = in2;
        this._opCols = in3;
        this._opByRow = in4;
        this._outputEmptyBlocks = outputEmptyBlocks;
    }

    public static MatrixReshapeSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 7);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand rows = new CPOperand(parts[2]);
        CPOperand cols = new CPOperand(parts[3]);
        CPOperand byRow = new CPOperand(parts[5]);
        CPOperand out = new CPOperand(parts[6]);
        boolean outputEmptyBlocks = Boolean.parseBoolean(parts[7]);
        if (!opcode.equalsIgnoreCase("rshape")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MatrixReshapeInstruction: " + str);
        }
        return new MatrixReshapeSPInstruction(new Operator(true), in1, rows, cols, byRow, out, outputEmptyBlocks, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        long rows = ec.getScalarInput(this._opRows).getLongValue();
        long cols = ec.getScalarInput(this._opCols).getLongValue();
        boolean byRow = ec.getScalarInput(this._opByRow.getName(), Types.ValueType.BOOLEAN, this._opByRow.isLiteral()).getBooleanValue();
        DataCharacteristics mcIn = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (this.input1.getDataType() == Types.DataType.MATRIX) {
            JavaPairRDD in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName(), -1, this._outputEmptyBlocks);
            mcOut.set(rows, cols, mcIn.getBlocksize(), mcIn.getNonZeros());
            if (!mcIn.nnzKnown()) {
                mcOut.setNonZerosBound(mcIn.getNonZerosBound());
            }
            if (mcIn.getRows() * mcIn.getCols() != mcOut.getRows() * mcOut.getCols()) {
                throw new DMLRuntimeException("Incompatible matrix characteristics for reshape: " + mcIn.getRows() + "x" + mcIn.getCols() + " vs " + mcOut.getRows() + "x" + mcOut.getCols());
            }
            if (!this._outputEmptyBlocks) {
                in1 = in1.filter((Function)new FilterNonEmptyBlocksFunction());
            }
            JavaPairRDD<MatrixIndexes, MatrixBlock> out = in1.flatMapToPair((PairFlatMapFunction)new RDDReshapeFunction(mcIn, mcOut, byRow, this._outputEmptyBlocks));
            out = RDDAggregateUtils.mergeByKey(out);
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        } else {
            JavaPairRDD<TensorIndexes, TensorBlock> in1 = sec.getBinaryTensorBlockRDDHandleForVariable(this.input1.getName(), -1, this._outputEmptyBlocks);
            JavaPairRDD out = in1.flatMapToPair((PairFlatMapFunction)new RDDTensorReshapeFunction(mcIn, mcOut, byRow, this._outputEmptyBlocks));
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        }
    }

    private static class RDDTensorReshapeFunction
    implements PairFlatMapFunction<Tuple2<TensorIndexes, TensorBlock>, TensorIndexes, TensorBlock> {
        private static final long serialVersionUID = 8030648988828223639L;
        private final DataCharacteristics _mcIn;
        private final DataCharacteristics _mcOut;
        private final boolean _byrow;
        private final boolean _outputEmptyBlocks;

        public RDDTensorReshapeFunction(DataCharacteristics mcIn, DataCharacteristics mcOut, boolean byrow, boolean outputEmptyBlocks) {
            this._mcIn = mcIn;
            this._mcOut = mcOut;
            this._byrow = byrow;
            this._outputEmptyBlocks = outputEmptyBlocks;
        }

        public Iterator<Tuple2<TensorIndexes, TensorBlock>> call(Tuple2<TensorIndexes, TensorBlock> arg0) throws Exception {
            IndexedTensorBlock in = SparkUtils.toIndexedTensorBlock(arg0);
            return null;
        }
    }

    private static class RDDReshapeFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 2819309412002224478L;
        private final DataCharacteristics _mcIn;
        private final DataCharacteristics _mcOut;
        private final boolean _byrow;
        private final boolean _outputEmptyBlocks;

        public RDDReshapeFunction(DataCharacteristics mcIn, DataCharacteristics mcOut, boolean byrow, boolean outputEmptyBlocks) {
            this._mcIn = mcIn;
            this._mcOut = mcOut;
            this._byrow = byrow;
            this._outputEmptyBlocks = outputEmptyBlocks;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            IndexedMatrixValue in = SparkUtils.toIndexedMatrixBlock(arg0);
            List<IndexedMatrixValue> out = LibMatrixReorg.reshape(in, this._mcIn, this._mcOut, this._byrow, this._outputEmptyBlocks);
            return SparkUtils.fromIndexedMatrixBlock(out).iterator();
        }
    }
}

