/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.dp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.paramserv.ParamservUtils;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.DataPartitionLocalScheme;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CollectionUtils;

public class DCLocalScheme
extends DataPartitionLocalScheme {
    public static List<MatrixBlock> partition(int k, MatrixBlock mb) {
        if (k == 1) {
            return CollectionUtils.asArrayList(mb);
        }
        ArrayList<MatrixBlock> list = new ArrayList<MatrixBlock>();
        long stepSize = (long)Math.ceil((double)mb.getNumRows() / (double)k);
        long begin = 1L;
        while (begin < (long)mb.getNumRows()) {
            long end = Math.min(begin - 1L + stepSize, (long)mb.getNumRows());
            MatrixBlock pmo = ParamservUtils.sliceMatrixBlock(mb, begin, end);
            list.add(pmo);
            begin = end + 1L;
        }
        return list;
    }

    private static List<MatrixObject> doPartitioning(int k, MatrixBlock mb) {
        return DCLocalScheme.partition(k, mb).stream().map(ParamservUtils::newMatrixObject).collect(Collectors.toList());
    }

    @Override
    public DataPartitionLocalScheme.Result doPartitioning(int workersNum, MatrixBlock features, MatrixBlock labels) {
        List<MatrixObject> pfs = DCLocalScheme.doPartitioning(workersNum, features);
        List<MatrixObject> pls = DCLocalScheme.doPartitioning(workersNum, labels);
        return new DataPartitionLocalScheme.Result(pfs, pls);
    }
}

