/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.propagation;

import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.finegrained.FineGrainedPrivacy;
import org.apache.sysds.runtime.privacy.propagation.MatrixMultiplicationPropagator;
import org.apache.sysds.runtime.privacy.propagation.OperatorType;

public class MatrixMultiplicationPropagatorPrivateFirst
extends MatrixMultiplicationPropagator {
    public MatrixMultiplicationPropagatorPrivateFirst() {
    }

    public MatrixMultiplicationPropagatorPrivateFirst(MatrixBlock input1, PrivacyConstraint privacyConstraint1, MatrixBlock input2, PrivacyConstraint privacyConstraint2) {
        super(input1, privacyConstraint1, input2, privacyConstraint2);
    }

    @Override
    protected void generateFineGrainedConstraints(FineGrainedPrivacy mergedFineGrainedConstraints, PrivacyConstraint.PrivacyLevel[] rowPrivacy, PrivacyConstraint.PrivacyLevel[] colPrivacy, OperatorType[] operatorTypes1, OperatorType[] operatorTypes2) {
        int l;
        int k;
        int r1 = rowPrivacy.length;
        int c2 = colPrivacy.length;
        for (int i = 0; i < rowPrivacy.length; ++i) {
            if (rowPrivacy[i] != PrivacyConstraint.PrivacyLevel.Private) continue;
            mergedFineGrainedConstraints.putRow(i, c2, PrivacyConstraint.PrivacyLevel.Private);
        }
        for (int j = 0; j < colPrivacy.length; ++j) {
            if (colPrivacy[j] != PrivacyConstraint.PrivacyLevel.Private) continue;
            mergedFineGrainedConstraints.putCol(j, r1, PrivacyConstraint.PrivacyLevel.Private);
        }
        for (k = 0; k < operatorTypes1.length; ++k) {
            if (operatorTypes1[k] != OperatorType.NonAggregate) continue;
            if (rowPrivacy[k] == PrivacyConstraint.PrivacyLevel.PrivateAggregation) {
                mergedFineGrainedConstraints.putRow(k, c2, PrivacyConstraint.PrivacyLevel.PrivateAggregation);
                continue;
            }
            if (rowPrivacy[k] == PrivacyConstraint.PrivacyLevel.Private) continue;
            for (l = 0; l < colPrivacy.length; ++l) {
                if (colPrivacy[l] != PrivacyConstraint.PrivacyLevel.PrivateAggregation) continue;
                mergedFineGrainedConstraints.putElement(k, l, PrivacyConstraint.PrivacyLevel.PrivateAggregation);
            }
        }
        for (k = 0; k < operatorTypes2.length; ++k) {
            if (operatorTypes2[k] != OperatorType.NonAggregate) continue;
            if (colPrivacy[k] == PrivacyConstraint.PrivacyLevel.PrivateAggregation) {
                mergedFineGrainedConstraints.putCol(k, r1, PrivacyConstraint.PrivacyLevel.PrivateAggregation);
                continue;
            }
            if (colPrivacy[k] == PrivacyConstraint.PrivacyLevel.Private) continue;
            for (l = 0; l < rowPrivacy.length; ++l) {
                if (rowPrivacy[l] != PrivacyConstraint.PrivacyLevel.PrivateAggregation) continue;
                mergedFineGrainedConstraints.putElement(k, l, PrivacyConstraint.PrivacyLevel.PrivateAggregation);
            }
        }
    }
}

