/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class Py4jConverterUtils {
    public static MatrixBlock convertPy4JArrayToMB(byte[] data, int rlen, int clen) {
        return Py4jConverterUtils.convertPy4JArrayToMB(data, rlen, clen, false, Types.ValueType.FP64);
    }

    public static MatrixBlock convertPy4JArrayToMB(byte[] data, int rlen, int clen, Types.ValueType valueType) {
        return Py4jConverterUtils.convertPy4JArrayToMB(data, rlen, clen, false, valueType);
    }

    public static MatrixBlock convertSciPyCOOToMB(byte[] data, byte[] row, byte[] col, int rlen, int clen, int nnz) {
        MatrixBlock mb = new MatrixBlock(rlen, clen, true);
        mb.allocateSparseRowsBlock(false);
        ByteBuffer buf1 = ByteBuffer.wrap(data);
        buf1.order(ByteOrder.nativeOrder());
        ByteBuffer buf2 = ByteBuffer.wrap(row);
        buf2.order(ByteOrder.nativeOrder());
        ByteBuffer buf3 = ByteBuffer.wrap(col);
        buf3.order(ByteOrder.nativeOrder());
        for (int i = 0; i < nnz; ++i) {
            double val = buf1.getDouble();
            int rowIndex = buf2.getInt();
            int colIndex = buf3.getInt();
            mb.setValue(rowIndex, colIndex, val);
        }
        mb.recomputeNonZeros();
        mb.examSparsity();
        return mb;
    }

    public static MatrixBlock allocateDenseOrSparse(int rlen, int clen, boolean isSparse) {
        MatrixBlock ret = new MatrixBlock(rlen, clen, isSparse);
        ret.allocateBlock();
        return ret;
    }

    public static MatrixBlock allocateDenseOrSparse(long rlen, long clen, boolean isSparse) {
        if (rlen > Integer.MAX_VALUE || clen > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("Dimensions of matrix are too large to be passed via NumPy/SciPy:" + rlen + " X " + clen);
        }
        return Py4jConverterUtils.allocateDenseOrSparse((int)rlen, (int)clen, isSparse);
    }

    public static MatrixBlock convertPy4JArrayToMB(byte[] data, int rlen, int clen, boolean isSparse, Types.ValueType valueType) {
        MatrixBlock mb = new MatrixBlock(rlen, clen, isSparse, -1L);
        if (isSparse) {
            throw new DMLRuntimeException("Convertion to sparse format not supported");
        }
        long limit = (long)rlen * (long)clen;
        if (limit > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("Dense NumPy array of size " + limit + " cannot be converted to MatrixBlock");
        }
        double[] denseBlock = new double[(int)limit];
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.nativeOrder());
        switch (valueType) {
            case UINT8: {
                int i = 0;
                while ((long)i < limit) {
                    denseBlock[i] = buf.get() & 0xFF;
                    ++i;
                }
                break;
            }
            case INT32: {
                int i = 0;
                while ((long)i < limit) {
                    denseBlock[i] = buf.getInt();
                    ++i;
                }
                break;
            }
            case FP32: {
                int i = 0;
                while ((long)i < limit) {
                    denseBlock[i] = buf.getFloat();
                    ++i;
                }
                break;
            }
            case FP64: {
                int i = 0;
                while ((long)i < limit) {
                    denseBlock[i] = buf.getDouble();
                    ++i;
                }
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported value type: " + valueType.name());
            }
        }
        mb.init(denseBlock, rlen, clen);
        mb.recomputeNonZeros();
        mb.examSparsity();
        return mb;
    }

    public static byte[] convertMBtoPy4JDenseArr(MatrixBlock mb) {
        int times;
        long limit;
        byte[] ret = null;
        if (mb.isInSparseFormat()) {
            mb.sparseToDense();
        }
        if ((limit = (long)(mb.getNumRows() * mb.getNumColumns())) > (long)(Integer.MAX_VALUE / (times = 8))) {
            throw new DMLRuntimeException("MatrixBlock of size " + limit + " cannot be converted to dense numpy array");
        }
        ret = new byte[(int)(limit * (long)times)];
        double[] denseBlock = mb.getDenseBlockValues();
        if (mb.isEmptyBlock()) {
            int i = 0;
            while ((long)i < limit) {
                ByteBuffer.wrap(ret, i * times, times).order(ByteOrder.nativeOrder()).putDouble(0.0);
                ++i;
            }
        } else {
            if (denseBlock == null) {
                throw new DMLRuntimeException("Error while dealing with empty blocks.");
            }
            for (int i = 0; i < denseBlock.length; ++i) {
                ByteBuffer.wrap(ret, i * times, times).order(ByteOrder.nativeOrder()).putDouble(denseBlock[i]);
            }
        }
        return ret;
    }
}

