/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.cost.InstructionTypeCounter;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class ComputationCostEstimator
implements ICostEstimate {
    private static final long serialVersionUID = -1205636215389161815L;
    private static final double commonValueImpact = 0.75;
    private static final double cvThreshold = 0.2;
    private static final int scalingStart = 1000;
    private final int _nRows;
    private final int _nCols;
    private final int _scans;
    private final int _decompressions;
    private final int _overlappingDecompressions;
    private final int _leftMultiplications;
    private final int _rightMultiplications;
    private final int _compressedMultiplication;
    private final int _dictionaryOps;
    private final boolean _isDensifying;

    protected ComputationCostEstimator(int nRows, int nCols, double sparsity, InstructionTypeCounter counts) {
        this._nRows = nRows;
        this._nCols = nCols;
        this._scans = counts.scans;
        this._decompressions = counts.decompressions;
        this._overlappingDecompressions = counts.overlappingDecompressions;
        this._leftMultiplications = counts.leftMultiplications;
        this._compressedMultiplication = counts.compressedMultiplications;
        this._rightMultiplications = counts.rightMultiplications;
        this._dictionaryOps = counts.dictionaryOps;
        this._isDensifying = counts.isDensifying;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this);
        }
    }

    public ComputationCostEstimator(int nRows, int nCols, double sparsity, int scans, int decompressions, int overlappingDecompressions, int leftMultiplictions, int compressedMultiplication, int rightMultiplications, int dictioanaryOps, boolean isDensifying) {
        this._nRows = nRows;
        this._nCols = nCols;
        this._scans = scans;
        this._decompressions = decompressions;
        this._overlappingDecompressions = overlappingDecompressions;
        this._leftMultiplications = leftMultiplictions;
        this._compressedMultiplication = compressedMultiplication;
        this._rightMultiplications = rightMultiplications;
        this._dictionaryOps = dictioanaryOps;
        this._isDensifying = isDensifying;
    }

    @Override
    public double getUncompressedCost(CompressedSizeInfoColGroup g) {
        throw new NotImplementedException();
    }

    @Override
    public double getCostOfColumnGroup(CompressedSizeInfoColGroup g) {
        if (g == null) {
            return Double.POSITIVE_INFINITY;
        }
        double cost = 0.0;
        cost += (double)this._scans * this.scanCost(g);
        cost += (double)this._decompressions * this.decompressionCost(g);
        cost += (double)this._overlappingDecompressions * this.overlappingDecompressionCost(g);
        int rowsCols = 16;
        double scalingFactor = this.getScalingFactor(g.getNumVals());
        cost += (double)this._leftMultiplications * this.leftMultCost(g) * 16.0;
        cost += (double)this._rightMultiplications * this.rightMultCost(g) * 16.0;
        cost += (double)this._dictionaryOps * ComputationCostEstimator.dictionaryOpsCost(g);
        return (cost += (double)this._compressedMultiplication * this._compressedMultCost(g) * 16.0) * scalingFactor;
    }

    private double getScalingFactor(double nrValues) {
        double scalingFactor = 1.0;
        if (nrValues > 1000.0) {
            scalingFactor += (nrValues - 1000.0) / 1000.0 * 0.01;
        }
        if (nrValues > 65535.0) {
            scalingFactor += 0.5;
        }
        return scalingFactor;
    }

    private double scanCost(CompressedSizeInfoColGroup g) {
        return this._nRows;
    }

    private double leftMultCost(CompressedSizeInfoColGroup g) {
        int nColsInGroup = g.getColumns().length;
        double mcf = g.getMostCommonFraction();
        double preAggregateCost = (mcf > 0.2 ? (double)this._nRows * (1.0 - 0.75 * mcf) : (double)this._nRows) * 0.6;
        double numberTuples = g.getNumVals();
        double tupleSparsity = g.getTupleSparsity();
        double postScalingCost = nColsInGroup > 1 && tupleSparsity > 0.4 ? numberTuples * (double)nColsInGroup * tupleSparsity * 1.4 : numberTuples * (double)nColsInGroup;
        return preAggregateCost + postScalingCost;
    }

    private double _compressedMultCost(CompressedSizeInfoColGroup g) {
        int nColsInGroup = g.getColumns().length;
        double mcf = g.getMostCommonFraction();
        double preAggregateCost = (mcf > 0.2 ? (double)this._nRows * (1.0 - 0.75 * mcf) : (double)this._nRows) * 0.6;
        double numberTuples = g.getNumVals();
        double tupleSparsity = g.getTupleSparsity();
        double postScalingCost = nColsInGroup > 1 && tupleSparsity > 0.4 ? numberTuples * (double)nColsInGroup * tupleSparsity * 1.4 : numberTuples * (double)nColsInGroup;
        return preAggregateCost + postScalingCost;
    }

    private double rightMultCost(CompressedSizeInfoColGroup g) {
        int nColsInGroup = g.getColumns().length;
        int numberTuples = g.getNumVals();
        double tupleSparsity = g.getTupleSparsity();
        double postScalingCost = nColsInGroup > 1 && tupleSparsity > 0.4 ? (double)(numberTuples * nColsInGroup) * tupleSparsity * 1.4 : (double)(numberTuples * nColsInGroup);
        double postAllocationCost = 16 * numberTuples;
        return postScalingCost + postAllocationCost;
    }

    private double decompressionCost(CompressedSizeInfoColGroup g) {
        return this._nRows * g.getColumns().length * (g.getNumVals() / 64000 + 1);
    }

    private double overlappingDecompressionCost(CompressedSizeInfoColGroup g) {
        double mcf = g.getMostCommonFraction();
        double rowsCost = mcf > 0.2 ? (double)this._nRows * (1.0 - 0.75 * mcf) : (double)this._nRows;
        return rowsCost * 64.0;
    }

    private static double dictionaryOpsCost(CompressedSizeInfoColGroup g) {
        return g.getColumns().length * g.getNumVals();
    }

    @Override
    public boolean shouldAnalyze(CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        return true;
    }

    public boolean isDense() {
        return this._isDensifying;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("dims(");
        sb.append(this._nRows + ",");
        sb.append(this._nCols + ") ");
        sb.append("CostVector:[");
        sb.append(this._scans + ",");
        sb.append(this._decompressions + ",");
        sb.append(this._overlappingDecompressions + ",");
        sb.append(this._leftMultiplications + ",");
        sb.append(this._rightMultiplications + ",");
        sb.append(this._compressedMultiplication + ",");
        sb.append(this._dictionaryOps + "]");
        sb.append(" Densifying:");
        sb.append(this._isDensifying);
        return sb.toString();
    }
}

