/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class ContainerBlock
extends HtmlBlock {
    private static final Log LOG = LogFactory.getLog(ContainerBlock.class);
    private final ApplicationContext appContext;

    @Inject
    public ContainerBlock(ApplicationContext appContext, View.ViewContext ctx) {
        super(ctx);
        this.appContext = appContext;
    }

    protected void render(HtmlBlock.Block html) {
        ContainerReport containerReport;
        String containerid = this.$("container.id");
        if (containerid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires container ID"});
            return;
        }
        ContainerId containerId = null;
        try {
            containerId = ConverterUtils.toContainerId((String)containerid);
        }
        catch (IllegalArgumentException e) {
            this.puts(new Object[]{"Invalid container ID: " + containerid});
            return;
        }
        final ContainerId containerIdFinal = containerId;
        UserGroupInformation callerUGI = this.getCallerUGI();
        try {
            containerReport = callerUGI == null ? this.appContext.getContainer(containerId) : (ContainerReport)callerUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ContainerReport>(){

                @Override
                public ContainerReport run() throws Exception {
                    return ContainerBlock.this.appContext.getContainer(containerIdFinal);
                }
            });
        }
        catch (Exception e) {
            String message = "Failed to read the container " + containerid + ".";
            LOG.error((Object)message, (Throwable)e);
            html.p()._(new Object[]{message})._();
            return;
        }
        if (containerReport == null) {
            this.puts(new Object[]{"Container not found: " + containerid});
            return;
        }
        ContainerInfo container = new ContainerInfo(containerReport);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Container ", containerid}));
        this.info("Container Overview")._("State:", (Object)container.getContainerState())._("Exit Status:", (Object)container.getContainerExitStatus())._("Node:", (Object)container.getAssignedNodeId())._("Priority:", (Object)container.getPriority())._("Started:", (Object)Times.format((long)container.getStartedTime()))._("Elapsed:", (Object)StringUtils.formatTime((long)Times.elapsed((long)container.getStartedTime(), (long)container.getFinishedTime())))._("Resource:", (Object)(container.getAllocatedMB() + " Memory, " + container.getAllocatedVCores() + " VCores"))._("Logs:", container.getLogUrl() == null ? "#" : container.getLogUrl(), (Object)(container.getLogUrl() == null ? "N/A" : "Logs"))._("Diagnostics:", (Object)container.getDiagnosticsInfo());
        html._(InfoBlock.class);
    }
}

