/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.cost.ICostEstimate;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.utils.Util;

public class CoCodeGreedy
extends AColumnCoCoder {
    protected CoCodeGreedy(CompressedSizeEstimator sizeEstimator, ICostEstimate costEstimator, CompressionSettings cs) {
        super(sizeEstimator, costEstimator, cs);
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        colInfos.setInfo(CoCodeGreedy.join(colInfos.compressionInfo, this._sest, this._cest, this._cs, k));
        return colInfos;
    }

    protected static List<CompressedSizeInfoColGroup> join(List<CompressedSizeInfoColGroup> inputColumns, CompressedSizeEstimator sEst, ICostEstimate cEst, CompressionSettings cs, int k) {
        Memorizer mem = new Memorizer(cs, sEst);
        for (CompressedSizeInfoColGroup g : inputColumns) {
            mem.put(g);
        }
        return CoCodeGreedy.coCodeBruteForce(inputColumns, cEst, mem);
    }

    private static List<CompressedSizeInfoColGroup> coCodeBruteForce(List<CompressedSizeInfoColGroup> inputColumns, ICostEstimate cEst, Memorizer mem) {
        ArrayList<ColIndexes> workset = new ArrayList<ColIndexes>(inputColumns.size());
        boolean workloadCost = cEst instanceof ComputationCostEstimator;
        for (int i = 0; i < inputColumns.size(); ++i) {
            workset.add(new ColIndexes(inputColumns.get(i).getColumns()));
        }
        while (workset.size() > 1) {
            double changeInCost = 0.0;
            CompressedSizeInfoColGroup tmp = null;
            ColIndexes selected1 = null;
            ColIndexes selected2 = null;
            for (int i = 0; i < workset.size(); ++i) {
                for (int j = i + 1; j < workset.size(); ++j) {
                    ColIndexes c1 = (ColIndexes)workset.get(i);
                    ColIndexes c2 = (ColIndexes)workset.get(j);
                    double costC1 = cEst.getCostOfColumnGroup(mem.get(c1));
                    double costC2 = cEst.getCostOfColumnGroup(mem.get(c2));
                    mem.incst1();
                    if (-Math.min(costC1, costC2) * (workloadCost ? 0.7 : 1.0) > changeInCost) continue;
                    CompressedSizeInfoColGroup c1c2Inf = mem.getOrCreate(c1, c2);
                    double costC1C2 = cEst.getCostOfColumnGroup(c1c2Inf);
                    double newSizeChangeIfSelected = costC1C2 - costC1 - costC2;
                    if (!(tmp == null && newSizeChangeIfSelected < changeInCost) && (tmp == null || !(newSizeChangeIfSelected < changeInCost) && (newSizeChangeIfSelected != changeInCost || c1c2Inf.getColumns().length >= tmp.getColumns().length))) continue;
                    changeInCost = newSizeChangeIfSelected;
                    tmp = c1c2Inf;
                    selected1 = c1;
                    selected2 = c2;
                }
            }
            if (tmp == null) break;
            workset.remove(selected1);
            workset.remove(selected2);
            mem.remove(selected1, selected2);
            workset.add(new ColIndexes(tmp.getColumns()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Memorizer stats:" + mem.stats()));
        }
        mem.resetStats();
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>(workset.size());
        for (ColIndexes w : workset) {
            ret.add(mem.get(w));
        }
        return ret;
    }

    private static class ColIndexes {
        final int[] _indexes;
        final int _hash;

        public ColIndexes(int[] indexes) {
            this._indexes = indexes;
            this._hash = Arrays.hashCode(this._indexes);
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object that) {
            ColIndexes thatGrp = (ColIndexes)that;
            return Arrays.equals(this._indexes, thatGrp._indexes);
        }
    }

    protected static class Memorizer {
        private final CompressionSettings _cs;
        private final CompressedSizeEstimator _sEst;
        private final Map<ColIndexes, CompressedSizeInfoColGroup> mem;
        private int st1 = 0;
        private int st2 = 0;
        private int st3 = 0;
        private int st4 = 0;

        public Memorizer(CompressionSettings cs, CompressedSizeEstimator sEst) {
            this._cs = cs;
            this._sEst = sEst;
            this.mem = new HashMap<ColIndexes, CompressedSizeInfoColGroup>();
        }

        public void put(CompressedSizeInfoColGroup g) {
            this.mem.put(new ColIndexes(g.getColumns()), g);
        }

        public CompressedSizeInfoColGroup get(ColIndexes c) {
            return this.mem.get(c);
        }

        public void remove(ColIndexes c1, ColIndexes c2) {
            this.mem.remove(c1);
            this.mem.remove(c2);
        }

        public CompressedSizeInfoColGroup getOrCreate(ColIndexes c1, ColIndexes c2) {
            int[] c = Util.join(c1._indexes, c2._indexes);
            ColIndexes cI = new ColIndexes(c);
            CompressedSizeInfoColGroup g = this.mem.get(cI);
            ++this.st2;
            if (g == null) {
                boolean rightConst;
                CompressedSizeInfoColGroup left = this.mem.get(c1);
                CompressedSizeInfoColGroup right = this.mem.get(c2);
                boolean leftConst = left.getBestCompressionType(this._cs) == AColGroup.CompressionType.CONST && left.getNumOffs() == 0;
                boolean bl = rightConst = right.getBestCompressionType(this._cs) == AColGroup.CompressionType.CONST && right.getNumOffs() == 0;
                if (leftConst) {
                    g = CompressedSizeInfoColGroup.addConstGroup(c, right, this._cs.validCompressions);
                } else if (rightConst) {
                    g = CompressedSizeInfoColGroup.addConstGroup(c, left, this._cs.validCompressions);
                } else {
                    ++this.st3;
                    g = this._sEst.estimateJoinCompressedSize(c, left, right);
                }
                if (leftConst || rightConst) {
                    ++this.st4;
                }
                this.mem.put(cI, g);
            }
            return g;
        }

        public void incst1() {
            ++this.st1;
        }

        public String stats() {
            return this.st1 + " " + this.st2 + " " + this.st3 + " " + this.st4;
        }

        public void resetStats() {
            this.st1 = 0;
            this.st2 = 0;
            this.st3 = 0;
            this.st4 = 0;
        }

        public String toString() {
            return this.mem.toString();
        }
    }
}

