/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.FastStringTokenizer;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class MatrixGenerateReader
extends MatrixReader {
    protected static CustomProperties _props;
    protected final FastStringTokenizer fastStringTokenizerDelim;

    public MatrixGenerateReader(CustomProperties _props) {
        MatrixGenerateReader._props = _props;
        this.fastStringTokenizerDelim = new FastStringTokenizer(_props.getDelim());
    }

    protected MatrixBlock computeSize(List<Path> files, FileSystem fs, long rlen, long clen) throws IOException, DMLRuntimeException {
        return new MatrixBlock(MatrixGenerateReader.getNumRows(files, fs), (int)clen, rlen * clen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNumRows(List<Path> files, FileSystem fs) throws IOException, DMLRuntimeException {
        int rows = 0;
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(files.get(fileNo))));
            try {
                String value;
                if (_props.getRowPattern().equals((Object)CustomProperties.GRPattern.Regular)) {
                    while (br.readLine() != null) {
                        ++rows;
                    }
                    continue;
                }
                FastStringTokenizer st = new FastStringTokenizer(_props.getDelim());
                while ((value = br.readLine()) != null) {
                    st.reset(value);
                    int row = st.nextInt();
                    rows = Math.max(rows, row);
                }
                ++rows;
                continue;
            }
            finally {
                IOUtilFunctions.closeSilently(br);
            }
        }
        return rows;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = null;
        if (rlen >= 0L && clen >= 0L) {
            ret = MatrixGenerateReader.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false);
        }
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ret = this.readMatrixFromHDFS(path, job, fs, ret, rlen, clen, blen);
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = null;
        if (rlen >= 0L && clen >= 0L) {
            ret = MatrixGenerateReader.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false);
        }
        return ret;
    }

    private MatrixBlock readMatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int blen) throws IOException, DMLRuntimeException {
        ArrayList<Path> files = new ArrayList<Path>();
        if (fs.isDirectory(path)) {
            for (FileStatus stat : fs.listStatus(path, IOUtilFunctions.hiddenFileFilter)) {
                files.add(stat.getPath());
            }
            Collections.sort(files);
        } else {
            files.add(path);
        }
        if (dest == null) {
            dest = this.computeSize(files, fs, rlen, clen);
            rlen = dest.getNumRows();
        }
        long lnnz = 0L;
        MutableInt row = new MutableInt(0);
        for (int fileNo = 0; fileNo < files.size(); ++fileNo) {
            lnnz += this.readMatrixFromInputStream((InputStream)fs.open(files.get(fileNo)), path.toString(), dest, row, rlen, clen, blen);
        }
        dest.setNonZeros(lnnz);
        return dest;
    }

    protected abstract long readMatrixFromInputStream(InputStream var1, String var2, MatrixBlock var3, MutableInt var4, long var5, long var7, int var9) throws IOException;

    public static class MatrixReaderRowIrregular
    extends MatrixGenerateReader {
        public MatrixReaderRowIrregular(CustomProperties _props) {
            super(_props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long readMatrixFromInputStream(InputStream is, String srcInfo, MatrixBlock dest, MutableInt rowPos, long rlen, long clen, int blen) throws IOException {
            String value = null;
            int row = rowPos.intValue();
            double cellValue = 0.0;
            int col = 0;
            long lnnz = 0L;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                while ((value = br.readLine()) != null) {
                    this.fastStringTokenizerDelim.reset(value);
                    int ri = this.fastStringTokenizerDelim.nextInt();
                    col = this.fastStringTokenizerDelim.nextInt();
                    cellValue = this.fastStringTokenizerDelim.nextDouble();
                    if (cellValue != 0.0) {
                        dest.appendValue(ri - _props.getFirstColIndex(), col - _props.getFirstColIndex(), cellValue);
                        ++lnnz;
                    }
                    row = Math.max(row, ri);
                }
            }
            finally {
                IOUtilFunctions.closeSilently(br);
            }
            rowPos.setValue(row);
            return lnnz;
        }
    }

    public static class MatrixReaderRowRegularColIrregular
    extends MatrixGenerateReader {
        public MatrixReaderRowRegularColIrregular(CustomProperties _props) {
            super(_props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long readMatrixFromInputStream(InputStream is, String srcInfo, MatrixBlock dest, MutableInt rowPos, long rlen, long clen, int blen) throws IOException {
            String value = null;
            int row = rowPos.intValue();
            double cellValue = 0.0;
            int col = 0;
            long lnnz = 0L;
            FastStringTokenizer fastStringTokenizerIndexDelim = new FastStringTokenizer(_props.getIndexDelim());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                while ((value = br.readLine()) != null) {
                    this.fastStringTokenizerDelim.reset(value);
                    String cellValueString = this.fastStringTokenizerDelim.nextToken();
                    cellValue = UtilFunctions.parseToDouble(cellValueString, null);
                    dest.appendValue(row, (int)clen - _props.getFirstColIndex() - 1, cellValue);
                    while (col != -1) {
                        String nt = this.fastStringTokenizerDelim.nextToken();
                        if (this.fastStringTokenizerDelim.getIndex() == -1) break;
                        fastStringTokenizerIndexDelim.reset(nt);
                        col = fastStringTokenizerIndexDelim.nextInt();
                        cellValue = fastStringTokenizerIndexDelim.nextDouble();
                        if (cellValue == 0.0) continue;
                        dest.appendValue(row, col - _props.getFirstColIndex(), cellValue);
                        ++lnnz;
                    }
                    ++row;
                    col = 0;
                }
            }
            finally {
                IOUtilFunctions.closeSilently(br);
            }
            rowPos.setValue(row);
            return lnnz;
        }
    }

    public static class MatrixReaderRowRegularColRegular
    extends MatrixGenerateReader {
        public MatrixReaderRowRegularColRegular(CustomProperties _props) {
            super(_props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long readMatrixFromInputStream(InputStream is, String srcInfo, MatrixBlock dest, MutableInt rowPos, long rlen, long clen, int blen) throws IOException {
            String value = null;
            int row = rowPos.intValue();
            double cellValue = 0.0;
            int col = 0;
            long lnnz = 0L;
            this.fastStringTokenizerDelim.setNaStrings(_props.getNaStrings());
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                while ((value = br.readLine()) != null) {
                    this.fastStringTokenizerDelim.reset(value);
                    while (col != -1) {
                        cellValue = this.fastStringTokenizerDelim.nextDouble();
                        col = this.fastStringTokenizerDelim.getIndex();
                        if (cellValue == 0.0) continue;
                        dest.appendValue(row, col, cellValue);
                        ++lnnz;
                    }
                    ++row;
                    col = 0;
                }
            }
            finally {
                IOUtilFunctions.closeSilently(br);
            }
            rowPos.setValue(row);
            return lnnz;
        }
    }
}

