# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/ffTrain.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def ffTrain(X: Matrix,
            Y: Matrix,
            out_activation: str,
            loss_fcn: str,
            **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
    :param batch_size: Batch size
    :param epochs: Number of epochs
    :param learning_rate: Learning rate
    :param out_activation: User specified ouptut activation function. Possible values:
    :param loss_fcn: User specified loss function. Possible values:
    :param shuffle: Flag which indicates if dataset should be shuffled or not
    :param validation_split: Fraction of training set used as validation set
    :param seed: Seed for model initialization
    :param verbose: Flag which indicates if function should print to stdout
    :param Supported: by the model
    :param Supported: by the model
    :return: 'OperationNode' containing  
    """
    params_dict = {'X': X, 'Y': Y, 'out_activation': out_activation, 'loss_fcn': loss_fcn}
    params_dict.update(kwargs)
    return Matrix(X.sds_context,
        'ffTrain',
        named_input_nodes=params_dict)
