/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.compress.utils.Util;

public class DblArrayIntListHashMap {
    protected static final Log LOG = LogFactory.getLog((String)DblArrayIntListHashMap.class.getName());
    protected static final int INIT_CAPACITY = 8;
    protected static final int RESIZE_FACTOR = 2;
    protected static final float LOAD_FACTOR = 0.5f;
    public static int hashMissCount = 0;
    protected int _size = -1;
    protected DArrayIListEntry[] _data = null;

    public DblArrayIntListHashMap() {
        this._data = new DArrayIListEntry[8];
        this._size = 0;
    }

    public DblArrayIntListHashMap(int init_capacity) {
        this._data = new DArrayIListEntry[Util.getPow2(init_capacity)];
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public IntArrayList get(DblArray key) {
        if (this._size == 0) {
            return null;
        }
        int hash = key.hashCode();
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        while (this._data[ix] != null && !this._data[ix].keyEquals(key)) {
            hash = Integer.hashCode(hash + 1);
            ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
            ++hashMissCount;
        }
        DArrayIListEntry e = this._data[ix];
        if (e != null) {
            return e.value;
        }
        return null;
    }

    private void appendValue(DblArray key, IntArrayList value) {
        int hash = key.hashCode();
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        while (this._data[ix] != null && !this._data[ix].keyEquals(key)) {
            hash = Integer.hashCode(hash + 1);
            ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
            ++hashMissCount;
        }
        this._data[ix] = new DArrayIListEntry(key, value);
        ++this._size;
    }

    public void appendValue(DblArray key, int value) {
        int hash = key.hashCode();
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        while (this._data[ix] != null && !this._data[ix].keyEquals(key)) {
            hash = Integer.hashCode(hash + 1);
            ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
            ++hashMissCount;
        }
        DArrayIListEntry e = this._data[ix];
        if (e == null) {
            IntArrayList lstPtr = new IntArrayList();
            lstPtr.appendValue(value);
            this._data[ix] = new DArrayIListEntry(new DblArray(key), lstPtr);
            ++this._size;
        } else {
            IntArrayList lstPtr = e.value;
            lstPtr.appendValue(value);
        }
        if ((float)this._size >= 0.5f * (float)this._data.length) {
            this.resize();
        }
    }

    public List<DArrayIListEntry> extractValues() {
        ArrayList<DArrayIListEntry> ret = new ArrayList<DArrayIListEntry>();
        for (DArrayIListEntry e : this._data) {
            if (e == null) continue;
            ret.add(e);
        }
        return ret;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            return;
        }
        DArrayIListEntry[] olddata = this._data;
        this._data = new DArrayIListEntry[this._data.length * 2];
        this._size = 0;
        for (DArrayIListEntry e : olddata) {
            if (e == null) continue;
            this.appendValue(e.key, e.value);
        }
    }

    public void reset() {
        Arrays.fill(this._data, null);
        this._size = 0;
    }

    public void reset(int size) {
        int newSize = Util.getPow2(size);
        if (newSize > this._data.length) {
            this._data = new DArrayIListEntry[newSize];
        } else {
            Arrays.fill(this._data, null);
            if (size < this._data.length / 2) {
                this._data = new DArrayIListEntry[newSize];
            }
        }
        this._size = 0;
    }

    protected static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + this.hashCode());
        sb.append("   " + this._size);
        for (int i = 0; i < this._data.length; ++i) {
            DArrayIListEntry ent = this._data[i];
            if (ent == null) continue;
            sb.append("\n");
            sb.append("id:" + i);
            sb.append("[");
            sb.append(ent);
            sb.append("]");
        }
        return sb.toString();
    }

    public static class DArrayIListEntry {
        public DblArray key;
        public IntArrayList value;

        public DArrayIListEntry(DblArray ekey, IntArrayList evalue) {
            this.key = ekey;
            this.value = evalue;
        }

        public String toString() {
            return this.key + ":" + this.value;
        }

        public boolean keyEquals(DblArray keyThat) {
            return this.key.equals(keyThat);
        }
    }
}

