/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class FORUtil {
    protected static final double refSum(double[] reference) {
        double ret = 0.0;
        for (double d : reference) {
            ret += d;
        }
        return ret;
    }

    protected static final double refSumSq(double[] reference) {
        double ret = 0.0;
        for (double d : reference) {
            ret += d * d;
        }
        return ret;
    }

    protected static final boolean allZero(double[] in) {
        for (double v : in) {
            if (v == 0.0) continue;
            return false;
        }
        return true;
    }

    protected static final boolean containsInfOrNan(double pattern, double[] reference) {
        if (Double.isNaN(pattern)) {
            for (double d : reference) {
                if (!Double.isNaN(d)) continue;
                return true;
            }
            return false;
        }
        for (double d : reference) {
            if (!Double.isInfinite(d)) continue;
            return true;
        }
        return false;
    }

    protected static final double[] createReference(int nCol, double val) {
        double[] reference = new double[nCol];
        for (int i = 0; i < nCol; ++i) {
            reference[i] = val;
        }
        return reference;
    }

    protected static final double[] unaryOperator(UnaryOperator op, double[] reference) {
        double[] newRef = new double[reference.length];
        for (int i = 0; i < reference.length; ++i) {
            newRef[i] = op.fn.execute(reference[i]);
        }
        return newRef;
    }
}

