/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.TernarySPInstruction;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;

public class TernaryFrameScalarSPInstruction
extends TernarySPInstruction {
    protected TernaryFrameScalarSPInstruction(TernaryOperator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, in3, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        String expression = sec.getScalarInput(this.input2).getStringValue();
        long margin = ec.getScalarInput(this.input3).getLongValue();
        JavaPairRDD out = in1.mapValues((Function)new RDDStringProcessing(expression, margin));
        if (expression.contains("jaccardSim")) {
            long rows = sec.getDataCharacteristics(this.output.getName()).getRows();
            sec.getDataCharacteristics(this.output.getName()).setDimension(rows, rows);
        } else {
            long rows = sec.getDataCharacteristics(this.output.getName()).getRows();
            long cols = sec.getDataCharacteristics(this.output.getName()).getCols();
            sec.getDataCharacteristics(this.output.getName()).setDimension(rows, cols);
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    private static class RDDStringProcessing
    implements Function<FrameBlock, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766400L;
        private String _expr = null;
        private long _margin = -1L;

        public RDDStringProcessing(String expr, long margin) {
            this._expr = expr;
            this._margin = margin;
        }

        public FrameBlock call(FrameBlock arg0) throws Exception {
            FrameBlock fb = arg0.map(this._expr, this._margin);
            return fb;
        }
    }
}

