/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;

public final class RollingEventLogFilesWriter$ {
    public static RollingEventLogFilesWriter$ MODULE$;
    private final String EVENT_LOG_DIR_NAME_PREFIX;
    private final String EVENT_LOG_FILE_NAME_PREFIX;
    private final String APPSTATUS_FILE_NAME_PREFIX;

    static {
        new RollingEventLogFilesWriter$();
    }

    public String EVENT_LOG_DIR_NAME_PREFIX() {
        return this.EVENT_LOG_DIR_NAME_PREFIX;
    }

    public String EVENT_LOG_FILE_NAME_PREFIX() {
        return this.EVENT_LOG_FILE_NAME_PREFIX;
    }

    public String APPSTATUS_FILE_NAME_PREFIX() {
        return this.APPSTATUS_FILE_NAME_PREFIX;
    }

    public Path getAppEventLogDirPath(URI logBaseDir, String appId, Option<String> appAttemptId) {
        return new Path(new Path(logBaseDir), new StringBuilder(0).append(this.EVENT_LOG_DIR_NAME_PREFIX()).append(EventLogFileWriter$.MODULE$.nameForAppAndAttempt(appId, appAttemptId)).toString());
    }

    public Path getAppStatusFilePath(Path appLogDir, String appId, Option<String> appAttemptId, boolean inProgress) {
        String base = new StringBuilder(0).append(this.APPSTATUS_FILE_NAME_PREFIX()).append(EventLogFileWriter$.MODULE$.nameForAppAndAttempt(appId, appAttemptId)).toString();
        String name = inProgress ? new StringBuilder(0).append(base).append(EventLogFileWriter$.MODULE$.IN_PROGRESS()).toString() : base;
        return new Path(appLogDir, name);
    }

    public Path getEventLogFilePath(Path appLogDir, String appId, Option<String> appAttemptId, long index, Option<String> codecName) {
        String base = new StringBuilder(1).append(this.EVENT_LOG_FILE_NAME_PREFIX()).append(index).append("_").append(EventLogFileWriter$.MODULE$.nameForAppAndAttempt(appId, appAttemptId)).toString();
        String codec = (String)codecName.map((Function1 & java.io.Serializable & Serializable)x$7 -> new StringBuilder(1).append(".").append((String)x$7).toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "");
        return new Path(appLogDir, new StringBuilder(0).append(base).append(codec).toString());
    }

    public boolean isEventLogDir(FileStatus status) {
        return status.isDirectory() && status.getPath().getName().startsWith(this.EVENT_LOG_DIR_NAME_PREFIX());
    }

    public boolean isEventLogFile(String fileName) {
        return fileName.startsWith(this.EVENT_LOG_FILE_NAME_PREFIX());
    }

    public boolean isEventLogFile(FileStatus status) {
        return status.isFile() && this.isEventLogFile(status.getPath().getName());
    }

    public boolean isAppStatusFile(FileStatus status) {
        return status.isFile() && status.getPath().getName().startsWith(this.APPSTATUS_FILE_NAME_PREFIX());
    }

    public long getEventLogFileIndex(String eventLogFileName) {
        Predef$.MODULE$.require(this.isEventLogFile(eventLogFileName), (Function0 & java.io.Serializable & Serializable)() -> "Not an event log file!");
        String index = new StringOps(Predef$.MODULE$.augmentString(eventLogFileName)).stripPrefix(this.EVENT_LOG_FILE_NAME_PREFIX()).split("_")[0];
        return new StringOps(Predef$.MODULE$.augmentString(index)).toLong();
    }

    private RollingEventLogFilesWriter$() {
        MODULE$ = this;
        this.EVENT_LOG_DIR_NAME_PREFIX = "eventlog_v2_";
        this.EVENT_LOG_FILE_NAME_PREFIX = "events_";
        this.APPSTATUS_FILE_NAME_PREFIX = "appstatus_";
    }
}

