/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.FunctionCallIdentifier;
import org.apache.sysds.parser.IndexedIdentifier;
import org.apache.sysds.parser.Statement;
import org.apache.sysds.parser.VariableSet;

public class MultiAssignmentStatement
extends Statement {
    private ArrayList<DataIdentifier> _targetList;
    private Expression _source;

    @Override
    public Statement rewriteStatement(String prefix) {
        ArrayList<DataIdentifier> newTargetList = new ArrayList<DataIdentifier>();
        for (DataIdentifier target : this._targetList) {
            DataIdentifier newTarget = (DataIdentifier)target.rewriteExpression(prefix);
            newTargetList.add(newTarget);
        }
        Expression newSource = this._source.rewriteExpression(prefix);
        MultiAssignmentStatement retVal = new MultiAssignmentStatement(newTargetList, newSource);
        retVal.setParseInfo(this);
        return retVal;
    }

    public MultiAssignmentStatement(ArrayList<DataIdentifier> tList, Expression s) {
        this._targetList = tList;
        this._source = s;
    }

    public ArrayList<DataIdentifier> getTargetList() {
        return this._targetList;
    }

    public void setTargetList(List<DataIdentifier> diList) {
        this._targetList.clear();
        this._targetList.addAll(diList);
    }

    public Expression getSource() {
        return this._source;
    }

    @Override
    public boolean controlStatement() {
        return true;
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        return lo;
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._source.variablesRead());
        for (int i = 0; i < this._targetList.size(); ++i) {
            if (!(this._targetList.get(i) instanceof IndexedIdentifier)) continue;
            IndexedIdentifier target = (IndexedIdentifier)this._targetList.get(i);
            result.addVariables(target.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (DataIdentifier target : this._targetList) {
            result.addVariable(target.getName(), target);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Arrays.toString(this._targetList.toArray()));
        sb.append(" = ");
        sb.append(this._source.toString());
        sb.append(";");
        return sb.toString();
    }

    public void setSource(FunctionCallIdentifier s) {
        this._source = s;
    }
}

