/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.federated.FederatedStatistics;

public class FederatedReadCache {
    private static final Logger LOG = Logger.getLogger(FederatedReadCache.class);
    private Map<String, ReadCacheEntry> _rmap = new ConcurrentHashMap<String, ReadCacheEntry>();

    public CacheableData<?> get(String fname, boolean putPlaceholder) {
        ReadCacheEntry tmp = putPlaceholder ? this._rmap.putIfAbsent(fname, new ReadCacheEntry()) : this._rmap.get(fname);
        return tmp != null ? tmp.get() : null;
    }

    public void setData(String fname, CacheableData<?> data) {
        LOG.trace((Object)("Setting the data for the ReadCacheEntry of file " + fname));
        ReadCacheEntry rce = this._rmap.get(fname);
        if (rce == null) {
            throw new DMLRuntimeException("Tried to set the data for an unregistered ReadCacheEntry.");
        }
        rce.setValue(data);
    }

    public void setInvalid(String fname) {
        LOG.debug((Object)("Read of file " + fname + " failed. Setting the corresponding ReadCacheEntry to invalid."));
        ReadCacheEntry rce = this._rmap.get(fname);
        if (rce == null) {
            throw new DMLRuntimeException("Tried to set an unexisting ReadCacheEntry to invalid.");
        }
        rce.setInvalid();
    }

    public static class ReadCacheEntry {
        protected CacheableData<?> _data = null;
        private boolean _is_valid = true;

        public synchronized CacheableData<?> get() {
            try {
                while (this._data == null && this._is_valid) {
                    this.wait();
                }
                if (!this._is_valid) {
                    this._is_valid = true;
                    return null;
                }
            }
            catch (InterruptedException ex) {
                throw new DMLRuntimeException(ex);
            }
            if (DMLScript.STATISTICS) {
                FederatedStatistics.incFedReuseReadHitCount();
                FederatedStatistics.incFedReuseReadBytesCount(this._data);
            }
            return this._data;
        }

        public synchronized void setValue(CacheableData<?> val) {
            if (this._data != null) {
                throw new DMLRuntimeException("Tried to set the value of a ReadCacheEntry twice. Should only be performed once.");
            }
            this._data = val;
            this.notifyAll();
        }

        public synchronized void setInvalid() {
            this._is_valid = false;
            this.notify();
        }
    }
}

