/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.functionobjects;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.matrix.data.CTableMap;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.LongLongDoubleHashMap;
import org.apache.sysds.runtime.util.UtilFunctions;

public class CTable
extends ValueFunction {
    private static final long serialVersionUID = -5374880447194177236L;
    private static CTable singleObj = null;

    private CTable() {
    }

    public static CTable getCTableFnObject() {
        if (singleObj == null) {
            singleObj = new CTable();
        }
        return singleObj;
    }

    public void execute(double v1, double v2, double w, boolean ignoreZeros, CTableMap resultMap, MatrixBlock resultBlock) {
        if (resultBlock != null) {
            this.execute(v1, v2, w, ignoreZeros, resultBlock);
        } else {
            this.execute(v1, v2, w, ignoreZeros, resultMap);
        }
    }

    public void execute(double v1, double v2, double w, boolean ignoreZeros, CTableMap resultMap) {
        if (Double.isNaN(v1) || Double.isNaN(v2) || Double.isNaN(w)) {
            return;
        }
        long row = UtilFunctions.toLong(v1);
        long col = UtilFunctions.toLong(v2);
        if (ignoreZeros && row == 0L && col == 0L) {
            return;
        }
        if (row <= 0L || col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (one of the value <= zero): " + v1 + " " + v2);
        }
        resultMap.aggregate(row, col, w);
    }

    public void execute(double v1, double v2, double w, boolean ignoreZeros, MatrixBlock ctableResult) {
        if (Double.isNaN(v1) || Double.isNaN(v2) || Double.isNaN(w)) {
            return;
        }
        long row = UtilFunctions.toLong(v1);
        long col = UtilFunctions.toLong(v2);
        if (ignoreZeros && row == 0L && col == 0L) {
            return;
        }
        if (row <= 0L || col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (one of the value <= zero): " + v1 + " " + v2);
        }
        if (row > (long)ctableResult.getNumRows() || col > (long)ctableResult.getNumColumns()) {
            return;
        }
        ctableResult.quickSetValue((int)row - 1, (int)col - 1, ctableResult.quickGetValue((int)row - 1, (int)col - 1) + w);
    }

    public int execute(int row, double v2, double w, int maxCol, int[] retIx, double[] retVals) {
        if (Double.isNaN(v2) || Double.isNaN(w)) {
            return maxCol;
        }
        int col = UtilFunctions.toInt(v2);
        if (col <= 0) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (value <= zero): " + v2);
        }
        retIx[row - 1] = col - 1;
        retVals[row - 1] = w;
        return Math.max(maxCol, col);
    }

    public Pair<MatrixIndexes, Double> execute(long row, double v2, double w) {
        if (Double.isNaN(v2) || Double.isNaN(w)) {
            return new Pair<MatrixIndexes, Double>(new MatrixIndexes(-1L, -1L), w);
        }
        long col = UtilFunctions.toLong(v2);
        if (col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (value <= zero): " + v2);
        }
        return new Pair<MatrixIndexes, Double>(new MatrixIndexes(row, col), w);
    }

    public void execute(MatrixBlock in1, MatrixBlock in2, MatrixBlock w, CTableMap resultMap, int k) {
        ExecutorService pool = CommonThreadPool.get(k);
        ArrayList<CTableMap> partialMaps = new ArrayList<CTableMap>();
        try {
            ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
            int[] blockSizes = UtilFunctions.getBlockSizes(in1.getNumRows(), k);
            int startRow = 0;
            for (int i = 0; i < blockSizes.length; ++i) {
                tasks.add(this.getPartialCTableTask(in1, in2, w, startRow, blockSizes[i], partialMaps));
                startRow += blockSizes[i];
            }
            List taskret = pool.invokeAll(tasks);
            for (Future task : taskret) {
                task.get();
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        ArrayList<CTableMap> newPartialMaps = new ArrayList<CTableMap>();
        while (partialMaps.size() > 1) {
            newPartialMaps.clear();
            ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
            int count = 0;
            while (count + 1 < partialMaps.size()) {
                tasks.add(this.getMergePartialCTMapsTask(partialMaps.get(count), partialMaps.get(count + 1), newPartialMaps));
                count += 2;
            }
            try {
                List taskret = pool.invokeAll(tasks);
                for (Future task : taskret) {
                    task.get();
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
            if (count < partialMaps.size()) {
                newPartialMaps.add(partialMaps.get(count));
            }
            partialMaps.clear();
            partialMaps.addAll(newPartialMaps);
        }
        pool.shutdown();
        CTableMap map = partialMaps.get(0);
        Iterator<LongLongDoubleHashMap.ADoubleEntry> iter = map.getIterator();
        while (iter.hasNext()) {
            LongLongDoubleHashMap.ADoubleEntry e = iter.next();
            resultMap.aggregate(e.getKey1(), e.getKey2(), e.value);
        }
    }

    public Callable<Object> getPartialCTableTask(MatrixBlock in1, MatrixBlock in2, MatrixBlock w, int startInd, int blockSize, ArrayList<CTableMap> pmaps) {
        return new PartialCTableTask(in1, in2, w, startInd, blockSize, pmaps);
    }

    public Callable<Object> getMergePartialCTMapsTask(CTableMap map1, CTableMap map2, ArrayList<CTableMap> pmaps) {
        return new MergePartialCTMaps(map1, map2, pmaps);
    }

    private static class MergePartialCTMaps
    implements Callable<Object> {
        private final CTableMap _map1;
        private final CTableMap _map2;
        private final ArrayList<CTableMap> _partialCTmaps;

        protected MergePartialCTMaps(CTableMap map1, CTableMap map2, ArrayList<CTableMap> pmaps) {
            this._map1 = map1;
            this._map2 = map2;
            this._partialCTmaps = pmaps;
        }

        private void mergeToFinal(CTableMap map, CTableMap finalMap) {
            Iterator<LongLongDoubleHashMap.ADoubleEntry> iter = map.getIterator();
            while (iter.hasNext()) {
                LongLongDoubleHashMap.ADoubleEntry e = iter.next();
                finalMap.aggregate(e.getKey1(), e.getKey2(), e.value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            CTableMap mergedMap = new CTableMap(LongLongDoubleHashMap.EntryType.INT);
            this.mergeToFinal(this._map1, mergedMap);
            this.mergeToFinal(this._map2, mergedMap);
            ArrayList<CTableMap> arrayList = this._partialCTmaps;
            synchronized (arrayList) {
                this._partialCTmaps.add(mergedMap);
                return null;
            }
        }
    }

    private static class PartialCTableTask
    implements Callable<Object> {
        private final MatrixBlock _in1;
        private final MatrixBlock _in2;
        private final MatrixBlock _w;
        private final int _startInd;
        private final int _blockSize;
        private final ArrayList<CTableMap> _partialCTmaps;

        protected PartialCTableTask(MatrixBlock in1, MatrixBlock in2, MatrixBlock w, int startRow, int blockSize, ArrayList<CTableMap> pmaps) {
            this._in1 = in1;
            this._in2 = in2;
            this._w = w;
            this._startInd = startRow;
            this._blockSize = blockSize;
            this._partialCTmaps = pmaps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            CTable ctable = CTable.getCTableFnObject();
            CTableMap ctmap = new CTableMap(LongLongDoubleHashMap.EntryType.INT);
            int endInd = UtilFunctions.getEndIndex(this._in1.getNumRows(), this._startInd, this._blockSize);
            for (int i = this._startInd; i < endInd; ++i) {
                double v1 = this._in1.quickGetValue(i, 0);
                double v2 = this._in2.quickGetValue(i, 0);
                double w = this._w.quickGetValue(i, 0);
                ctable.execute(v1, v2, w, false, ctmap);
            }
            ArrayList<CTableMap> arrayList = this._partialCTmaps;
            synchronized (arrayList) {
                this._partialCTmaps.add(ctmap);
            }
            return null;
        }
    }
}

