/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl.metrics;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.client.impl.metrics.BlockReaderLocalMetrics;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockReaderIoProvider {
    public static final Logger LOG = LoggerFactory.getLogger(BlockReaderIoProvider.class);
    private final BlockReaderLocalMetrics metrics;
    private final boolean isEnabled;
    private final int sampleRangeMax;
    private final Timer timer;
    private static final long SLOW_READ_WARNING_THRESHOLD_MS = 1000L;
    private boolean isWarningLogged = false;

    public BlockReaderIoProvider(@Nullable DfsClientConf.ShortCircuitConf conf, BlockReaderLocalMetrics metrics, Timer timer) {
        if (conf != null) {
            this.isEnabled = conf.isScrMetricsEnabled();
            this.sampleRangeMax = 21474836 * conf.getScrMetricsSamplingPercentage();
            this.metrics = metrics;
            this.timer = timer;
        } else {
            this.isEnabled = false;
            this.sampleRangeMax = 0;
            this.metrics = null;
            this.timer = null;
        }
    }

    public int read(FileChannel dataIn, ByteBuffer dst, long position) throws IOException {
        int nRead;
        if (this.isEnabled && ThreadLocalRandom.current().nextInt() < this.sampleRangeMax) {
            long begin = this.timer.monotonicNow();
            nRead = dataIn.read(dst, position);
            long latency = this.timer.monotonicNow() - begin;
            this.addLatency(latency);
        } else {
            nRead = dataIn.read(dst, position);
        }
        return nRead;
    }

    private void addLatency(long latency) {
        this.metrics.addShortCircuitReadLatency(latency);
        if (latency > 1000L && !this.isWarningLogged) {
            LOG.warn(String.format("The Short Circuit Local Read latency, %d ms, is higher then the threshold (%d ms). Suppressing further warnings for this BlockReaderLocal.", latency, 1000L));
            this.isWarningLogged = true;
        }
    }
}

