/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public abstract class ADictionary
implements Serializable {
    private static final long serialVersionUID = 9118692576356558592L;
    protected static final Log LOG = LogFactory.getLog((String)ADictionary.class.getName());

    public abstract double[] getValues();

    public abstract double getValue(int var1);

    public abstract double getValue(int var1, int var2, int var3);

    public abstract long getInMemorySize();

    public abstract double aggregate(double var1, Builtin var3);

    public abstract double aggregateWithReference(double var1, Builtin var3, double[] var4, boolean var5);

    public abstract double[] aggregateRows(Builtin var1, int var2);

    public abstract double[] aggregateRowsWithDefault(Builtin var1, double[] var2);

    public abstract double[] aggregateRowsWithReference(Builtin var1, double[] var2);

    public abstract void aggregateCols(double[] var1, Builtin var2, IColIndex var3);

    public abstract void aggregateColsWithReference(double[] var1, Builtin var2, IColIndex var3, double[] var4, boolean var5);

    public abstract ADictionary applyScalarOp(ScalarOperator var1);

    public abstract ADictionary applyScalarOpAndAppend(ScalarOperator var1, double var2, int var4);

    public abstract ADictionary applyUnaryOp(UnaryOperator var1);

    public abstract ADictionary applyUnaryOpAndAppend(UnaryOperator var1, double var2, int var4);

    public abstract ADictionary applyScalarOpWithReference(ScalarOperator var1, double[] var2, double[] var3);

    public abstract ADictionary applyUnaryOpWithReference(UnaryOperator var1, double[] var2, double[] var3);

    public abstract ADictionary binOpLeft(BinaryOperator var1, double[] var2, IColIndex var3);

    public abstract ADictionary binOpLeftAndAppend(BinaryOperator var1, double[] var2, IColIndex var3);

    public abstract ADictionary binOpLeftWithReference(BinaryOperator var1, double[] var2, IColIndex var3, double[] var4, double[] var5);

    public abstract ADictionary binOpRight(BinaryOperator var1, double[] var2, IColIndex var3);

    public abstract ADictionary binOpRightAndAppend(BinaryOperator var1, double[] var2, IColIndex var3);

    public abstract ADictionary binOpRight(BinaryOperator var1, double[] var2);

    public abstract ADictionary binOpRightWithReference(BinaryOperator var1, double[] var2, IColIndex var3, double[] var4, double[] var5);

    public abstract ADictionary clone();

    public abstract void write(DataOutput var1) throws IOException;

    public abstract long getExactSizeOnDisk();

    public abstract DictType getDictType();

    public abstract int getNumberOfValues(int var1);

    public abstract double[] sumAllRowsToDouble(int var1);

    public abstract double[] sumAllRowsToDoubleWithDefault(double[] var1);

    public abstract double[] sumAllRowsToDoubleWithReference(double[] var1);

    public abstract double[] sumAllRowsToDoubleSq(int var1);

    public abstract double[] sumAllRowsToDoubleSqWithDefault(double[] var1);

    public abstract double[] sumAllRowsToDoubleSqWithReference(double[] var1);

    public abstract double[] productAllRowsToDouble(int var1);

    public abstract double[] productAllRowsToDoubleWithDefault(double[] var1);

    public abstract double[] productAllRowsToDoubleWithReference(double[] var1);

    public abstract void colSum(double[] var1, int[] var2, IColIndex var3);

    public abstract void colSumSq(double[] var1, int[] var2, IColIndex var3);

    public abstract void colSumSqWithReference(double[] var1, int[] var2, IColIndex var3, double[] var4);

    public abstract double sum(int[] var1, int var2);

    public abstract double sumSq(int[] var1, int var2);

    public abstract double sumSqWithReference(int[] var1, double[] var2);

    public abstract String getString(int var1);

    public abstract ADictionary sliceOutColumnRange(int var1, int var2, int var3);

    public abstract boolean containsValue(double var1);

    public abstract boolean containsValueWithReference(double var1, double[] var3);

    public abstract long getNumberNonZeros(int[] var1, int var2);

    public abstract long getNumberNonZerosWithReference(int[] var1, double[] var2, int var3);

    public abstract void addToEntry(double[] var1, int var2, int var3, int var4);

    public abstract void addToEntry(double[] var1, int var2, int var3, int var4, int var5);

    public abstract void addToEntryVectorized(double[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18);

    public abstract ADictionary subtractTuple(double[] var1);

    public abstract MatrixBlockDictionary getMBDict(int var1);

    public abstract ADictionary scaleTuples(int[] var1, int var2);

    public abstract ADictionary preaggValuesFromDense(int var1, IColIndex var2, IColIndex var3, double[] var4, int var5);

    public abstract ADictionary replace(double var1, double var3, int var5);

    public abstract ADictionary replaceWithReference(double var1, double var3, double[] var5);

    public abstract void product(double[] var1, int[] var2, int var3);

    public abstract void productWithDefault(double[] var1, int[] var2, double[] var3, int var4);

    public abstract void productWithReference(double[] var1, int[] var2, double[] var3, int var4);

    public abstract void colProduct(double[] var1, int[] var2, IColIndex var3);

    public abstract void colProductWithReference(double[] var1, int[] var2, IColIndex var3, double[] var4);

    public final CM_COV_Object centralMoment(ValueFunction fn, int[] counts, int nRows) {
        return this.centralMoment(new CM_COV_Object(), fn, counts, nRows);
    }

    public abstract CM_COV_Object centralMoment(CM_COV_Object var1, ValueFunction var2, int[] var3, int var4);

    public final CM_COV_Object centralMomentWithDefault(ValueFunction fn, int[] counts, double def, int nRows) {
        return this.centralMomentWithDefault(new CM_COV_Object(), fn, counts, def, nRows);
    }

    public abstract CM_COV_Object centralMomentWithDefault(CM_COV_Object var1, ValueFunction var2, int[] var3, double var4, int var6);

    public final CM_COV_Object centralMomentWithReference(ValueFunction fn, int[] counts, double reference, int nRows) {
        return this.centralMomentWithReference(new CM_COV_Object(), fn, counts, reference, nRows);
    }

    public abstract CM_COV_Object centralMomentWithReference(CM_COV_Object var1, ValueFunction var2, int[] var3, double var4, int var6);

    public abstract ADictionary rexpandCols(int var1, boolean var2, boolean var3, int var4);

    public abstract ADictionary rexpandColsWithReference(int var1, boolean var2, boolean var3, int var4);

    public abstract double getSparsity();

    public abstract void multiplyScalar(double var1, double[] var3, int var4, int var5, IColIndex var6);

    protected abstract void TSMMWithScaling(int[] var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    protected abstract void MMDict(ADictionary var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    protected abstract void MMDictDense(double[] var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    protected abstract void MMDictSparse(SparseBlock var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    protected abstract void TSMMToUpperTriangle(ADictionary var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    protected abstract void TSMMToUpperTriangleDense(double[] var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    protected abstract void TSMMToUpperTriangleSparse(SparseBlock var1, IColIndex var2, IColIndex var3, MatrixBlock var4);

    protected abstract void TSMMToUpperTriangleScaling(ADictionary var1, IColIndex var2, IColIndex var3, int[] var4, MatrixBlock var5);

    protected abstract void TSMMToUpperTriangleDenseScaling(double[] var1, IColIndex var2, IColIndex var3, int[] var4, MatrixBlock var5);

    protected abstract void TSMMToUpperTriangleSparseScaling(SparseBlock var1, IColIndex var2, IColIndex var3, int[] var4, MatrixBlock var5);

    protected static String doubleToString(double v) {
        if (v == (double)((long)v)) {
            return Long.toString((long)v);
        }
        return Double.toString(v);
    }

    protected static void correctNan(double[] res, IColIndex colIndexes) {
        for (int j = 0; j < colIndexes.size(); ++j) {
            int cix = colIndexes.get(j);
            res[cix] = Double.isNaN(res[cix]) ? 0.0 : res[cix];
        }
    }

    public final boolean equals(Object o) {
        if (o instanceof ADictionary) {
            return this.equals((ADictionary)o);
        }
        return false;
    }

    public abstract boolean equals(ADictionary var1);

    public static enum DictType {
        Delta,
        Dict,
        MatrixBlock,
        UInt8,
        Identity,
        IdentitySlice;

    }
}

