/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToByte
extends AMapToData {
    private static final long serialVersionUID = -2498505439667351828L;
    protected final byte[] _data;

    protected MapToByte(int size) {
        this(256, size);
    }

    public MapToByte(int unique, int size) {
        super(Math.min(unique, 256));
        this._data = new byte[size];
    }

    protected MapToByte(int unique, byte[] data) {
        super(unique);
        this._data = data;
    }

    protected MapToUByte toUByte() {
        return new MapToUByte(this.getUnique(), this._data);
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.BYTE;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n] & 0xFF;
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, (byte)v);
    }

    @Override
    public long getInMemorySize() {
        return MapToByte.getInMemorySize(this._data.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 24L;
        size = (long)((double)size + MemoryEstimates.byteArrayCost(dataLength));
        return size;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = (byte)v;
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data[n] = (byte)v;
        return this._data[n] & 0xFF;
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.BYTE.ordinal());
        this.writeBytes(out);
    }

    protected void writeBytes(DataOutput out) throws IOException {
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            out.writeByte(this._data[i]);
        }
    }

    protected static MapToByte readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readByte();
        }
        return new MapToByte(unique, data);
    }

    @Override
    public void replace(int v, int r) {
        byte cv = (byte)v;
        byte rv = (byte)r;
        for (int i = 0; i < this.size(); ++i) {
            if (this._data[i] != cv) continue;
            this._data[i] = rv;
        }
    }

    @Override
    public void copyInt(int[] d) {
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = (byte)d[i];
        }
    }

    @Override
    public void copyBit(BitSet d) {
        int i = d.nextSetBit(0);
        while (i >= 0) {
            this._data[i] = 1;
            i = d.nextSetBit(i + 1);
        }
    }

    @Override
    public int[] getCounts(int[] ret) {
        for (int i = 0; i < this._data.length; ++i) {
            int n = this._data[i] & 0xFF;
            ret[n] = ret[n] + 1;
        }
        return ret;
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this._data[rc] & 0xFF;
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            int n = this._data[rc] & 0xFF;
            preAV[n] = preAV[n] + mV[off];
            int n2 = this._data[rc + 1] & 0xFF;
            preAV[n2] = preAV[n2] + mV[off + 1];
            int n3 = this._data[rc + 2] & 0xFF;
            preAV[n3] = preAV[n3] + mV[off + 2];
            int n4 = this._data[rc + 3] & 0xFF;
            preAV[n4] = preAV[n4] + mV[off + 3];
            int n5 = this._data[rc + 4] & 0xFF;
            preAV[n5] = preAV[n5] + mV[off + 4];
            int n6 = this._data[rc + 5] & 0xFF;
            preAV[n6] = preAV[n6] + mV[off + 5];
            int n7 = this._data[rc + 6] & 0xFF;
            preAV[n7] = preAV[n7] + mV[off + 6];
            int n8 = this._data[rc + 7] & 0xFF;
            preAV[n8] = preAV[n8] + mV[off + 7];
            rc += 8;
            off += 8;
        }
    }

    @Override
    public int getUpperBoundValue() {
        return 255;
    }

    @Override
    public int countRuns() {
        int c = 1;
        byte prev = this._data[0];
        for (int i = 1; i < this._data.length; ++i) {
            c += prev == this._data[i] ? 0 : 1;
            prev = this._data[i];
        }
        return c;
    }

    @Override
    public AMapToData resize(int unique) {
        int size = this._data.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique != 2 || size <= 32) {
            if (unique <= 127) {
                MapToUByte ret = this.toUByte();
                ret.setUnique(unique);
                return ret;
            }
            this.setUnique(unique);
            return this;
        }
        MapToBit ret = new MapToBit(unique, size);
        ((AMapToData)ret).copy(this);
        return ret;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToByte(this.getUnique(), Arrays.copyOfRange(this._data, l, u));
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToByte) {
            MapToByte tb = (MapToByte)t;
            byte[] tbb = tb._data;
            int newSize = this._data.length + t.size();
            int newDistinct = Math.max(this.getUnique(), t.getUnique());
            byte[] ret = Arrays.copyOf(this._data, newSize);
            System.arraycopy(tbb, 0, ret, this._data.length, t.size());
            if (newDistinct < 127) {
                return new MapToUByte(newDistinct, ret);
            }
            return new MapToByte(newDistinct, ret);
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(AMapToDataGroup[] d) {
        int p = 0;
        for (AMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        byte[] ret = Arrays.copyOf(this._data, p);
        p = this.size();
        for (int i = 1; i < d.length; ++i) {
            MapToByte mm = (MapToByte)d[i].getMapToData();
            int ms = mm.size();
            System.arraycopy(mm._data, 0, ret, p, ms);
            p += ms;
        }
        if (this.getUnique() < 127) {
            return new MapToUByte(this.getUnique(), ret);
        }
        return new MapToByte(this.getUnique(), ret);
    }
}

