/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ConstScheme
implements ICLAScheme {
    final ColGroupConst g;

    protected ConstScheme(ColGroupConst g) {
        this.g = g;
    }

    public static ICLAScheme create(ColGroupConst g) {
        return new ConstScheme(g);
    }

    @Override
    public AColGroup encode(MatrixBlock data) {
        return this.encode(data, this.g.getColIndices(), this.g.getValues());
    }

    @Override
    public AColGroup encode(MatrixBlock data, IColIndex columns) {
        if (columns.size() != this.g.getColIndices().size()) {
            throw new IllegalArgumentException("Invalid columns to encode");
        }
        return this.encode(data, columns, this.g.getValues());
    }

    private AColGroup encode(MatrixBlock data, IColIndex cols, double[] values) {
        int nCol = data.getNumColumns();
        int nRow = data.getNumRows();
        if (nCol < cols.get(cols.size() - 1)) {
            LOG.warn((Object)"Invalid to encode matrix with less columns than encode scheme max column");
            return null;
        }
        if (data.isEmpty()) {
            LOG.warn((Object)"Invalid to encode an empty matrix into constant column group");
            return null;
        }
        if (data.isInSparseFormat()) {
            return this.encodeSparse(data, cols, values, nRow, nCol);
        }
        if (data.getDenseBlock().isContiguous()) {
            return this.encodeDense(data, cols, values, nRow, nCol);
        }
        return this.encodeGeneric(data, cols, values, nRow, nCol);
    }

    private AColGroup encodeDense(MatrixBlock data, IColIndex cols, double[] values, int nRow, int nCol) {
        double[] dv = data.getDenseBlockValues();
        for (int r = 0; r < nRow; ++r) {
            int off = r * nCol;
            for (int ci = 0; ci < cols.size(); ++ci) {
                if (dv[off + cols.get(ci)] == values[ci]) continue;
                return null;
            }
        }
        return this.returnG(cols);
    }

    private AColGroup encodeSparse(MatrixBlock data, IColIndex cols, double[] values, int nRow, int nCol) {
        SparseBlock sb = data.getSparseBlock();
        for (int r = 0; r < nRow; ++r) {
            if (sb.isEmpty(r)) {
                return null;
            }
            int apos = sb.pos(r);
            int alen = apos + sb.size(r);
            double[] aval = sb.values(r);
            int[] aix = sb.indexes(r);
            int p = 0;
            while (values[p] == 0.0) {
                ++p;
            }
            for (int j = apos; j < alen && p < cols.size(); ++j) {
                if (aix[j] == cols.get(p)) {
                    if (aval[j] != values[p]) {
                        return null;
                    }
                    ++p;
                    while (p < cols.size() && values[p] == 0.0) {
                        ++p;
                    }
                    continue;
                }
                if (aix[j] <= cols.get(p)) continue;
                return null;
            }
        }
        return this.returnG(cols);
    }

    private AColGroup encodeGeneric(MatrixBlock data, IColIndex cols, double[] values, int nRow, int nCol) {
        for (int r = 0; r < nRow; ++r) {
            for (int ci = 0; ci < cols.size(); ++ci) {
                if (data.quickGetValue(r, cols.get(ci)) == values[ci]) continue;
                return null;
            }
        }
        return this.returnG(cols);
    }

    private AColGroup returnG(IColIndex columns) {
        if (columns == this.g.getColIndices()) {
            return this.g;
        }
        return ColGroupConst.create(columns, this.g.getValues());
    }
}

