/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.util.HDFSTool;

public abstract class TensorReader {
    public abstract TensorBlock readTensorFromHDFS(String var1, long[] var2, int var3, Types.ValueType[] var4) throws IOException, DMLRuntimeException;

    protected static void checkValidInputFile(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            throw new IOException("File " + path.toString() + " does not exist on HDFS/LFS.");
        }
        if (HDFSTool.isFileEmpty(fs, path)) {
            throw new EOFException("Empty input file " + path.toString() + ".");
        }
    }
}

