/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public final class Utils {
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private Utils() {
        throw new AssertionError((Object)"No instances of Utils");
    }

    public static String readUntilNull(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder(buffer.remaining());
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b == 0) {
                return sb.toString();
            }
            sb.append((char)b);
        }
        throw new IllegalArgumentException("End of buffer reached before NULL");
    }

    public static void seekBufferToNextMultipleOfEight(ByteBuffer bb) {
        int pos = bb.position();
        if (pos % 8 == 0) {
            return;
        }
        bb.position(pos + (8 - pos % 8));
    }

    public static int readBytesAsUnsignedInt(ByteBuffer buffer, int length) {
        switch (length) {
            case 1: {
                return Byte.toUnsignedInt(buffer.get());
            }
            case 2: {
                return Short.toUnsignedInt(buffer.getShort());
            }
            case 3: {
                return Utils.readArbitraryLengthBytesAsUnsignedInt(buffer, length);
            }
            case 4: {
                int value = buffer.getInt();
                if (value < 0) {
                    throw new ArithmeticException("Could not convert to unsigned");
                }
                return value;
            }
            case 5: 
            case 6: 
            case 7: {
                return Utils.readArbitraryLengthBytesAsUnsignedInt(buffer, length);
            }
            case 8: {
                return Math.toIntExact(buffer.getLong());
            }
        }
        throw new IllegalArgumentException("Couldn't read " + length + " bytes as int");
    }

    private static int readArbitraryLengthBytesAsUnsignedInt(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return new BigInteger(1, bytes).intValueExact();
    }

    public static long readBytesAsUnsignedLong(ByteBuffer buffer, int length) {
        switch (length) {
            case 1: {
                return Byte.toUnsignedLong(buffer.get());
            }
            case 2: {
                return Short.toUnsignedLong(buffer.getShort());
            }
            case 3: {
                return Utils.readArbitraryLengthBytesAsUnsignedLong(buffer, length);
            }
            case 4: {
                return Integer.toUnsignedLong(buffer.getInt());
            }
            case 5: 
            case 6: 
            case 7: {
                return Utils.readArbitraryLengthBytesAsUnsignedLong(buffer, length);
            }
            case 8: {
                long value = buffer.getLong();
                if (value < 0L && value != -1L) {
                    throw new ArithmeticException("Could not convert to unsigned");
                }
                return value;
            }
        }
        throw new IllegalArgumentException("Couldn't read " + length + " bytes as int");
    }

    private static long readArbitraryLengthBytesAsUnsignedLong(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return new BigInteger(1, bytes).longValueExact();
    }

    public static ByteBuffer createSubBuffer(ByteBuffer source, int length) {
        ByteBuffer headerData = source.slice();
        headerData.limit(length);
        headerData.order(source.order());
        source.position(source.position() + length);
        return headerData;
    }

    public static int bitsToInt(BitSet bits, int start, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be >0");
        }
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < length; ++i) {
            if (!bits.get(start + i)) continue;
            result = result.add(TWO.pow(i));
        }
        return result.intValue();
    }
}

