/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class Append
extends Lop {
    public static final String OPCODE = "append";
    private boolean _cbind = true;
    private Types.ExecType _et;

    public Append(Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, boolean cbind, Types.ExecType et) {
        super(Lop.Type.Append, dt, vt);
        this._et = et;
        this.init(input1, input2, input3, dt, vt);
        this._cbind = cbind;
    }

    public void init(Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt) {
        this.addInput(input1);
        input1.addOutput(this);
        this.addInput(input2);
        input2.addOutput(this);
        this.addInput(input3);
        input3.addOutput(this);
        this.lps.setProperties(this.inputs, this._et);
    }

    @Override
    public String toString() {
        return " Append: ";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        String ret = InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.getInputs().get(2).prepScalarInputOperand(this.getExecType()), this.prepOutputOperand(output), String.valueOf(this._cbind));
        if (this.getExecType() == Types.ExecType.FED) {
            ret = InstructionUtils.concatOperands(ret, this._fedOutput.name());
        }
        return ret;
    }
}

