/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Builtins;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataGenOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.DnnOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LeftIndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.MultiThreadedHop;
import org.apache.sysds.hops.NaryOp;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.TernaryOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.hops.ipa.InterProceduralAnalysis;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriter;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.lops.compile.Dag;
import org.apache.sysds.lops.rewrite.LopRewriter;
import org.apache.sysds.parser.AssignmentStatement;
import org.apache.sysds.parser.BinaryExpression;
import org.apache.sysds.parser.BooleanExpression;
import org.apache.sysds.parser.BooleanIdentifier;
import org.apache.sysds.parser.BuiltinFunctionExpression;
import org.apache.sysds.parser.ConditionalPredicate;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.DoubleIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.ExpressionList;
import org.apache.sysds.parser.ForStatement;
import org.apache.sysds.parser.ForStatementBlock;
import org.apache.sysds.parser.FunctionCallIdentifier;
import org.apache.sysds.parser.FunctionDictionary;
import org.apache.sysds.parser.FunctionStatement;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.parser.Identifier;
import org.apache.sysds.parser.IfStatement;
import org.apache.sysds.parser.IfStatementBlock;
import org.apache.sysds.parser.IndexedIdentifier;
import org.apache.sysds.parser.IntIdentifier;
import org.apache.sysds.parser.IterablePredicate;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.MultiAssignmentStatement;
import org.apache.sysds.parser.OutputStatement;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.parser.ParameterizedBuiltinFunctionExpression;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.PrintStatement;
import org.apache.sysds.parser.RelationalExpression;
import org.apache.sysds.parser.Statement;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.parser.StringIdentifier;
import org.apache.sysds.parser.VariableSet;
import org.apache.sysds.parser.WhileStatement;
import org.apache.sysds.parser.WhileStatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysds.runtime.controlprogram.IfProgramBlock;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;

public class DMLTranslator {
    private static final Log LOG = LogFactory.getLog((String)DMLTranslator.class.getName());
    private DMLProgram _dmlProg;

    public DMLTranslator(DMLProgram dmlp) {
        this._dmlProg = dmlp;
        OptimizerUtils.resetDefaultSize();
        Recompiler.reinitRecompiler();
    }

    public void validateParseTree(DMLProgram dmlp) {
        this.validateParseTree(dmlp, true);
    }

    public void validateParseTree(DMLProgram dmlp, boolean inclFuns) {
        StatementBlock sb;
        int i;
        boolean fWriteRead = this.prepareReadAfterWrite(dmlp, new HashMap<String, DataIdentifier>());
        if (inclFuns) {
            for (String namespaceKey : dmlp.getNamespaces().keySet()) {
                for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    FunctionStatementBlock fblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                    this.validateFunction(dmlp, fblock);
                }
            }
        }
        VariableSet vs = new VariableSet();
        HashMap<String, ConstIdentifier> constVars = new HashMap<String, ConstIdentifier>();
        for (i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            sb = dmlp.getStatementBlock(i);
            vs = sb.validate(dmlp, vs, constVars, fWriteRead);
            constVars = sb.getConstOut();
        }
        if (fWriteRead) {
            this.prepareReadAfterWrite(dmlp, new HashMap<String, DataIdentifier>());
            vs = new VariableSet();
            constVars = new HashMap();
            for (i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
                sb = dmlp.getStatementBlock(i);
                vs = sb.validate(dmlp, vs, constVars, fWriteRead);
                constVars = sb.getConstOut();
            }
        }
    }

    public void validateFunction(DMLProgram dmlp, FunctionStatementBlock fsb) {
        this.validateFunction(dmlp, fsb, false);
    }

    public void validateFunction(DMLProgram dmlp, FunctionStatementBlock fsb, boolean conditional) {
        HashMap<String, ConstIdentifier> constVars = new HashMap<String, ConstIdentifier>();
        VariableSet vs = new VariableSet();
        FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
        for (DataIdentifier currVar : fstmt.getInputParams()) {
            if (currVar.getDataType() == Types.DataType.SCALAR) {
                currVar.setDimensions(0L, 0L);
            }
            vs.addVariable(currVar.getName(), currVar);
        }
        fsb.validate(dmlp, vs, constVars, conditional);
    }

    public void liveVariableAnalysis(DMLProgram dmlp) {
        this.liveVariableAnalysis(dmlp, true);
    }

    public void liveVariableAnalysis(DMLProgram dmlp, boolean inclFuns) {
        if (inclFuns) {
            for (String namespaceKey : dmlp.getNamespaces().keySet()) {
                for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    FunctionStatementBlock fsb = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                    this.liveVariableAnalysisFunction(dmlp, fsb);
                }
            }
        }
        VariableSet currentLiveOut = new VariableSet();
        VariableSet activeIn = new VariableSet();
        dmlp.setStatementBlocks(StatementBlock.mergeFunctionCalls(dmlp.getStatementBlocks(), dmlp));
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock sb = dmlp.getStatementBlock(i);
            activeIn = sb.initializeforwardLV(activeIn);
        }
        if (dmlp.getNumStatementBlocks() > 0) {
            StatementBlock lastSb = dmlp.getStatementBlock(dmlp.getNumStatementBlocks() - 1);
            lastSb._liveOut = new VariableSet();
            for (int i = dmlp.getNumStatementBlocks() - 1; i >= 0; --i) {
                StatementBlock sb = dmlp.getStatementBlock(i);
                currentLiveOut = sb.analyze(currentLiveOut);
            }
        }
        this.cleanupLiveOutVariables(dmlp.getStatementBlocks(), new VariableSet());
    }

    public void liveVariableAnalysisFunction(DMLProgram dmlp, FunctionStatementBlock fsb) {
        FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
        fstmt.setBody(StatementBlock.mergeFunctionCalls(fstmt.getBody(), dmlp));
        VariableSet activeIn = new VariableSet();
        for (DataIdentifier id : fstmt.getInputParams()) {
            activeIn.addVariable(id.getName(), id);
        }
        fsb.initializeforwardLV(activeIn);
        VariableSet currentLiveOut = new VariableSet();
        VariableSet currentLiveIn = new VariableSet();
        VariableSet unionLiveIn = new VariableSet();
        for (DataIdentifier id : fstmt.getInputParams()) {
            currentLiveIn.addVariable(id.getName(), id);
        }
        for (DataIdentifier id : fstmt.getOutputParams()) {
            currentLiveOut.addVariable(id.getName(), id);
            unionLiveIn.addVariable(id.getName(), id);
        }
        fsb._liveOut = currentLiveOut;
        fsb.analyze(currentLiveIn, currentLiveOut);
        this.cleanupLiveOutVariables(fstmt.getBody(), unionLiveIn);
    }

    public void cleanupLiveOutVariables(List<StatementBlock> sbs, VariableSet unionLiveIn) {
        for (int i = sbs.size() - 1; i >= 0; --i) {
            StatementBlock sb = sbs.get(i);
            sb.liveOut().removeVariables(VariableSet.minus(sb.liveOut(), unionLiveIn));
            unionLiveIn.addVariables(sb.liveIn());
        }
    }

    public void constructHops(DMLProgram dmlp) {
        this.constructHops(dmlp, true);
    }

    public void constructHops(DMLProgram dmlp, boolean inclFuns) {
        if (inclFuns) {
            for (FunctionDictionary<FunctionStatementBlock> fdict : dmlp.getNamespaces().values()) {
                for (FunctionStatementBlock fsb : fdict.getFunctions().values()) {
                    this.constructHops(fsb);
                }
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            this.constructHops(current);
        }
    }

    public void rewriteHopsDAG(DMLProgram dmlp) {
        ProgramRewriter rewriter = new ProgramRewriter(true, false);
        rewriter.rewriteProgramHopDAGs(dmlp, false);
        DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        rewriter.rewriteProgramHopDAGs(dmlp, true);
        DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        if (OptimizerUtils.ALLOW_INTER_PROCEDURAL_ANALYSIS) {
            InterProceduralAnalysis ipa = new InterProceduralAnalysis(dmlp);
            ipa.analyzeProgram(OptimizerUtils.IPA_NUM_REPETITIONS);
            DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        }
        ProgramRewriter rewriter2 = new ProgramRewriter(false, true);
        rewriter2.rewriteProgramHopDAGs(dmlp);
        DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        DMLTranslator.refreshMemEstimates(dmlp);
        DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        DMLConfig dmlconf = ConfigurationManager.getDMLConfig();
        if (ConfigurationManager.isCodegenEnabled()) {
            SpoofCompiler.PLAN_CACHE_POLICY = SpoofCompiler.PlanCachePolicy.get(dmlconf.getBooleanValue("sysds.codegen.plancache"), dmlconf.getIntValue("sysds.codegen.literals") == 2);
            SpoofCompiler.setConfiguredPlanSelector();
            SpoofCompiler.setExecTypeSpecificJavaCompiler();
            if (SpoofCompiler.INTEGRATION == SpoofCompiler.IntegrationType.HOPS) {
                this.codgenHopsDAG(dmlp);
            }
        }
    }

    public void rewriteLopDAG(DMLProgram dmlp) {
        LopRewriter rewriter = new LopRewriter();
        rewriter.rewriteProgramLopDAGs(dmlp);
    }

    public void codgenHopsDAG(DMLProgram dmlp) {
        SpoofCompiler.generateCode(dmlp);
    }

    public void codgenHopsDAG(Program rtprog) {
        SpoofCompiler.generateCode(rtprog);
    }

    public void codgenHopsDAG(ProgramBlock pb) {
        SpoofCompiler.generateCodeFromProgramBlock(pb);
    }

    public void constructLops(DMLProgram dmlp) {
        for (FunctionDictionary<FunctionStatementBlock> fdict : dmlp.getNamespaces().values()) {
            for (FunctionStatementBlock fsb : fdict.getFunctions().values()) {
                this.constructLops(fsb);
            }
            if (fdict.getFunctions(false) == null) continue;
            for (FunctionStatementBlock fsb : fdict.getFunctions(false).values()) {
                this.constructLops(fsb);
            }
        }
        for (StatementBlock sb : dmlp.getStatementBlocks()) {
            this.constructLops(sb);
        }
    }

    public boolean constructLops(StatementBlock sb) {
        boolean ret = false;
        if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement whileStmt = (WhileStatement)wsb.getStatement(0);
            ArrayList<StatementBlock> body = whileStmt.getBody();
            for (StatementBlock stmtBlock : body) {
                ret |= this.constructLops(stmtBlock);
            }
            Lop l = wsb.getPredicateHops().constructLops();
            wsb.setPredicateLops(l);
            ret |= wsb.updatePredicateRecompilationFlag();
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement ifStmt = (IfStatement)isb.getStatement(0);
            ArrayList<StatementBlock> ifBody = ifStmt.getIfBody();
            ArrayList<StatementBlock> elseBody = ifStmt.getElseBody();
            for (StatementBlock stmtBlock : ifBody) {
                ret |= this.constructLops(stmtBlock);
            }
            for (StatementBlock stmtBlock : elseBody) {
                ret |= this.constructLops(stmtBlock);
            }
            Lop l = isb.getPredicateHops().constructLops();
            isb.setPredicateLops(l);
            ret |= isb.updatePredicateRecompilationFlag();
        } else if (sb instanceof ForStatementBlock) {
            Lop llobs;
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fs = (ForStatement)sb.getStatement(0);
            ArrayList<StatementBlock> body = fs.getBody();
            for (StatementBlock stmtBlock : body) {
                ret |= this.constructLops(stmtBlock);
            }
            if (fsb.getFromHops() != null) {
                llobs = fsb.getFromHops().constructLops();
                fsb.setFromLops(llobs);
            }
            if (fsb.getToHops() != null) {
                llobs = fsb.getToHops().constructLops();
                fsb.setToLops(llobs);
            }
            if (fsb.getIncrementHops() != null) {
                llobs = fsb.getIncrementHops().constructLops();
                fsb.setIncrementLops(llobs);
            }
            ret |= fsb.updatePredicateRecompilationFlags();
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement functStmt = (FunctionStatement)sb.getStatement(0);
            ArrayList<StatementBlock> body = functStmt.getBody();
            for (StatementBlock stmtBlock : body) {
                ret |= this.constructLops(stmtBlock);
            }
            if (fsb.isRecompileOnce()) {
                fsb.setRecompileOnce(ret);
            }
        } else {
            if (sb.getHops() == null) {
                sb.setHops(new ArrayList<Hop>());
            }
            ArrayList<Lop> lops = new ArrayList<Lop>();
            for (Hop hop : sb.getHops()) {
                lops.add(hop.constructLops());
            }
            sb.setLops(lops);
            ret |= sb.updateRecompilationFlag();
        }
        return ret;
    }

    public Program getRuntimeProgram(DMLProgram prog, DMLConfig config) throws LanguageException, DMLRuntimeException, LopsException, HopsException {
        Program rtprog = new Program(prog);
        for (String namespace : prog.getNamespaces().keySet()) {
            for (String fname : prog.getFunctionStatementBlocks(namespace).keySet()) {
                FunctionStatementBlock fsb = prog.getFunctionStatementBlocks(namespace).get(fname);
                this.prepareAndAddFunctionProgramBlock(rtprog, config, namespace, fname, fsb, true);
                if (!prog.getNamespaces().get(namespace).containsFunction(fname, false)) continue;
                this.prepareAndAddFunctionProgramBlock(rtprog, config, namespace, fname, prog.getNamespaces().get(namespace).getFunction(fname, false), false);
            }
        }
        for (StatementBlock sb : prog.getStatementBlocks()) {
            ProgramBlock rtpb = this.createRuntimeProgramBlock(rtprog, sb, config);
            rtprog.addProgramBlock(rtpb);
        }
        if (ConfigurationManager.isCodegenEnabled() && SpoofCompiler.INTEGRATION == SpoofCompiler.IntegrationType.RUNTIME) {
            this.codgenHopsDAG(rtprog);
        }
        return rtprog;
    }

    private void prepareAndAddFunctionProgramBlock(Program rtprog, DMLConfig config, String fnamespace, String fname, FunctionStatementBlock fsb, boolean opt) {
        FunctionProgramBlock rtpb = (FunctionProgramBlock)this.createRuntimeProgramBlock(rtprog, fsb, config);
        rtprog.addFunctionProgramBlock(fnamespace, fname, rtpb, opt);
        rtpb.setRecompileOnce(fsb.isRecompileOnce());
        rtpb.setNondeterministic(fsb.isNondeterministic());
    }

    public ProgramBlock createRuntimeProgramBlock(Program prog, StatementBlock sb, DMLConfig config) {
        Dag<Lop> dag = null;
        Dag<Lop> pred_dag = null;
        ArrayList<Instruction> pred_instruct = null;
        Object retPB = null;
        if (sb instanceof WhileStatementBlock) {
            pred_dag = new Dag<Lop>();
            ((WhileStatementBlock)sb).getPredicateLops().addToDag(pred_dag);
            pred_instruct = new ArrayList<Instruction>();
            ArrayList<Instruction> pInst = pred_dag.getJobs(null, config);
            for (Instruction i : pInst) {
                pred_instruct.add(i);
            }
            WhileProgramBlock rtpb = new WhileProgramBlock(prog, pred_instruct);
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            for (StatementBlock sblock : wstmt.getBody()) {
                ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlock(childBlock);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setExitInstruction(DMLTranslator.deriveExitInstruction(sb));
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        } else if (sb instanceof IfStatementBlock) {
            ProgramBlock childBlock;
            pred_dag = new Dag();
            ((IfStatementBlock)sb).getPredicateLops().addToDag(pred_dag);
            pred_instruct = new ArrayList();
            ArrayList<Instruction> pInst = pred_dag.getJobs(null, config);
            for (Instruction i : pInst) {
                pred_instruct.add(i);
            }
            IfProgramBlock rtpb = new IfProgramBlock(prog, pred_instruct);
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            for (StatementBlock sblock : istmt.getIfBody()) {
                childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlockIfBody(childBlock);
            }
            for (StatementBlock sblock : istmt.getElseBody()) {
                childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlockElseBody(childBlock);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setExitInstruction(DMLTranslator.deriveExitInstruction(sb));
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            Dag<Lop> fromDag = new Dag<Lop>();
            Dag<Lop> toDag = new Dag<Lop>();
            Dag<Lop> incrementDag = new Dag<Lop>();
            if (fsb.getFromHops() != null) {
                fsb.getFromLops().addToDag(fromDag);
            }
            if (fsb.getToHops() != null) {
                fsb.getToLops().addToDag(toDag);
            }
            if (fsb.getIncrementHops() != null) {
                fsb.getIncrementLops().addToDag(incrementDag);
            }
            ArrayList<Instruction> fromInstructions = fromDag.getJobs(null, config);
            ArrayList<Instruction> toInstructions = toDag.getJobs(null, config);
            ArrayList<Instruction> incrementInstructions = incrementDag.getJobs(null, config);
            ForProgramBlock rtpb = null;
            IterablePredicate iterPred = fsb.getIterPredicate();
            if (sb instanceof ParForStatementBlock && ConfigurationManager.isParallelParFor()) {
                rtpb = new ParForProgramBlock(prog, iterPred.getIterVar().getName(), iterPred.getParForParams(), ((ParForStatementBlock)sb).getResultVariables());
                ParForProgramBlock pfrtpb = (ParForProgramBlock)rtpb;
                pfrtpb.setStatementBlock(sb);
            } else {
                rtpb = new ForProgramBlock(prog, iterPred.getIterVar().getName());
            }
            rtpb.setFromInstructions(fromInstructions);
            rtpb.setToInstructions(toInstructions);
            rtpb.setIncrementInstructions(incrementInstructions);
            ForStatement fs = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sblock : fs.getBody()) {
                ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlock(childBlock);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setExitInstruction(DMLTranslator.deriveExitInstruction(sb));
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            FunctionProgramBlock rtpb = null;
            rtpb = new FunctionProgramBlock(prog, fstmt.getInputParams(), fstmt.getOutputParams());
            for (StatementBlock sblock : fstmt.getBody()) {
                ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlock(childBlock);
            }
            if (fsb.getLops() != null && !fsb.getLops().isEmpty()) {
                throw new LopsException(fsb.printBlockErrorLocation() + "FunctionStatementBlock should have no Lops");
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        } else {
            BasicProgramBlock rtpb = new BasicProgramBlock(prog);
            dag = new Dag<Lop>();
            if (sb.getLops() != null && !sb.getLops().isEmpty()) {
                for (Lop l : sb.getLops()) {
                    l.addToDag(dag);
                }
                ArrayList<Instruction> instruct = dag.getJobs(sb, config);
                rtpb.addInstructions(instruct);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setParseInfo(sb);
        }
        return retPB;
    }

    public static void refreshMemEstimates(DMLProgram dmlp) {
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                DMLTranslator.refreshMemEstimates(fsblock);
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            DMLTranslator.refreshMemEstimates(current);
        }
    }

    private static Instruction deriveExitInstruction(StatementBlock sb) {
        Set<String> rmVars = VariableSet.union(VariableSet.minus(sb.liveIn(), sb.liveOut()), VariableSet.minus(sb.getKill(), sb.liveOut())).getVariableNames();
        return rmVars.isEmpty() ? null : VariableCPInstruction.prepareRemoveInstruction(rmVars.toArray(new String[0]));
    }

    public static void refreshMemEstimates(StatementBlock current) {
        block14: {
            Statement ws;
            block16: {
                block15: {
                    block13: {
                        ArrayList<Hop> hopsDAG;
                        MemoTable memo = new MemoTable();
                        if (HopRewriteUtils.isLastLevelStatementBlock(current) && (hopsDAG = current.getHops()) != null && !hopsDAG.isEmpty()) {
                            for (Hop hop : hopsDAG) {
                                hop.refreshMemEstimates(memo);
                            }
                        }
                        if (!(current instanceof FunctionStatementBlock)) break block13;
                        FunctionStatement fstmt = (FunctionStatement)current.getStatement(0);
                        for (StatementBlock sb : fstmt.getBody()) {
                            DMLTranslator.refreshMemEstimates(sb);
                        }
                        break block14;
                    }
                    if (!(current instanceof WhileStatementBlock)) break block15;
                    WhileStatementBlock wstb = (WhileStatementBlock)current;
                    wstb.getPredicateHops().refreshMemEstimates(new MemoTable());
                    if (wstb.getNumStatements() > 1) {
                        LOG.debug((Object)"While statement block has more than 1 stmt");
                    }
                    ws = (WhileStatement)wstb.getStatement(0);
                    for (StatementBlock sb : ((WhileStatement)ws).getBody()) {
                        DMLTranslator.refreshMemEstimates(sb);
                    }
                    break block14;
                }
                if (!(current instanceof IfStatementBlock)) break block16;
                IfStatementBlock istb = (IfStatementBlock)current;
                istb.getPredicateHops().refreshMemEstimates(new MemoTable());
                if (istb.getNumStatements() > 1) {
                    LOG.debug((Object)"If statement block has more than 1 stmt");
                }
                IfStatement is = (IfStatement)istb.getStatement(0);
                for (StatementBlock sb : is.getIfBody()) {
                    DMLTranslator.refreshMemEstimates(sb);
                }
                for (StatementBlock sb : is.getElseBody()) {
                    DMLTranslator.refreshMemEstimates(sb);
                }
                break block14;
            }
            if (!(current instanceof ForStatementBlock)) break block14;
            ForStatementBlock fsb = (ForStatementBlock)current;
            if (fsb.getFromHops() != null) {
                fsb.getFromHops().refreshMemEstimates(new MemoTable());
            }
            if (fsb.getToHops() != null) {
                fsb.getToHops().refreshMemEstimates(new MemoTable());
            }
            if (fsb.getIncrementHops() != null) {
                fsb.getIncrementHops().refreshMemEstimates(new MemoTable());
            }
            if (fsb.getNumStatements() > 1) {
                LOG.debug((Object)"For statement block has more than 1 stmt");
            }
            ws = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sb : ((ForStatement)ws).getBody()) {
                DMLTranslator.refreshMemEstimates(sb);
            }
        }
    }

    public static void resetHopsDAGVisitStatus(DMLProgram dmlp) {
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                DMLTranslator.resetHopsDAGVisitStatus(fsblock);
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            DMLTranslator.resetHopsDAGVisitStatus(current);
        }
    }

    public static void resetHopsDAGVisitStatus(StatementBlock current) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        ArrayList<Hop> hopsDAG;
                        if (HopRewriteUtils.isLastLevelStatementBlock(current) && (hopsDAG = current.getHops()) != null && !hopsDAG.isEmpty()) {
                            Hop.resetVisitStatus(hopsDAG);
                        }
                        if (!(current instanceof FunctionStatementBlock)) break block10;
                        FunctionStatement fstmt = (FunctionStatement)current.getStatement(0);
                        for (StatementBlock sb : fstmt.getBody()) {
                            DMLTranslator.resetHopsDAGVisitStatus(sb);
                        }
                        break block11;
                    }
                    if (!(current instanceof WhileStatementBlock)) break block12;
                    WhileStatementBlock wstb = (WhileStatementBlock)current;
                    wstb.getPredicateHops().resetVisitStatus();
                    WhileStatement ws = (WhileStatement)wstb.getStatement(0);
                    for (StatementBlock sb : ws.getBody()) {
                        DMLTranslator.resetHopsDAGVisitStatus(sb);
                    }
                    break block11;
                }
                if (!(current instanceof IfStatementBlock)) break block13;
                IfStatementBlock istb = (IfStatementBlock)current;
                istb.getPredicateHops().resetVisitStatus();
                IfStatement is = (IfStatement)istb.getStatement(0);
                for (StatementBlock sb : is.getIfBody()) {
                    DMLTranslator.resetHopsDAGVisitStatus(sb);
                }
                for (StatementBlock sb : is.getElseBody()) {
                    DMLTranslator.resetHopsDAGVisitStatus(sb);
                }
                break block11;
            }
            if (!(current instanceof ForStatementBlock)) break block11;
            ForStatementBlock fsb = (ForStatementBlock)current;
            if (fsb.getFromHops() != null) {
                fsb.getFromHops().resetVisitStatus();
            }
            if (fsb.getToHops() != null) {
                fsb.getToHops().resetVisitStatus();
            }
            if (fsb.getIncrementHops() != null) {
                fsb.getIncrementHops().resetVisitStatus();
            }
            if (fsb.getNumStatements() > 1) {
                LOG.debug((Object)"For statment block has more than 1 stmt");
            }
            ForStatement ws = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sb : ws.getBody()) {
                DMLTranslator.resetHopsDAGVisitStatus(sb);
            }
        }
    }

    public void resetLopsDAGVisitStatus(DMLProgram dmlp) {
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                this.resetLopsDAGVisitStatus(fsblock);
            }
        }
        for (int i = 0; i < dmlp.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlp.getStatementBlock(i);
            this.resetLopsDAGVisitStatus(current);
        }
    }

    public void resetLopsDAGVisitStatus(StatementBlock current) {
        Statement ws;
        StatementBlock fsb;
        ArrayList<Hop> hopsDAG = current.getHops();
        if (hopsDAG != null && !hopsDAG.isEmpty()) {
            for (Hop currentHop : hopsDAG) {
                currentHop.getLops().resetVisitStatus();
            }
        }
        if (current instanceof FunctionStatementBlock) {
            fsb = (FunctionStatementBlock)current;
            FunctionStatement fs = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock sb : fs.getBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
        }
        if (current instanceof WhileStatementBlock) {
            WhileStatementBlock wstb = (WhileStatementBlock)current;
            wstb.getPredicateLops().resetVisitStatus();
            if (wstb.getNumStatements() > 1) {
                LOG.debug((Object)"While statement block has more than 1 stmt");
            }
            ws = (WhileStatement)wstb.getStatement(0);
            for (StatementBlock sb : ((WhileStatement)ws).getBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
        }
        if (current instanceof IfStatementBlock) {
            IfStatementBlock istb = (IfStatementBlock)current;
            istb.getPredicateLops().resetVisitStatus();
            if (istb.getNumStatements() > 1) {
                LOG.debug((Object)"If statement block has more than 1 stmt");
            }
            IfStatement is = (IfStatement)istb.getStatement(0);
            for (StatementBlock sb : is.getIfBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
            for (StatementBlock sb : is.getElseBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
        }
        if (current instanceof ForStatementBlock) {
            fsb = (ForStatementBlock)current;
            if (((ForStatementBlock)fsb).getFromLops() != null) {
                ((ForStatementBlock)fsb).getFromLops().resetVisitStatus();
            }
            if (((ForStatementBlock)fsb).getToLops() != null) {
                ((ForStatementBlock)fsb).getToLops().resetVisitStatus();
            }
            if (((ForStatementBlock)fsb).getIncrementLops() != null) {
                ((ForStatementBlock)fsb).getIncrementLops().resetVisitStatus();
            }
            if (fsb.getNumStatements() > 1) {
                LOG.debug((Object)"For statement block has more than 1 stmt");
            }
            ws = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sb : ((ForStatement)ws).getBody()) {
                this.resetLopsDAGVisitStatus(sb);
            }
        }
    }

    public void constructHops(StatementBlock sb) {
        DataIdentifier target;
        MultiAssignmentStatement mas;
        AssignmentStatement as;
        Statement current;
        int i;
        if (sb instanceof WhileStatementBlock) {
            this.constructHopsForWhileControlBlock((WhileStatementBlock)sb);
            return;
        }
        if (sb instanceof IfStatementBlock) {
            this.constructHopsForIfControlBlock((IfStatementBlock)sb);
            return;
        }
        if (sb instanceof ForStatementBlock) {
            this.constructHopsForForControlBlock((ForStatementBlock)sb);
            return;
        }
        if (sb instanceof FunctionStatementBlock) {
            this.constructHopsForFunctionControlBlock((FunctionStatementBlock)sb);
            return;
        }
        HashMap<String, Hop> ids = new HashMap<String, Hop>();
        ArrayList<Hop> output = new ArrayList<Hop>();
        VariableSet liveIn = sb.liveIn();
        VariableSet liveOut = sb.liveOut();
        VariableSet updated = sb._updated;
        VariableSet gen = sb._gen;
        VariableSet updatedLiveOut = new VariableSet();
        HashMap<String, Integer> liveOutToTemp = new HashMap<String, Integer>();
        for (i = 0; i < sb.getNumStatements(); ++i) {
            Object target2;
            current = sb.getStatement(i);
            if (current instanceof AssignmentStatement && (target2 = (as = (AssignmentStatement)current).getTarget()) != null && liveOut.containsVariable(((DataIdentifier)target2).getName())) {
                liveOutToTemp.put(((DataIdentifier)target2).getName(), i);
            }
            if (!(current instanceof MultiAssignmentStatement)) continue;
            mas = (MultiAssignmentStatement)current;
            target2 = mas.getTargetList().iterator();
            while (target2.hasNext()) {
                target = (DataIdentifier)target2.next();
                if (!liveOut.containsVariable(target.getName())) continue;
                liveOutToTemp.put(target.getName(), i);
            }
        }
        if (!liveIn.getVariables().values().isEmpty()) {
            for (String varName : liveIn.getVariables().keySet()) {
                if (!updated.containsVariable(varName) && !gen.containsVariable(varName)) continue;
                DataIdentifier var = liveIn.getVariables().get(varName);
                long actualDim1 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim1() : var.getDim1();
                long actualDim2 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim2() : var.getDim2();
                DataOp read = new DataOp(var.getName(), var.getDataType(), var.getValueType(), Types.OpOpData.TRANSIENTREAD, null, actualDim1, actualDim2, var.getNnz(), var.getBlocksize());
                read.setParseInfo(var);
                ids.put(varName, read);
            }
        }
        for (i = 0; i < sb.getNumStatements(); ++i) {
            Hop fcall;
            Hop ae;
            current = sb.getStatement(i);
            if (current instanceof OutputStatement) {
                OutputStatement os = (OutputStatement)current;
                DataExpression source = os.getSource();
                target = os.getIdentifier();
                if (target instanceof IndexedIdentifier) {
                    throw new LanguageException(source.printErrorLocation() + ": Unsupported indexing expression in write statement. Please, assign the right indexing result to a variable and write this variable.");
                }
                ae = (DataOp)this.processExpression(source, target, ids);
                String formatName = os.getExprParam("format").toString();
                ((DataOp)ae).setFileFormat(Expression.convertFormatType(formatName));
                if (ae.getDataType() == Types.DataType.SCALAR) {
                    ((DataOp)ae).setOutputParams(ae.getDim1(), ae.getDim2(), ae.getNnz(), ae.getUpdateType(), -1);
                } else {
                    switch (((DataOp)ae).getFileFormat()) {
                        case TEXT: 
                        case MM: 
                        case CSV: 
                        case LIBSVM: 
                        case HDF5: {
                            ((DataOp)ae).setOutputParams(ae.getDim1(), ae.getDim2(), ae.getNnz(), ae.getUpdateType(), -1);
                            break;
                        }
                        case BINARY: 
                        case COMPRESSED: {
                            ((DataOp)ae).setOutputParams(ae.getDim1(), ae.getDim2(), ae.getNnz(), ae.getUpdateType(), ae.getBlocksize());
                            break;
                        }
                        case FEDERATED: {
                            ((DataOp)ae).setOutputParams(ae.getDim1(), ae.getDim2(), -1L, ae.getUpdateType(), -1);
                            break;
                        }
                        default: {
                            throw new LanguageException("Unrecognized file format: " + ((DataOp)ae).getFileFormat());
                        }
                    }
                }
                output.add(ae);
            }
            if (current instanceof PrintStatement) {
                DataIdentifier target3 = DMLTranslator.createTarget();
                target3.setDataType(Types.DataType.SCALAR);
                target3.setValueType(Types.ValueType.STRING);
                target3.setParseInfo(current);
                PrintStatement ps = (PrintStatement)current;
                PrintStatement.PRINTTYPE ptype = ps.getType();
                try {
                    Hop ae2;
                    Expression source;
                    Types.OpOp1 op;
                    if (ptype == PrintStatement.PRINTTYPE.PRINT) {
                        op = Types.OpOp1.PRINT;
                        source = ps.getExpressions().get(0);
                        ae2 = this.processExpression(source, target3, ids);
                        UnaryOp printHop = new UnaryOp(target3.getName(), target3.getDataType(), target3.getValueType(), op, ae2);
                        printHop.setParseInfo(current);
                        output.add(printHop);
                    } else if (ptype == PrintStatement.PRINTTYPE.ASSERT) {
                        op = Types.OpOp1.ASSERT;
                        source = ps.getExpressions().get(0);
                        ae2 = this.processExpression(source, target3, ids);
                        UnaryOp printHop = new UnaryOp(target3.getName(), target3.getDataType(), target3.getValueType(), op, ae2);
                        printHop.setParseInfo(current);
                        output.add(printHop);
                    } else if (ptype == PrintStatement.PRINTTYPE.STOP) {
                        op = Types.OpOp1.STOP;
                        source = ps.getExpressions().get(0);
                        ae2 = this.processExpression(source, target3, ids);
                        UnaryOp stopHop = new UnaryOp(target3.getName(), target3.getDataType(), target3.getValueType(), op, ae2);
                        stopHop.setParseInfo(current);
                        output.add(stopHop);
                        sb.setSplitDag(true);
                    } else if (ptype == PrintStatement.PRINTTYPE.PRINTF) {
                        List<Expression> expressions = ps.getExpressions();
                        Hop[] inHops = new Hop[expressions.size()];
                        for (int j = 0; j < expressions.size(); ++j) {
                            Hop inHop;
                            inHops[j] = inHop = this.processExpression(expressions.get(j), target3, ids);
                        }
                        target3.setValueType(Types.ValueType.STRING);
                        NaryOp printfHop = new NaryOp(target3.getName(), target3.getDataType(), target3.getValueType(), Types.OpOpN.PRINTF, inHops);
                        output.add(printfHop);
                    }
                }
                catch (HopsException e2) {
                    throw new LanguageException(e2);
                }
            }
            if (current instanceof AssignmentStatement) {
                as = (AssignmentStatement)current;
                DataIdentifier target4 = as.getTarget();
                Expression source = as.getSource();
                if (!(source instanceof FunctionCallIdentifier)) {
                    Integer statementId;
                    DataIdentifier accum;
                    if (!(target4 instanceof IndexedIdentifier)) {
                        BuiltinFunctionExpression BuiltinSource;
                        ae = this.processExpression(source, target4, ids);
                        if (as.isAccumulator()) {
                            accum = DMLTranslator.getAccumulatorData(liveIn, target4.getName());
                            ae = HopRewriteUtils.createBinary(ids.get(target4.getName()), ae, Types.OpOp2.PLUS);
                            target4.setProperties(accum.getOutput());
                        } else {
                            target4.setProperties(source.getOutput());
                        }
                        if (source instanceof BuiltinFunctionExpression && (BuiltinSource = (BuiltinFunctionExpression)source).getOpCode() == Builtins.TIME) {
                            sb.setSplitDag(true);
                        }
                        ids.put(target4.getName(), ae);
                        Integer statementId2 = (Integer)liveOutToTemp.get(target4.getName());
                        if (statementId2 == null || statementId2 != i) continue;
                        DataOp transientwrite = new DataOp(target4.getName(), target4.getDataType(), target4.getValueType(), ae, Types.OpOpData.TRANSIENTWRITE, null);
                        transientwrite.setOutputParams(ae.getDim1(), ae.getDim2(), ae.getNnz(), ae.getUpdateType(), ae.getBlocksize());
                        transientwrite.setParseInfo(target4);
                        updatedLiveOut.addVariable(target4.getName(), target4);
                        output.add(transientwrite);
                        continue;
                    }
                    ae = this.processLeftIndexedExpression(source, (IndexedIdentifier)target4, ids);
                    if (as.isAccumulator()) {
                        accum = DMLTranslator.getAccumulatorData(liveIn, target4.getName());
                        Hop rix = this.processIndexingExpression((IndexedIdentifier)target4, null, ids);
                        Hop rhs = this.processExpression(source, null, ids);
                        BinaryOp binary = HopRewriteUtils.createBinary(rix, rhs, Types.OpOp2.PLUS);
                        HopRewriteUtils.replaceChildReference(ae, ae.getInput(1), binary);
                        target4.setProperties(accum.getOutput());
                    }
                    ids.put(target4.getName(), ae);
                    long origDim1 = ((IndexedIdentifier)target4).getOrigDim1();
                    long origDim2 = ((IndexedIdentifier)target4).getOrigDim2();
                    target4.setProperties(source.getOutput());
                    ((IndexedIdentifier)target4).setOriginalDimensions(origDim1, origDim2);
                    if (target4.getDataType() != Types.DataType.MATRIX) {
                        target4.setDataType(Types.DataType.MATRIX);
                        target4.setValueType(Types.ValueType.FP64);
                        target4.setBlocksize(ConfigurationManager.getBlocksize());
                    }
                    if ((statementId = (Integer)liveOutToTemp.get(target4.getName())) == null || statementId != i) continue;
                    DataOp transientwrite = new DataOp(target4.getName(), target4.getDataType(), target4.getValueType(), ae, Types.OpOpData.TRANSIENTWRITE, null);
                    transientwrite.setOutputParams(origDim1, origDim2, ae.getNnz(), ae.getUpdateType(), ae.getBlocksize());
                    transientwrite.setParseInfo(target4);
                    updatedLiveOut.addVariable(target4.getName(), target4);
                    output.add(transientwrite);
                    continue;
                }
                FunctionCallIdentifier fci = (FunctionCallIdentifier)source;
                FunctionStatementBlock fsb = this._dmlProg.getFunctionStatementBlock(fci.getNamespace(), fci.getName());
                if (fsb == null) {
                    throw new LanguageException(source.printErrorLocation() + "function " + fci.getName() + " is undefined in namespace " + fci.getNamespace());
                }
                FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                String fkey = DMLProgram.constructFunctionKey(fci.getNamespace(), fci.getName());
                if (target4 instanceof IndexedIdentifier) {
                    throw new LanguageException("Unsupported function call to '" + fkey + "' in left indexing expression. Please, assign the function output to a variable.");
                }
                List<String> inputNames = new ArrayList<String>(fci.getParamExprs().stream().map(e -> e.getName()).collect(Collectors.toList()));
                ArrayList<Hop> finputs = new ArrayList<Hop>(fci.getParamExprs().stream().map(e -> this.processExpression(e.getExpr(), null, ids)).collect(Collectors.toList()));
                this.appendDefaultArguments(fstmt, inputNames, finputs, ids);
                if (inputNames.stream().allMatch(n -> n == null)) {
                    inputNames = fstmt._inputParams.stream().map(d -> d.getName()).collect(Collectors.toList());
                }
                String[] inputNames2 = inputNames.toArray(new String[0]);
                FunctionOp.FunctionType ftype = fsb.getFunctionOpType();
                FunctionOp fcall2 = target4 == null ? new FunctionOp(ftype, fci.getNamespace(), fci.getName(), inputNames2, finputs, new String[0], false) : new FunctionOp(ftype, fci.getNamespace(), fci.getName(), inputNames2, finputs, new String[]{target4.getName()}, false);
                fcall2.setParseInfo(fci);
                output.add(fcall2);
                continue;
            }
            if (!(current instanceof MultiAssignmentStatement)) continue;
            mas = (MultiAssignmentStatement)current;
            Expression source = mas.getSource();
            if (source instanceof FunctionCallIdentifier) {
                FunctionCallIdentifier fci = (FunctionCallIdentifier)source;
                FunctionStatementBlock fsb = this._dmlProg.getFunctionStatementBlock(fci.getNamespace(), fci.getName());
                if (fsb == null) {
                    throw new LanguageException(source.printErrorLocation() + "function " + fci.getName() + " is undefined in namespace " + fci.getNamespace());
                }
                FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                List<String> inputNames = new ArrayList<String>(fci.getParamExprs().stream().map(e -> e.getName()).collect(Collectors.toList()));
                ArrayList<Hop> finputs = new ArrayList<Hop>(fci.getParamExprs().stream().map(e -> this.processExpression(e.getExpr(), null, ids)).collect(Collectors.toList()));
                if (inputNames.stream().allMatch(n -> n == null)) {
                    inputNames = fstmt._inputParams.stream().map(d -> d.getName()).collect(Collectors.toList());
                }
                this.appendDefaultArguments(fstmt, inputNames, finputs, ids);
                String[] foutputs = (String[])mas.getTargetList().stream().map(d -> d.getName()).toArray(String[]::new);
                FunctionOp.FunctionType ftype = fsb.getFunctionOpType();
                FunctionOp fcall3 = new FunctionOp(ftype, fci.getNamespace(), fci.getName(), inputNames.toArray(new String[0]), finputs, foutputs, false);
                fcall3.setParseInfo(fci);
                output.add(fcall3);
                continue;
            }
            if (source instanceof BuiltinFunctionExpression && ((BuiltinFunctionExpression)source).multipleReturns()) {
                fcall = this.processMultipleReturnBuiltinFunctionExpression((BuiltinFunctionExpression)source, mas.getTargetList(), ids);
                output.add(fcall);
                continue;
            }
            if (source instanceof ParameterizedBuiltinFunctionExpression && ((ParameterizedBuiltinFunctionExpression)source).multipleReturns()) {
                fcall = this.processMultipleReturnParameterizedBuiltinFunctionExpression((ParameterizedBuiltinFunctionExpression)source, mas.getTargetList(), ids);
                output.add(fcall);
                continue;
            }
            throw new LanguageException("Class \"" + source.getClass() + "\" is not supported in Multiple Assignment statements");
        }
        sb.updateLiveVariablesOut(updatedLiveOut);
        sb.setHops(output);
    }

    private static DataIdentifier getAccumulatorData(VariableSet liveIn, String varname) {
        DataIdentifier accum = liveIn.getVariable(varname);
        if (accum == null) {
            throw new LanguageException("Invalid accumulator assignment to non-existing variable " + varname + ".");
        }
        return accum;
    }

    private void appendDefaultArguments(FunctionStatement fstmt, List<String> inputNames, List<Hop> inputs, HashMap<String, Hop> ids) {
        if (fstmt.getInputParams().size() == inputs.size()) {
            return;
        }
        HashSet<String> probeNames = new HashSet<String>(inputNames);
        for (DataIdentifier di : fstmt.getInputParams()) {
            if (probeNames.contains(di.getName())) continue;
            Expression exp = fstmt.getInputDefault(di.getName());
            if (exp == null) {
                throw new LanguageException("Missing default expression for unspecified function argument '" + di.getName() + "' in call to function '" + fstmt.getName() + "'.");
            }
            inputNames.add(di.getName());
            inputs.add(this.processExpression(exp, null, ids));
        }
    }

    public void constructHopsForIfControlBlock(IfStatementBlock sb) {
        IfStatement ifsb = (IfStatement)sb.getStatement(0);
        ArrayList<StatementBlock> ifBody = ifsb.getIfBody();
        ArrayList<StatementBlock> elseBody = ifsb.getElseBody();
        this.constructHopsForConditionalPredicate(sb);
        for (StatementBlock current : ifBody) {
            this.constructHops(current);
        }
        for (StatementBlock current : elseBody) {
            this.constructHops(current);
        }
    }

    public void constructHopsForForControlBlock(ForStatementBlock sb) {
        ForStatement fs = (ForStatement)sb.getStatement(0);
        ArrayList<StatementBlock> body = fs.getBody();
        this.constructHopsForIterablePredicate(sb);
        for (StatementBlock current : body) {
            this.constructHops(current);
        }
    }

    public void constructHopsForFunctionControlBlock(FunctionStatementBlock fsb) {
        ArrayList<StatementBlock> body = ((FunctionStatement)fsb.getStatement(0)).getBody();
        for (StatementBlock current : body) {
            this.constructHops(current);
        }
    }

    public void constructHopsForWhileControlBlock(WhileStatementBlock sb) {
        ArrayList<StatementBlock> body = ((WhileStatement)sb.getStatement(0)).getBody();
        this.constructHopsForConditionalPredicate(sb);
        for (StatementBlock current : body) {
            this.constructHops(current);
        }
    }

    public void constructHopsForConditionalPredicate(StatementBlock passedSB) {
        Statement ws;
        HashMap<String, Hop> _ids = new HashMap<String, Hop>();
        ConditionalPredicate cp = null;
        if (passedSB instanceof WhileStatementBlock) {
            ws = (WhileStatement)((WhileStatementBlock)passedSB).getStatement(0);
            cp = ((WhileStatement)ws).getConditionalPredicate();
        } else if (passedSB instanceof IfStatementBlock) {
            ws = (IfStatement)((IfStatementBlock)passedSB).getStatement(0);
            cp = ((IfStatement)ws).getConditionalPredicate();
        } else {
            throw new ParseException("ConditionalPredicate expected only for while or if statements.");
        }
        VariableSet varsRead = cp.variablesRead();
        for (String varName : varsRead.getVariables().keySet()) {
            DataIdentifier var = passedSB.liveIn().getVariables().get(varName);
            DataOp read = null;
            if (var == null) {
                throw new ParseException("variable " + varName + " not live variable for conditional predicate");
            }
            long actualDim1 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim1() : var.getDim1();
            long actualDim2 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim2() : var.getDim2();
            read = new DataOp(var.getName(), var.getDataType(), var.getValueType(), Types.OpOpData.TRANSIENTREAD, null, actualDim1, actualDim2, var.getNnz(), var.getBlocksize());
            read.setParseInfo(var);
            _ids.put(varName, read);
        }
        DataIdentifier target = new DataIdentifier(Expression.getTempName());
        target.setDataType(Types.DataType.SCALAR);
        target.setValueType(Types.ValueType.BOOLEAN);
        target.setParseInfo(passedSB);
        Hop predicateHops = null;
        Expression predicate = cp.getPredicate();
        if (predicate instanceof RelationalExpression) {
            predicateHops = this.processRelationalExpression((RelationalExpression)cp.getPredicate(), target, _ids);
        } else if (predicate instanceof BooleanExpression) {
            predicateHops = this.processBooleanExpression((BooleanExpression)cp.getPredicate(), target, _ids);
        } else if (predicate instanceof DataIdentifier) {
            predicateHops = this.processExpression(cp.getPredicate(), null, _ids);
        } else if (predicate instanceof ConstIdentifier) {
            if (predicate instanceof IntIdentifier && ((IntIdentifier)predicate).getValue() == 0L || predicate instanceof DoubleIdentifier && ((DoubleIdentifier)predicate).getValue() == 0.0) {
                cp.setPredicate(new BooleanIdentifier(false, predicate));
            } else if (predicate instanceof IntIdentifier && ((IntIdentifier)predicate).getValue() == 1L || predicate instanceof DoubleIdentifier && ((DoubleIdentifier)predicate).getValue() == 1.0) {
                cp.setPredicate(new BooleanIdentifier(true, predicate));
            } else if (predicate instanceof IntIdentifier || predicate instanceof DoubleIdentifier) {
                cp.setPredicate(new BooleanIdentifier(true, predicate));
                LOG.warn((Object)(predicate.printWarningLocation() + "Numerical value '" + predicate.toString() + "' (!= 0/1) is converted to boolean TRUE by DML"));
            } else if (predicate instanceof StringIdentifier) {
                throw new ParseException(predicate.printErrorLocation() + "String value '" + predicate.toString() + "' is not allowed for iterable predicate");
            }
            predicateHops = this.processExpression(cp.getPredicate(), null, _ids);
        }
        predicateHops = HopRewriteUtils.createDataOp("__pred", predicateHops, Types.OpOpData.TRANSIENTWRITE);
        if (passedSB instanceof WhileStatementBlock) {
            ((WhileStatementBlock)passedSB).setPredicateHops(predicateHops);
        } else if (passedSB instanceof IfStatementBlock) {
            ((IfStatementBlock)passedSB).setPredicateHops(predicateHops);
        }
    }

    public void constructHopsForIterablePredicate(ForStatementBlock fsb) {
        HashMap<String, Hop> _ids = new HashMap<String, Hop>();
        ForStatement fs = (ForStatement)fsb.getStatement(0);
        IterablePredicate ip = fs.getIterablePredicate();
        for (int i = 0; i < 3; ++i) {
            Hop predicateHops;
            VariableSet varsRead;
            Expression expr = i == 0 ? ip.getFromExpr() : (i == 1 ? ip.getToExpr() : (ip.getIncrementExpr() != null ? ip.getIncrementExpr() : null));
            VariableSet variableSet = varsRead = expr != null ? expr.variablesRead() : null;
            if (varsRead != null) {
                for (String varName : varsRead.getVariables().keySet()) {
                    DataIdentifier var = fsb.liveIn().getVariable(varName);
                    DataOp read = null;
                    if (var == null) {
                        throw new ParseException("variable '" + varName + "' is not available for iterable predicate");
                    }
                    long actualDim1 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim1() : var.getDim1();
                    long actualDim2 = var instanceof IndexedIdentifier ? ((IndexedIdentifier)var).getOrigDim2() : var.getDim2();
                    read = new DataOp(var.getName(), var.getDataType(), var.getValueType(), Types.OpOpData.TRANSIENTREAD, null, actualDim1, actualDim2, var.getNnz(), var.getBlocksize());
                    read.setParseInfo(var);
                    _ids.put(varName, read);
                }
            }
            if ((predicateHops = this.processTempIntExpression(expr, _ids)) != null) {
                predicateHops = HopRewriteUtils.createDataOp("__pred", predicateHops, Types.OpOpData.TRANSIENTWRITE);
            }
            if (i == 0) {
                fsb.setFromHops(predicateHops);
                continue;
            }
            if (i == 1) {
                fsb.setToHops(predicateHops);
                continue;
            }
            if (ip.getIncrementExpr() == null) continue;
            fsb.setIncrementHops(predicateHops);
        }
    }

    private Hop processExpression(Expression source, DataIdentifier target, HashMap<String, Hop> hops) {
        try {
            if (source instanceof BinaryExpression) {
                return this.processBinaryExpression((BinaryExpression)source, target, hops);
            }
            if (source instanceof RelationalExpression) {
                return this.processRelationalExpression((RelationalExpression)source, target, hops);
            }
            if (source instanceof BooleanExpression) {
                return this.processBooleanExpression((BooleanExpression)source, target, hops);
            }
            if (source instanceof BuiltinFunctionExpression) {
                return this.processBuiltinFunctionExpression((BuiltinFunctionExpression)source, target, hops);
            }
            if (source instanceof ParameterizedBuiltinFunctionExpression) {
                return this.processParameterizedBuiltinFunctionExpression((ParameterizedBuiltinFunctionExpression)source, target, hops);
            }
            if (source instanceof DataExpression) {
                Hop ae = this.processDataExpression((DataExpression)source, target, hops);
                if (ae instanceof DataOp && ((DataOp)ae).getOp() != Types.OpOpData.SQLREAD && ((DataOp)ae).getOp() != Types.OpOpData.FEDERATED) {
                    String formatName = ((DataExpression)source).getVarParam("format").toString();
                    ((DataOp)ae).setFileFormat(Expression.convertFormatType(formatName));
                }
                return ae;
            }
            if (source instanceof IndexedIdentifier) {
                return this.processIndexingExpression((IndexedIdentifier)source, target, hops);
            }
            if (source instanceof IntIdentifier) {
                IntIdentifier sourceInt = (IntIdentifier)source;
                LiteralOp litop = new LiteralOp(sourceInt.getValue());
                litop.setParseInfo(sourceInt);
                this.setIdentifierParams(litop, sourceInt);
                return litop;
            }
            if (source instanceof DoubleIdentifier) {
                DoubleIdentifier sourceDouble = (DoubleIdentifier)source;
                LiteralOp litop = new LiteralOp(sourceDouble.getValue());
                litop.setParseInfo(sourceDouble);
                this.setIdentifierParams(litop, sourceDouble);
                return litop;
            }
            if (source instanceof BooleanIdentifier) {
                BooleanIdentifier sourceBoolean = (BooleanIdentifier)source;
                LiteralOp litop = new LiteralOp(sourceBoolean.getValue());
                litop.setParseInfo(sourceBoolean);
                this.setIdentifierParams(litop, sourceBoolean);
                return litop;
            }
            if (source instanceof StringIdentifier) {
                StringIdentifier sourceString = (StringIdentifier)source;
                LiteralOp litop = new LiteralOp(sourceString.getValue());
                litop.setParseInfo(sourceString);
                this.setIdentifierParams(litop, sourceString);
                return litop;
            }
            if (source instanceof DataIdentifier) {
                return hops.get(((DataIdentifier)source).getName());
            }
            if (source instanceof ExpressionList) {
                ExpressionList sourceList = (ExpressionList)source;
                ArrayList<Expression> expressions = sourceList.getValue();
                Hop[] listHops = new Hop[expressions.size()];
                int idx = 0;
                for (Expression ex : expressions) {
                    listHops[idx++] = this.processExpression(ex, null, hops);
                }
                NaryOp currBuiltinOp = HopRewriteUtils.createNary(Types.OpOpN.LIST, listHops);
                return currBuiltinOp;
            }
            throw new ParseException("Unhandled instance of source type: " + source.getClass());
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException("A Parsing exception occurred", e);
        }
    }

    private static DataIdentifier createTarget(Expression source) {
        Identifier id = source.getOutput();
        if (id instanceof DataIdentifier && !(id instanceof DataExpression)) {
            return (DataIdentifier)id;
        }
        DataIdentifier target = new DataIdentifier(Expression.getTempName());
        target.setProperties(id);
        return target;
    }

    private static DataIdentifier createTarget() {
        return new DataIdentifier(Expression.getTempName());
    }

    private Hop processTempIntExpression(Expression source, HashMap<String, Hop> hops) {
        if (source == null) {
            return null;
        }
        DataIdentifier tmpOut = DMLTranslator.createTarget();
        tmpOut.setDataType(Types.DataType.SCALAR);
        tmpOut.setValueType(Types.ValueType.INT64);
        source.setOutput(tmpOut);
        return this.processExpression(source, tmpOut, hops);
    }

    private Hop processLeftIndexedExpression(Expression source, IndexedIdentifier target, HashMap<String, Hop> hops) {
        Hop[] ixRange = this.getIndexingBounds(target, hops, true);
        Hop sourceOp = this.processExpression(source, target, hops);
        Hop targetOp = hops.get(target.getName());
        if (targetOp == null) {
            throw new ParseException(target.printErrorLocation() + " must define matrix " + target.getName() + " before indexing operations are allowed ");
        }
        if (sourceOp.getDataType().isMatrix() && source.getOutput().getDataType().isScalar()) {
            sourceOp.setDataType(Types.DataType.SCALAR);
        }
        LeftIndexingOp leftIndexOp = new LeftIndexingOp(target.getName(), target.getDataType(), Types.ValueType.FP64, targetOp, sourceOp, ixRange[0], ixRange[1], ixRange[2], ixRange[3], target.getRowLowerEqualsUpper(), target.getColLowerEqualsUpper());
        this.setIdentifierParams(leftIndexOp, target);
        leftIndexOp.setParseInfo(target);
        leftIndexOp.setDim1(target.getOrigDim1());
        leftIndexOp.setDim2(target.getOrigDim2());
        return leftIndexOp;
    }

    private Hop processIndexingExpression(IndexedIdentifier source, DataIdentifier target, HashMap<String, Hop> hops) {
        Hop[] ixRange = this.getIndexingBounds(source, hops, false);
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        target.setNnz(-1L);
        IndexingOp indexOp = new IndexingOp(target.getName(), target.getDataType(), target.getValueType(), hops.get(source.getName()), ixRange[0], ixRange[1], ixRange[2], ixRange[3], source.getRowLowerEqualsUpper(), source.getColLowerEqualsUpper());
        indexOp.setParseInfo(target);
        this.setIdentifierParams(indexOp, target);
        return indexOp;
    }

    private Hop[] getIndexingBounds(IndexedIdentifier ix, HashMap<String, Hop> hops, boolean lix) {
        LiteralOp rowLowerHops = ix.getRowLowerBound() != null ? this.processExpression(ix.getRowLowerBound(), null, hops) : new LiteralOp(1L);
        LiteralOp colLowerHops = ix.getColLowerBound() != null ? this.processExpression(ix.getColLowerBound(), null, hops) : new LiteralOp(1L);
        Hop rowUpperHops = null;
        Hop colUpperHops = null;
        if (ix.getRowUpperBound() != null) {
            rowUpperHops = this.processExpression(ix.getRowUpperBound(), null, hops);
        } else {
            rowUpperHops = (lix ? ix.getDim1() : ix.getOrigDim1()) != -1L ? new LiteralOp(ix.getOrigDim1()) : new UnaryOp(ix.getName(), Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NROW, hops.get(ix.getName()));
            rowUpperHops.setParseInfo(ix);
        }
        if (ix.getColUpperBound() != null) {
            colUpperHops = this.processExpression(ix.getColUpperBound(), null, hops);
        } else {
            colUpperHops = (lix ? ix.getDim2() : ix.getOrigDim2()) != -1L ? new LiteralOp(ix.getOrigDim2()) : new UnaryOp(ix.getName(), Types.DataType.SCALAR, Types.ValueType.INT64, Types.OpOp1.NCOL, hops.get(ix.getName()));
            colUpperHops.setParseInfo(ix);
        }
        return new Hop[]{rowLowerHops, rowUpperHops, colLowerHops, colUpperHops};
    }

    private Hop processBinaryExpression(BinaryExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        Hop left = this.processExpression(source.getLeft(), null, hops);
        Hop right = this.processExpression(source.getRight(), null, hops);
        if (left == null || right == null) {
            throw new ParseException("Missing input in binary expressions (" + source.toString() + "): " + (left == null ? source.getLeft() : source.getRight()) + ", line=" + source.getBeginLine());
        }
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        target.setValueType(source.getOutput().getValueType());
        MultiThreadedHop currBop = null;
        switch (source.getOpCode()) {
            case PLUS: 
            case MINUS: 
            case MULT: 
            case DIV: 
            case MODULUS: 
            case POW: 
            case INTDIV: {
                currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp2.valueOf(source.getOpCode().name()), left, right);
                break;
            }
            case MATMULT: {
                currBop = new AggBinaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp2.MULT, Types.AggOp.SUM, left, right);
                break;
            }
            default: {
                throw new ParseException("Unsupported parsing of binary expression: " + source.getOpCode());
            }
        }
        this.setIdentifierParams(currBop, source.getOutput());
        currBop.setParseInfo(source);
        return currBop;
    }

    private Hop processRelationalExpression(RelationalExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        Hop left = this.processExpression(source.getLeft(), null, hops);
        Hop right = this.processExpression(source.getRight(), null, hops);
        BinaryOp currBop = null;
        if (target == null) {
            target = DMLTranslator.createTarget(source);
            if (left.getDataType() == Types.DataType.MATRIX || right.getDataType() == Types.DataType.MATRIX) {
                target.setDataType(Types.DataType.MATRIX);
                target.setValueType(Types.ValueType.FP64);
            } else if (left.getDataType() == Types.DataType.FRAME || right.getDataType() == Types.DataType.FRAME) {
                target.setDataType(Types.DataType.FRAME);
                target.setValueType(Types.ValueType.BOOLEAN);
            } else {
                target.setDataType(Types.DataType.SCALAR);
                target.setValueType(Types.ValueType.BOOLEAN);
            }
        }
        Types.OpOp2 op = null;
        if (source.getOpCode() == Expression.RelationalOp.LESS) {
            op = Types.OpOp2.LESS;
        } else if (source.getOpCode() == Expression.RelationalOp.LESSEQUAL) {
            op = Types.OpOp2.LESSEQUAL;
        } else if (source.getOpCode() == Expression.RelationalOp.GREATER) {
            op = Types.OpOp2.GREATER;
        } else if (source.getOpCode() == Expression.RelationalOp.GREATEREQUAL) {
            op = Types.OpOp2.GREATEREQUAL;
        } else if (source.getOpCode() == Expression.RelationalOp.EQUAL) {
            op = Types.OpOp2.EQUAL;
        } else if (source.getOpCode() == Expression.RelationalOp.NOTEQUAL) {
            op = Types.OpOp2.NOTEQUAL;
        }
        currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), op, left, right);
        currBop.setParseInfo(source);
        return currBop;
    }

    private Hop processBooleanExpression(BooleanExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        boolean constLeft = source.getLeft().getOutput() instanceof ConstIdentifier;
        boolean constRight = false;
        if (source.getRight() != null) {
            constRight = source.getRight().getOutput() instanceof ConstIdentifier;
        }
        if (constLeft || constRight) {
            throw new RuntimeException(source.printErrorLocation() + "Boolean expression with constant unsupported");
        }
        Hop left = this.processExpression(source.getLeft(), null, hops);
        Hop right = null;
        if (source.getRight() != null) {
            right = this.processExpression(source.getRight(), null, hops);
        }
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        if (target.getDataType().isScalar()) {
            target.setValueType(Types.ValueType.BOOLEAN);
        }
        if (source.getRight() == null) {
            UnaryOp currUop = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp1.NOT, left);
            currUop.setParseInfo(source);
            return currUop;
        }
        BinaryOp currBop = null;
        Types.OpOp2 op = null;
        if (source.getOpCode() == Expression.BooleanOp.LOGICALAND) {
            op = Types.OpOp2.AND;
        } else if (source.getOpCode() == Expression.BooleanOp.LOGICALOR) {
            op = Types.OpOp2.OR;
        } else {
            throw new RuntimeException(source.printErrorLocation() + "Unknown boolean operation " + source.getOpCode());
        }
        currBop = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), op, left, right);
        currBop.setParseInfo(source);
        return currBop;
    }

    private static Hop constructDfHop(String name, Types.DataType dt, Types.ValueType vt, Builtins op, LinkedHashMap<String, Hop> paramHops) {
        LiteralOp distLop = null;
        switch (op) {
            case QNORM: 
            case PNORM: {
                distLop = new LiteralOp("normal");
                break;
            }
            case QT: 
            case PT: {
                distLop = new LiteralOp("t");
                break;
            }
            case QF: 
            case PF: {
                distLop = new LiteralOp("f");
                break;
            }
            case QCHISQ: 
            case PCHISQ: {
                distLop = new LiteralOp("chisq");
                break;
            }
            case QEXP: 
            case PEXP: {
                distLop = new LiteralOp("exp");
                break;
            }
            case CDF: 
            case INVCDF: {
                break;
            }
            default: {
                throw new HopsException("Invalid operation: " + op);
            }
        }
        if (distLop != null) {
            paramHops.put("dist", distLop);
        }
        return new ParameterizedBuiltinOp(name, dt, vt, ParameterizedBuiltinFunctionExpression.pbHopMap.get((Object)op), paramHops);
    }

    private Hop processMultipleReturnParameterizedBuiltinFunctionExpression(ParameterizedBuiltinFunctionExpression source, ArrayList<DataIdentifier> targetList, HashMap<String, Hop> hops) {
        FunctionOp.FunctionType ftype = FunctionOp.FunctionType.MULTIRETURN_BUILTIN;
        String nameSpace = "_internal";
        ArrayList<Hop> outputs = new ArrayList<Hop>();
        FunctionOp currBuiltinOp = null;
        switch (source.getOpCode()) {
            case TRANSFORMENCODE: {
                ArrayList<Hop> inputs = new ArrayList<Hop>();
                inputs.add(this.processExpression(source.getVarParam("target"), null, hops));
                inputs.add(this.processExpression(source.getVarParam("spec"), null, hops));
                String[] outputNames = new String[targetList.size()];
                outputNames[0] = targetList.get(0).getName();
                outputNames[1] = targetList.get(1).getName();
                outputs.add(new DataOp(outputNames[0], Types.DataType.MATRIX, Types.ValueType.FP64, (Hop)inputs.get(0), Types.OpOpData.FUNCTIONOUTPUT, ((Hop)inputs.get(0)).getFilename()));
                outputs.add(new DataOp(outputNames[1], Types.DataType.FRAME, Types.ValueType.STRING, (Hop)inputs.get(0), Types.OpOpData.FUNCTIONOUTPUT, ((Hop)inputs.get(0)).getFilename()));
                currBuiltinOp = new FunctionOp(ftype, nameSpace, source.getOpCode().toString(), null, inputs, outputNames, outputs);
                break;
            }
            default: {
                throw new ParseException("Invaid Opcode in DMLTranslator:processMultipleReturnParameterizedBuiltinFunctionExpression(): " + source.getOpCode());
            }
        }
        for (int i = 0; i < source.getOutputs().length; ++i) {
            this.setIdentifierParams(outputs.get(i), source.getOutputs()[i]);
            outputs.get(i).setParseInfo(source);
        }
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    private Hop processParameterizedBuiltinFunctionExpression(ParameterizedBuiltinFunctionExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        LinkedHashMap<String, Hop> paramHops = new LinkedHashMap<String, Hop>();
        Hop pHop = null;
        for (String paramName : source.getVarParams().keySet()) {
            pHop = this.processExpression(source.getVarParam(paramName), null, hops);
            paramHops.put(paramName, pHop);
        }
        Hop currBuiltinOp = null;
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        switch (source.getOpCode()) {
            case QNORM: 
            case PNORM: 
            case QT: 
            case PT: 
            case QF: 
            case PF: 
            case QCHISQ: 
            case PCHISQ: 
            case QEXP: 
            case PEXP: 
            case CDF: 
            case INVCDF: {
                currBuiltinOp = DMLTranslator.constructDfHop(target.getName(), target.getDataType(), target.getValueType(), source.getOpCode(), paramHops);
                break;
            }
            case CONTAINS: 
            case GROUPEDAGG: 
            case RMEMPTY: 
            case REPLACE: 
            case LOWER_TRI: 
            case UPPER_TRI: 
            case TOKENIZE: 
            case TRANSFORMAPPLY: 
            case TRANSFORMDECODE: 
            case TRANSFORMCOLMAP: 
            case TRANSFORMMETA: 
            case PARAMSERV: 
            case AUTODIFF: {
                currBuiltinOp = new ParameterizedBuiltinOp(target.getName(), target.getDataType(), target.getValueType(), Types.ParamBuiltinOp.valueOf(source.getOpCode().name()), paramHops);
                break;
            }
            case ORDER: {
                ArrayList<Hop> inputs = new ArrayList<Hop>();
                inputs.add((Hop)paramHops.get("target"));
                inputs.add(paramHops.get("by"));
                inputs.add(paramHops.get("decreasing"));
                inputs.add(paramHops.get("index.return"));
                currBuiltinOp = new ReorgOp(target.getName(), target.getDataType(), target.getValueType(), Types.ReOrgOp.SORT, inputs);
                break;
            }
            case TOSTRING: {
                currBuiltinOp = !((Hop)paramHops.get("target")).getDataType().isScalar() ? new ParameterizedBuiltinOp(target.getName(), target.getDataType(), target.getValueType(), Types.ParamBuiltinOp.TOSTRING, paramHops) : HopRewriteUtils.createBinary(paramHops.get("target"), (Hop)new LiteralOp(""), Types.OpOp2.PLUS);
                break;
            }
            case LISTNV: {
                currBuiltinOp = new ParameterizedBuiltinOp(target.getName(), target.getDataType(), target.getValueType(), Types.ParamBuiltinOp.LIST, paramHops);
                break;
            }
            case COUNT_DISTINCT: 
            case COUNT_DISTINCT_APPROX: {
                Types.Direction dir = Types.Direction.RowCol;
                Types.DataType dataType = Types.DataType.SCALAR;
                LiteralOp dirOp = (LiteralOp)paramHops.get("dir");
                if (dirOp != null) {
                    String dirString = dirOp.getStringValue().toUpperCase();
                    if (dirString.equals(Types.Direction.RowCol.toString())) {
                        dir = Types.Direction.RowCol;
                        dataType = Types.DataType.SCALAR;
                    } else if (dirString.equals(Types.Direction.Row.toString())) {
                        dir = Types.Direction.Row;
                        dataType = Types.DataType.MATRIX;
                    } else if (dirString.equals(Types.Direction.Col.toString())) {
                        dir = Types.Direction.Col;
                        dataType = Types.DataType.MATRIX;
                    }
                }
                currBuiltinOp = new AggUnaryOp(target.getName(), dataType, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name()), dir, paramHops.get("data"));
                break;
            }
            case COUNT_DISTINCT_APPROX_ROW: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name()), Types.Direction.Row, paramHops.get("data"));
                break;
            }
            case COUNT_DISTINCT_APPROX_COL: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name()), Types.Direction.Col, paramHops.get("data"));
                break;
            }
            case UNIQUE: {
                Types.Direction dir = Types.Direction.RowCol;
                Types.DataType dataType = Types.DataType.MATRIX;
                LiteralOp dirOp = (LiteralOp)paramHops.get("dir");
                if (dirOp != null) {
                    String dirString = dirOp.getStringValue().toUpperCase();
                    if (dirString.equals(Types.Direction.RowCol.toString())) {
                        dir = Types.Direction.RowCol;
                    } else if (dirString.equals(Types.Direction.Row.toString())) {
                        dir = Types.Direction.Row;
                    } else if (dirString.equals(Types.Direction.Col.toString())) {
                        dir = Types.Direction.Col;
                    }
                }
                currBuiltinOp = new AggUnaryOp(target.getName(), dataType, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name()), dir, paramHops.get("data"));
                break;
            }
            default: {
                throw new ParseException(source.printErrorLocation() + "processParameterizedBuiltinFunctionExpression() -- Unknown operation: " + source.getOpCode());
            }
        }
        this.setIdentifierParams(currBuiltinOp, source.getOutput());
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    private Hop processDataExpression(DataExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        HashMap<String, Hop> paramHops = new HashMap<String, Hop>();
        Hop pHop = null;
        for (String paramName : source.getVarParams().keySet()) {
            pHop = this.processExpression(source.getVarParam(paramName), null, hops);
            paramHops.put(paramName, pHop);
        }
        Hop currBuiltinOp = null;
        if (target == null) {
            target = DMLTranslator.createTarget(source);
        }
        switch (source.getOpCode()) {
            case READ: {
                currBuiltinOp = new DataOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOpData.PERSISTENTREAD, paramHops);
                ((DataOp)currBuiltinOp).setFileName(((StringIdentifier)source.getVarParam("iofilename")).getValue());
                break;
            }
            case WRITE: {
                currBuiltinOp = new DataOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOpData.PERSISTENTWRITE, hops.get(target.getName()), paramHops);
                break;
            }
            case RAND: {
                Types.OpOpDG method = ((Hop)paramHops.get("min")).getValueType() == Types.ValueType.STRING && target.getDataType() == Types.DataType.MATRIX ? Types.OpOpDG.SINIT : Types.OpOpDG.RAND;
                currBuiltinOp = new DataGenOp(method, target, paramHops);
                break;
            }
            case FRAME: {
                Types.OpOpDG method = Types.OpOpDG.FRAMEINIT;
                currBuiltinOp = new DataGenOp(method, target, paramHops);
                break;
            }
            case TENSOR: 
            case MATRIX: {
                ArrayList<Hop> tmpMatrix = new ArrayList<Hop>();
                tmpMatrix.add(0, paramHops.get("data"));
                tmpMatrix.add(1, paramHops.get("rows"));
                tmpMatrix.add(2, paramHops.get("cols"));
                tmpMatrix.add(3, !paramHops.containsKey("dims") ? new LiteralOp("-1") : paramHops.get("dims"));
                tmpMatrix.add(4, paramHops.get("byrow"));
                currBuiltinOp = new ReorgOp(target.getName(), target.getDataType(), target.getValueType(), Types.ReOrgOp.RESHAPE, tmpMatrix);
                break;
            }
            case SQL: {
                currBuiltinOp = new DataOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOpData.SQLREAD, paramHops);
                break;
            }
            case FEDERATED: {
                currBuiltinOp = new DataOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOpData.FEDERATED, paramHops);
                break;
            }
            default: {
                throw new ParseException(source.printErrorLocation() + "processDataExpression():: Unknown operation:  " + source.getOpCode());
            }
        }
        this.setIdentifierParams(currBuiltinOp, source.getOutput());
        if (source.getOpCode() == Expression.DataOp.READ) {
            ((DataOp)currBuiltinOp).setInputBlocksize(target.getBlocksize());
        } else if (source.getOpCode() == Expression.DataOp.WRITE) {
            ((DataOp)currBuiltinOp).setPrivacy(hops.get(target.getName()).getPrivacy());
            if (source.getVarParam("rows_in_block") != null) {
                currBuiltinOp.setBlocksize(Integer.parseInt(source.getVarParam("rows_in_block").toString()));
            }
        }
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    private Hop processMultipleReturnBuiltinFunctionExpression(BuiltinFunctionExpression source, ArrayList<DataIdentifier> targetList, HashMap<String, Hop> hops) {
        ArrayList<Hop> inputs = new ArrayList<Hop>();
        inputs.add(this.processExpression(source.getFirstExpr(), null, hops));
        Expression[] expr = source.getAllExpr();
        if (expr != null && expr.length > 1) {
            for (int i = 1; i < expr.length; ++i) {
                inputs.add(this.processExpression(expr[i], null, hops));
            }
        }
        FunctionOp.FunctionType ftype = FunctionOp.FunctionType.MULTIRETURN_BUILTIN;
        String nameSpace = "_internal";
        ArrayList<Hop> outputs = new ArrayList<Hop>();
        FunctionOp currBuiltinOp = null;
        switch (source.getOpCode()) {
            case QR: 
            case LU: 
            case EIGEN: 
            case LSTM: 
            case LSTM_BACKWARD: 
            case BATCH_NORM2D: 
            case BATCH_NORM2D_BACKWARD: 
            case REMOVE: 
            case SVD: {
                FunctionOp fcall;
                String[] outputNames = new String[targetList.size()];
                for (int i = 0; i < targetList.size(); ++i) {
                    outputNames[i] = targetList.get(i).getName();
                    DataOp output = new DataOp(outputNames[i], Types.DataType.MATRIX, Types.ValueType.FP64, inputs.get(0), Types.OpOpData.FUNCTIONOUTPUT, inputs.get(0).getFilename());
                    outputs.add(output);
                }
                currBuiltinOp = fcall = new FunctionOp(ftype, nameSpace, source.getOpCode().toString(), null, inputs, outputNames, outputs);
                break;
            }
            default: {
                throw new ParseException("Invaid Opcode in DMLTranslator:processMultipleReturnBuiltinFunctionExpression(): " + source.getOpCode());
            }
        }
        for (int i = 0; i < source.getOutputs().length; ++i) {
            this.setIdentifierParams(outputs.get(i), source.getOutputs()[i]);
            outputs.get(i).setParseInfo(source);
        }
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Hop processBuiltinFunctionExpression(BuiltinFunctionExpression source, DataIdentifier target, HashMap<String, Hop> hops) {
        boolean isConvolution;
        Hop expr = null;
        if (source.getFirstExpr() != null) {
            expr = this.processExpression(source.getFirstExpr(), null, hops);
        }
        Hop expr2 = null;
        if (source.getSecondExpr() != null) {
            expr2 = this.processExpression(source.getSecondExpr(), null, hops);
        }
        Hop expr3 = null;
        if (source.getThirdExpr() != null) {
            expr3 = this.processExpression(source.getThirdExpr(), null, hops);
        }
        Hop currBuiltinOp = null;
        target = target == null ? DMLTranslator.createTarget(source) : target;
        block0 : switch (source.getOpCode()) {
            case EVAL: 
            case EVALLIST: {
                currBuiltinOp = new NaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOpN.EVAL, this.processAllExpressions(source.getAllExpr(), hops));
                break;
            }
            case COLSUM: 
            case COLMAX: 
            case COLMIN: 
            case COLMEAN: 
            case COLPROD: 
            case COLVAR: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name().substring(3)), Types.Direction.Col, expr);
                break;
            }
            case COLSD: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.VAR, Types.Direction.Col, expr);
                currBuiltinOp = new UnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.OpOp1.SQRT, currBuiltinOp);
                break;
            }
            case ROWSUM: 
            case ROWMIN: 
            case ROWMAX: 
            case ROWMEAN: 
            case ROWPROD: 
            case ROWVAR: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name().substring(3)), Types.Direction.Row, expr);
                break;
            }
            case ROWINDEXMAX: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.MAXINDEX, Types.Direction.Row, expr);
                break;
            }
            case ROWINDEXMIN: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.MININDEX, Types.Direction.Row, expr);
                break;
            }
            case ROWSD: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.VAR, Types.Direction.Row, expr);
                currBuiltinOp = new UnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.OpOp1.SQRT, currBuiltinOp);
                break;
            }
            case NROW: {
                currBuiltinOp = expr.getDim1() == -1L ? new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp1.NROW, expr) : new LiteralOp(expr.getDim1());
                break;
            }
            case NCOL: {
                currBuiltinOp = expr.getDim2() == -1L ? new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp1.NCOL, expr) : new LiteralOp(expr.getDim2());
                break;
            }
            case LENGTH: {
                currBuiltinOp = expr.getDim1() == -1L || expr.getDim2() == -1L ? new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp1.LENGTH, expr) : new LiteralOp(expr.getDim1() * expr.getDim2());
                break;
            }
            case LINEAGE: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp1.LINEAGE, expr);
                DMLScript.LINEAGE = true;
                break;
            }
            case LIST: {
                currBuiltinOp = new NaryOp(target.getName(), Types.DataType.LIST, Types.ValueType.UNKNOWN, Types.OpOpN.LIST, this.processAllExpressions(source.getAllExpr(), hops));
                break;
            }
            case EXISTS: {
                currBuiltinOp = new UnaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.OpOp1.EXISTS, expr);
                break;
            }
            case SUM: 
            case PROD: 
            case VAR: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name()), Types.Direction.RowCol, expr);
                break;
            }
            case MEAN: {
                if (expr2 == null) {
                    currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.AggOp.MEAN, Types.Direction.RowCol, expr);
                    break;
                }
                LiteralOp orderHop = new LiteralOp(0L);
                currBuiltinOp = new TernaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.OpOp3.MOMENT, expr, expr2, orderHop);
                break;
            }
            case SD: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.AggOp.VAR, Types.Direction.RowCol, expr);
                HopRewriteUtils.setOutputParametersForScalar(currBuiltinOp);
                currBuiltinOp = new UnaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.OpOp1.SQRT, currBuiltinOp);
                break;
            }
            case MIN: 
            case MAX: {
                currBuiltinOp = expr2 == null ? new AggUnaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name()), Types.Direction.RowCol, expr) : (source.getAllExpr().length == 2 ? new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp2.valueOf(source.getOpCode().name()), expr, expr2) : new NaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOpN.valueOf(source.getOpCode().name()), this.processAllExpressions(source.getAllExpr(), hops)));
                break;
            }
            case PPRED: {
                Types.OpOp2 operation;
                String sop = ((StringIdentifier)source.getThirdExpr()).getValue();
                sop = sop.replace("\"", "");
                if (sop.equalsIgnoreCase(">=")) {
                    operation = Types.OpOp2.GREATEREQUAL;
                } else if (sop.equalsIgnoreCase(">")) {
                    operation = Types.OpOp2.GREATER;
                } else if (sop.equalsIgnoreCase("<=")) {
                    operation = Types.OpOp2.LESSEQUAL;
                } else if (sop.equalsIgnoreCase("<")) {
                    operation = Types.OpOp2.LESS;
                } else if (sop.equalsIgnoreCase("==")) {
                    operation = Types.OpOp2.EQUAL;
                } else {
                    if (!sop.equalsIgnoreCase("!=")) throw new ParseException(source.printErrorLocation() + "Unknown argument (" + sop + ") for PPRED.");
                    operation = Types.OpOp2.NOTEQUAL;
                }
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), operation, expr, expr2);
                break;
            }
            case TRACE: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.AggOp.TRACE, Types.Direction.RowCol, expr);
                break;
            }
            case TRANS: 
            case DIAG: 
            case REV: {
                currBuiltinOp = new ReorgOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.ReOrgOp.valueOf(source.getOpCode().name()), expr);
                break;
            }
            case CBIND: 
            case RBIND: {
                Types.OpOp2 appendOp2 = source.getOpCode() == Builtins.CBIND ? Types.OpOp2.CBIND : Types.OpOp2.RBIND;
                Types.OpOpN appendOpN = source.getOpCode() == Builtins.CBIND ? Types.OpOpN.CBIND : Types.OpOpN.RBIND;
                currBuiltinOp = source.getAllExpr().length == 2 ? new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), appendOp2, expr, expr2) : new NaryOp(target.getName(), target.getDataType(), target.getValueType(), appendOpN, this.processAllExpressions(source.getAllExpr(), hops));
                break;
            }
            case TABLE: {
                int numTableArgs = source._args.length;
                switch (numTableArgs) {
                    case 2: 
                    case 4: {
                        LiteralOp weightHop = new LiteralOp(1.0);
                        weightHop.setDim1(0L);
                        weightHop.setDim2(0L);
                        weightHop.setNnz(-1L);
                        weightHop.setBlocksize(0);
                        if (numTableArgs == 2) {
                            currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp3.CTABLE, expr, expr2, weightHop);
                            break block0;
                        }
                        Hop outDim1 = this.processExpression(source._args[2], null, hops);
                        Hop outDim2 = this.processExpression(source._args[3], null, hops);
                        currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp3.CTABLE, expr, expr2, weightHop, outDim1, outDim2, new LiteralOp(true));
                        break block0;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        if (numTableArgs == 3) {
                            currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp3.CTABLE, expr, expr2, expr3);
                            break block0;
                        }
                        Hop outDim1 = this.processExpression(source._args[3], null, hops);
                        Hop outDim2 = this.processExpression(source._args[4], null, hops);
                        LiteralOp outputEmptyBlocks = numTableArgs == 6 ? this.processExpression(source._args[5], null, hops) : new LiteralOp(true);
                        currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp3.CTABLE, expr, expr2, expr3, outDim1, outDim2, outputEmptyBlocks);
                        break block0;
                    }
                }
                throw new ParseException("Invalid number of arguments " + numTableArgs + " to table() function.");
            }
            case CAST_AS_SCALAR: {
                currBuiltinOp = new UnaryOp(target.getName(), Types.DataType.SCALAR, target.getValueType(), Types.OpOp1.CAST_AS_SCALAR, expr);
                break;
            }
            case CAST_AS_MATRIX: {
                currBuiltinOp = new UnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.OpOp1.CAST_AS_MATRIX, expr);
                break;
            }
            case CAST_AS_FRAME: {
                currBuiltinOp = new UnaryOp(target.getName(), Types.DataType.FRAME, target.getValueType(), Types.OpOp1.CAST_AS_FRAME, expr);
                break;
            }
            case CAST_AS_LIST: {
                currBuiltinOp = new UnaryOp(target.getName(), Types.DataType.LIST, target.getValueType(), Types.OpOp1.CAST_AS_LIST, expr);
                break;
            }
            case CAST_AS_DOUBLE: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Types.ValueType.FP64, Types.OpOp1.CAST_AS_DOUBLE, expr);
                break;
            }
            case CAST_AS_INT: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Types.ValueType.INT64, Types.OpOp1.CAST_AS_INT, expr);
                break;
            }
            case CAST_AS_BOOLEAN: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Types.ValueType.BOOLEAN, Types.OpOp1.CAST_AS_BOOLEAN, expr);
                break;
            }
            case LOCAL: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Types.ValueType.FP64, Types.OpOp1.LOCAL, expr);
                break;
            }
            case COMPRESS: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Types.ValueType.FP64, Types.OpOp1.COMPRESS, expr);
                break;
            }
            case DECOMPRESS: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), Types.ValueType.FP64, Types.OpOp1.DECOMPRESS, expr);
                break;
            }
            case XOR: 
            case BITWAND: 
            case BITWOR: 
            case BITWXOR: 
            case BITWSHIFTL: 
            case BITWSHIFTR: {
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp2.valueOf(source.getOpCode().name()), expr, expr2);
                break;
            }
            case ABS: 
            case SIN: 
            case COS: 
            case TAN: 
            case ASIN: 
            case ACOS: 
            case ATAN: 
            case SINH: 
            case COSH: 
            case TANH: 
            case SIGN: 
            case SQRT: 
            case EXP: 
            case ROUND: 
            case CEIL: 
            case FLOOR: 
            case CUMSUM: 
            case CUMPROD: 
            case CUMSUMPROD: 
            case CUMMIN: 
            case CUMMAX: 
            case ISNA: 
            case ISNAN: 
            case ISINF: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp1.valueOf(source.getOpCode().name()), expr);
                break;
            }
            case DROP_INVALID_TYPE: 
            case DROP_INVALID_LENGTH: 
            case VALUE_SWAP: 
            case FRAME_ROW_REPLICATE: 
            case APPLY_SCHEMA: {
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp2.valueOf(source.getOpCode().name()), expr, expr2);
                break;
            }
            case MAP: {
                currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp3.valueOf(source.getOpCode().name()), expr, expr2, expr3 == null ? new LiteralOp(0L) : expr3);
                break;
            }
            case LOG: {
                Types.OpOp2 mathOp3;
                if (expr2 == null) {
                    Types.OpOp1 mathOp2;
                    switch (source.getOpCode()) {
                        case LOG: {
                            mathOp2 = Types.OpOp1.LOG;
                            break;
                        }
                        default: {
                            throw new ParseException(source.printErrorLocation() + "processBuiltinFunctionExpression():: Could not find Operation type for builtin function: " + source.getOpCode());
                        }
                    }
                    currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), mathOp2, expr);
                    break;
                }
                switch (source.getOpCode()) {
                    case LOG: {
                        mathOp3 = Types.OpOp2.LOG;
                        break;
                    }
                    default: {
                        throw new ParseException(source.printErrorLocation() + "processBuiltinFunctionExpression():: Could not find Operation type for builtin function: " + source.getOpCode());
                    }
                }
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), mathOp3, expr, expr2);
                break;
            }
            case MOMENT: 
            case COV: 
            case QUANTILE: 
            case INTERQUANTILE: {
                currBuiltinOp = expr3 == null ? new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp2.valueOf(source.getOpCode().name()), expr, expr2) : new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp3.valueOf(source.getOpCode().name()), expr, expr2, expr3);
                break;
            }
            case IQM: 
            case MEDIAN: {
                currBuiltinOp = expr2 == null ? new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp1.valueOf(source.getOpCode().name()), expr) : new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp2.valueOf(source.getOpCode().name()), expr, expr2);
                break;
            }
            case IFELSE: {
                currBuiltinOp = new TernaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp3.IFELSE, expr, expr2, expr3);
                break;
            }
            case SEQ: {
                HashMap<String, Hop> randParams = new HashMap<String, Hop>();
                randParams.put("from", expr);
                randParams.put("to", expr2);
                randParams.put("incr", expr3 != null ? expr3 : new LiteralOp(1L));
                currBuiltinOp = new DataGenOp(Types.OpOpDG.SEQ, target, randParams);
                break;
            }
            case TIME: {
                currBuiltinOp = new DataGenOp(Types.OpOpDG.TIME, target);
                break;
            }
            case SAMPLE: {
                Expression[] in = source.getAllExpr();
                HashMap<String, Hop> tmpparams = new HashMap<String, Hop>();
                tmpparams.put("max", expr);
                tmpparams.put("rows", expr2);
                tmpparams.put("cols", new LiteralOp(1L));
                if (in.length == 4) {
                    tmpparams.put("pdf", expr3);
                    Hop seed = this.processExpression(in[3], null, hops);
                    tmpparams.put("seed", seed);
                } else if (in.length == 3) {
                    if (expr3.getValueType() == Types.ValueType.BOOLEAN) {
                        tmpparams.put("pdf", expr3);
                        tmpparams.put("seed", new LiteralOp(-1L));
                    } else {
                        if (expr3.getValueType() != Types.ValueType.INT64) throw new HopsException("Invalid input type " + expr3.getValueType() + " in sample().");
                        tmpparams.put("pdf", new LiteralOp(false));
                        tmpparams.put("seed", expr3);
                    }
                } else if (in.length == 2) {
                    tmpparams.put("pdf", new LiteralOp(false));
                    tmpparams.put("seed", new LiteralOp(-1L));
                }
                currBuiltinOp = new DataGenOp(Types.OpOpDG.SAMPLE, target, tmpparams);
                break;
            }
            case SOLVE: {
                currBuiltinOp = new BinaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp2.SOLVE, expr, expr2);
                break;
            }
            case INVERSE: 
            case CHOLESKY: 
            case TYPEOF: 
            case DETECTSCHEMA: 
            case COLNAMES: {
                currBuiltinOp = new UnaryOp(target.getName(), target.getDataType(), target.getValueType(), Types.OpOp1.valueOf(source.getOpCode().name()), expr);
                break;
            }
            case OUTER: {
                if (!(expr3 instanceof LiteralOp)) {
                    throw new HopsException("Operator for outer builtin function must be a constant: " + expr3);
                }
                Types.OpOp2 op = Types.OpOp2.valueOfByOpcode(((LiteralOp)expr3).getStringValue());
                if (op == null) {
                    throw new HopsException("Unsupported outer vector binary operation: " + ((LiteralOp)expr3).getStringValue());
                }
                currBuiltinOp = new BinaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), op, expr, expr2);
                ((BinaryOp)currBuiltinOp).setOuterVectorOperation(true);
                currBuiltinOp.refreshSizeInformation();
                break;
            }
            case BIASADD: 
            case BIASMULT: {
                ArrayList<Hop> inHops1 = new ArrayList<Hop>();
                inHops1.add(expr);
                inHops1.add(expr2);
                currBuiltinOp = new DnnOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.OpOpDnn.valueOf(source.getOpCode().name()), inHops1);
                DMLTranslator.setBlockSizeAndRefreshSizeInfo(expr, currBuiltinOp);
                break;
            }
            case AVG_POOL: 
            case MAX_POOL: {
                currBuiltinOp = new DnnOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.OpOpDnn.valueOf(source.getOpCode().name()), this.getALHopsForPoolingForwardIM2COL(expr, source, 1, hops));
                DMLTranslator.setBlockSizeAndRefreshSizeInfo(expr, currBuiltinOp);
                break;
            }
            case AVG_POOL_BACKWARD: 
            case MAX_POOL_BACKWARD: {
                currBuiltinOp = new DnnOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.OpOpDnn.valueOf(source.getOpCode().name()), this.getALHopsForConvOpPoolingCOL2IM(expr, source, 1, hops));
                DMLTranslator.setBlockSizeAndRefreshSizeInfo(expr, currBuiltinOp);
                break;
            }
            case CONV2D: 
            case CONV2D_BACKWARD_FILTER: 
            case CONV2D_BACKWARD_DATA: {
                currBuiltinOp = new DnnOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.OpOpDnn.valueOf(source.getOpCode().name()), this.getALHopsForConvOp(expr, source, 1, hops));
                DMLTranslator.setBlockSizeAndRefreshSizeInfo(expr, currBuiltinOp);
                break;
            }
            case ROW_COUNT_DISTINCT: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name()), Types.Direction.Row, expr);
                break;
            }
            case COL_COUNT_DISTINCT: {
                currBuiltinOp = new AggUnaryOp(target.getName(), Types.DataType.MATRIX, target.getValueType(), Types.AggOp.valueOf(source.getOpCode().name()), Types.Direction.Col, expr);
                break;
            }
            default: {
                throw new ParseException("Unsupported builtin function type: " + source.getOpCode());
            }
        }
        boolean bl = isConvolution = source.getOpCode() == Builtins.CONV2D || source.getOpCode() == Builtins.CONV2D_BACKWARD_DATA || source.getOpCode() == Builtins.CONV2D_BACKWARD_FILTER || source.getOpCode() == Builtins.MAX_POOL || source.getOpCode() == Builtins.MAX_POOL_BACKWARD || source.getOpCode() == Builtins.AVG_POOL || source.getOpCode() == Builtins.AVG_POOL_BACKWARD;
        if (!isConvolution) {
            this.setIdentifierParams(currBuiltinOp, source.getOutput());
        }
        currBuiltinOp.setParseInfo(source);
        return currBuiltinOp;
    }

    private Hop[] processAllExpressions(Expression[] expr, HashMap<String, Hop> hops) {
        Hop[] ret = new Hop[expr.length];
        for (int i = 0; i < expr.length; ++i) {
            ret[i] = this.processExpression(expr[i], null, hops);
        }
        return ret;
    }

    private static void setBlockSizeAndRefreshSizeInfo(Hop in, Hop out) {
        out.setBlocksize(in.getBlocksize());
        out.refreshSizeInformation();
        HopRewriteUtils.copyLineNumbers(in, out);
    }

    private ArrayList<Hop> getALHopsForConvOpPoolingCOL2IM(Hop first, BuiltinFunctionExpression source, int skip, HashMap<String, Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        ret.add(first);
        Expression[] allExpr = source.getAllExpr();
        for (int i = skip; i < allExpr.length; ++i) {
            if (i == 11) {
                ret.add(this.processExpression(allExpr[7], null, hops));
                continue;
            }
            ret.add(this.processExpression(allExpr[i], null, hops));
        }
        return ret;
    }

    private ArrayList<Hop> getALHopsForPoolingForwardIM2COL(Hop first, BuiltinFunctionExpression source, int skip, HashMap<String, Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        ret.add(first);
        Expression[] allExpr = source.getAllExpr();
        if (skip != 1) {
            throw new ParseException("Unsupported skip");
        }
        Expression numChannels = allExpr[6];
        for (int i = skip; i < allExpr.length; ++i) {
            if (i == 10) {
                ret.add(this.processExpression(numChannels, null, hops));
                continue;
            }
            ret.add(this.processExpression(allExpr[i], null, hops));
        }
        return ret;
    }

    private ArrayList<Hop> getALHopsForConvOpPoolingIM2COL(Hop first, BuiltinFunctionExpression source, int skip, HashMap<String, Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        ret.add(first);
        Expression[] allExpr = source.getAllExpr();
        int numImgIndex = -1;
        if (skip == 1) {
            numImgIndex = 5;
        } else if (skip == 2) {
            numImgIndex = 6;
        } else {
            throw new ParseException("Unsupported skip");
        }
        for (int i = skip; i < allExpr.length; ++i) {
            if (i == numImgIndex) {
                Expression numImg = allExpr[numImgIndex];
                Expression numChannels = allExpr[numImgIndex + 1];
                BinaryExpression tmp = new BinaryExpression(Expression.BinaryOp.MULT, numImg);
                tmp.setLeft(numImg);
                tmp.setRight(numChannels);
                ret.add(this.processTempIntExpression(tmp, hops));
                ret.add(this.processExpression(new IntIdentifier(1L, (ParseInfo)numImg), null, hops));
                ++i;
                continue;
            }
            ret.add(this.processExpression(allExpr[i], null, hops));
        }
        return ret;
    }

    private ArrayList<Hop> getALHopsForConvOp(Hop first, BuiltinFunctionExpression source, int skip, HashMap<String, Hop> hops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        ret.add(first);
        Expression[] allExpr = source.getAllExpr();
        for (int i = skip; i < allExpr.length; ++i) {
            ret.add(this.processExpression(allExpr[i], null, hops));
        }
        return ret;
    }

    public void setIdentifierParams(Hop h, Identifier id) {
        if (id.getDim1() >= 0L) {
            h.setDim1(id.getDim1());
        }
        if (id.getDim2() >= 0L) {
            h.setDim2(id.getDim2());
        }
        if (id.getNnz() >= 0L) {
            h.setNnz(id.getNnz());
        }
        h.setBlocksize(id.getBlocksize());
        h.setPrivacy(id.getPrivacy());
    }

    private boolean prepareReadAfterWrite(DMLProgram prog, HashMap<String, DataIdentifier> pWrites) {
        boolean ret = false;
        for (StatementBlock sb : prog.getStatementBlocks()) {
            ret |= this.prepareReadAfterWrite(sb, pWrites);
        }
        return ret;
    }

    private boolean prepareReadAfterWrite(StatementBlock sb, HashMap<String, DataIdentifier> pWrites) {
        boolean ret = false;
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock csb : fstmt.getBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            for (StatementBlock csb : wstmt.getBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            for (StatementBlock csb : istmt.getIfBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
            for (StatementBlock csb : istmt.getElseBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            for (StatementBlock csb : fstmt.getBody()) {
                ret |= this.prepareReadAfterWrite(csb, pWrites);
            }
        } else {
            for (Statement s : sb.getStatements()) {
                DataExpression dexpr;
                DataIdentifier di;
                String pfname;
                if (s instanceof OutputStatement) {
                    OutputStatement os = (OutputStatement)s;
                    pfname = os.getExprParam("iofilename").toString();
                    di = (DataIdentifier)os.getSource().getOutput();
                    pWrites.put(pfname, di);
                    continue;
                }
                if (!(s instanceof AssignmentStatement) || !(((AssignmentStatement)s).getSource() instanceof DataExpression) || !(dexpr = (DataExpression)((AssignmentStatement)s).getSource()).isRead() || !pWrites.containsKey(pfname = dexpr.getVarParam("iofilename").toString()) || pfname.trim().isEmpty()) continue;
                di = pWrites.get(pfname);
                Types.FileFormat ft = di.getFileFormat() != null ? di.getFileFormat() : Types.FileFormat.TEXT;
                dexpr.addVarParam("format", new StringIdentifier(ft.toString(), di));
                if (di.getDim1() >= 0L) {
                    dexpr.addVarParam("rows", new IntIdentifier(di.getDim1(), (ParseInfo)di));
                }
                if (di.getDim2() >= 0L) {
                    dexpr.addVarParam("cols", new IntIdentifier(di.getDim2(), (ParseInfo)di));
                }
                if (di.getValueType() != Types.ValueType.UNKNOWN) {
                    dexpr.addVarParam("value_type", new StringIdentifier(di.getValueType().toExternalString(), di));
                }
                if (di.getDataType() != Types.DataType.UNKNOWN) {
                    dexpr.addVarParam("data_type", new StringIdentifier(di.getDataType().toString(), di));
                }
                ret = true;
            }
        }
        return ret;
    }
}

