/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.LazyWriteBuffer;
import org.apache.sysds.runtime.controlprogram.caching.UnifiedMemoryManager;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.FrameReaderFactory;
import org.apache.sysds.runtime.io.FrameWriter;
import org.apache.sysds.runtime.io.FrameWriterFactory;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageRecomputeUtils;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaData;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.UtilFunctions;

public class FrameObject
extends CacheableData<FrameBlock> {
    private static final long serialVersionUID = 1755082174281927785L;
    private Types.ValueType[] _schema = null;

    protected FrameObject() {
        super(Types.DataType.FRAME, Types.ValueType.STRING);
    }

    public FrameObject(String fname) {
        this();
        this.setFileName(fname);
    }

    public FrameObject(String fname, MetaData meta) {
        this();
        this.setFileName(fname);
        this.setMetaData(meta);
    }

    public FrameObject(String fname, MetaData meta, Types.ValueType[] schema) {
        this();
        this.setFileName(fname);
        this.setMetaData(meta);
        this.setSchema(schema);
    }

    public FrameObject(FrameObject fo) {
        super(fo);
        MetaDataFormat metaOld = (MetaDataFormat)fo.getMetaData();
        this._metaData = new MetaDataFormat(new MatrixCharacteristics(metaOld.getDataCharacteristics()), metaOld.getFileFormat());
        this._schema = (Types.ValueType[])fo._schema.clone();
    }

    @Override
    public Types.ValueType[] getSchema() {
        return this._schema;
    }

    public Types.ValueType[] getSchema(int cl, int cu) {
        return this._schema != null && this._schema.length > cu ? Arrays.copyOfRange(this._schema, cl, cu + 1) : UtilFunctions.nCopies(cu - cl + 1, Types.ValueType.STRING);
    }

    public Types.ValueType[] mergeSchemas(FrameObject fo) {
        return (Types.ValueType[])ArrayUtils.addAll((Object[])(this._schema != null ? this._schema : UtilFunctions.nCopies((int)this.getNumColumns(), Types.ValueType.STRING)), (Object[])(fo._schema != null ? fo._schema : UtilFunctions.nCopies((int)fo.getNumColumns(), Types.ValueType.STRING)));
    }

    public void setSchema(String schema) {
        if (schema.equals("*")) {
            int clen = (int)this.getNumColumns();
            if (clen >= 0) {
                this._schema = UtilFunctions.nCopies(clen, Types.ValueType.STRING);
            }
        } else {
            this._schema = FrameObject.parseSchema(schema);
        }
    }

    public static Types.ValueType[] parseSchema(String schema) {
        String[] parts = schema.split(",");
        Types.ValueType[] ret = new Types.ValueType[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            ret[i] = Types.ValueType.fromExternalString(parts[i].toUpperCase());
        }
        return ret;
    }

    public void setSchema(Types.ValueType[] schema) {
        this._schema = schema;
    }

    @Override
    public void refreshMetaData() {
        if (this._data == null || this._metaData == null) {
            throw new DMLRuntimeException("Cannot refresh meta data because there is no data or meta data. ");
        }
        DataCharacteristics dc = this._metaData.getDataCharacteristics();
        dc.setDimension(((FrameBlock)this._data).getNumRows(), ((FrameBlock)this._data).getNumColumns());
        dc.setNonZeros(((FrameBlock)this._data).getNumRows() * ((FrameBlock)this._data).getNumColumns());
        this._schema = ((FrameBlock)this._data).getSchema();
    }

    @Override
    public long getNumRows() {
        DataCharacteristics dc = this.getDataCharacteristics();
        return dc.getRows();
    }

    @Override
    public long getNumColumns() {
        DataCharacteristics dc = this.getDataCharacteristics();
        return dc.getCols();
    }

    @Override
    protected FrameBlock readBlobFromCache(String fname) throws IOException {
        FrameBlock fb = null;
        fb = OptimizerUtils.isUMMEnabled() ? (FrameBlock)UnifiedMemoryManager.readBlock(fname, false) : (FrameBlock)LazyWriteBuffer.readBlock(fname, false);
        return fb;
    }

    @Override
    protected FrameBlock readBlobFromHDFS(String fname, long[] dims) throws IOException {
        FrameBlock data;
        long clen = dims[1];
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics dc = iimd.getDataCharacteristics();
        Types.ValueType[] lschema = this._schema != null ? this._schema : UtilFunctions.nCopies(clen >= 1L ? (int)clen : 1, Types.ValueType.STRING);
        FrameBlock frameBlock = data = this.isFederated() ? (FrameBlock)this.acquireReadAndRelease() : FrameReaderFactory.createFrameReader(iimd.getFileFormat(), this.getFileFormatProperties()).readFrameFromHDFS(fname, lschema, dc.getRows(), dc.getCols());
        if (iimd.getFileFormat() == Types.FileFormat.CSV) {
            MetaData metaData = this._metaData = this._metaData instanceof MetaDataFormat ? new MetaDataFormat(data.getDataCharacteristics(), iimd.getFileFormat()) : new MetaData(data.getDataCharacteristics());
        }
        if (data == null) {
            throw new IOException("Unable to load frame from file: " + fname);
        }
        return data;
    }

    @Override
    protected FrameBlock readBlobFromRDD(RDDObject rdd, MutableBoolean status) throws IOException {
        RDDObject lrdd = rdd;
        status.setValue(false);
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        DataCharacteristics dc = iimd.getDataCharacteristics();
        int rlen = (int)dc.getRows();
        int clen = (int)dc.getCols();
        Types.ValueType[] lschema = this._schema != null ? this._schema : UtilFunctions.nCopies(clen >= 1 ? clen : 1, Types.ValueType.STRING);
        FrameBlock fb = null;
        try {
            if (rdd.allowsShortCircuitCollect()) {
                lrdd = (RDDObject)rdd.getLineageChilds().get(0);
            }
            fb = SparkExecutionContext.toFrameBlock(lrdd, lschema, rlen, clen);
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        if (fb == null) {
            throw new IOException("Unable to load frame from rdd.");
        }
        return fb;
    }

    @Override
    protected FrameBlock readBlobFromFederated(FederationMap fedMap, long[] dims) throws IOException {
        FrameBlock ret = new FrameBlock(this._schema);
        ret.ensureAllocatedColumns((int)dims[0]);
        List<Pair<FederatedRange, Future<FederatedResponse>>> readResponses = fedMap.requestFederatedData();
        try {
            for (Pair<FederatedRange, Future<FederatedResponse>> readResponse : readResponses) {
                FederatedRange range = (FederatedRange)readResponse.getLeft();
                FederatedResponse response = (FederatedResponse)((Future)readResponse.getRight()).get();
                FrameBlock multRes = (FrameBlock)response.getData()[0];
                for (int r = 0; r < multRes.getNumRows(); ++r) {
                    for (int c = 0; c < multRes.getNumColumns(); ++c) {
                        int destRow = range.getBeginDimsInt()[0] + r;
                        int destCol = range.getBeginDimsInt()[1] + c;
                        ret.set(destRow, destCol, multRes.get(r, c));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Federated Frame read failed.", e);
        }
        return ret;
    }

    @Override
    protected void writeBlobToHDFS(String fname, String ofmt, int rep, FileFormatProperties fprop) throws IOException, DMLRuntimeException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        Types.FileFormat fmt = ofmt != null ? Types.FileFormat.safeValueOf(ofmt) : iimd.getFileFormat();
        FrameWriter writer = FrameWriterFactory.createFrameWriter(fmt, fprop);
        writer.writeFrameToHDFS((FrameBlock)this._data, fname, this.getNumRows(), this.getNumColumns());
    }

    @Override
    protected void writeBlobFromRDDtoHDFS(RDDObject rdd, String fname, String ofmt) throws IOException, DMLRuntimeException {
        MetaDataFormat iimd = (MetaDataFormat)this._metaData;
        SparkExecutionContext.writeFrameRDDtoHDFS(rdd, fname, iimd.getFileFormat());
    }

    @Override
    protected FrameBlock reconstructByLineage(LineageItem li) throws IOException {
        return (FrameBlock)((FrameObject)LineageRecomputeUtils.parseNComputeLineageTrace(li.getData(), null)).acquireReadAndRelease();
    }
}

