/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.controlprogram.parfor.RemoteParForJobReturn;
import org.apache.sysds.runtime.controlprogram.parfor.RemoteParForSparkWorker;
import org.apache.sysds.runtime.controlprogram.parfor.RemoteParForUtils;
import org.apache.sysds.runtime.controlprogram.parfor.Task;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.utils.Statistics;

public class RemoteParForSpark {
    protected static final Log LOG = LogFactory.getLog((String)RemoteParForSpark.class.getName());
    private static final IDSequence _jobID = new IDSequence();

    public static RemoteParForJobReturn runJob(long pfid, String prog, HashMap<String, byte[]> clsMap, List<Task> tasks, ExecutionContext ec, Set<String> brVars, List<ParForStatementBlock.ResultVar> resultVars, boolean cpCaching, int numMappers, boolean topLevelPF) {
        String jobname = "ParFor-ESP";
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaSparkContext sc = sec.getSparkContext();
        boolean isLocal = sc.isLocal();
        LongAccumulator aTasks = sc.sc().longAccumulator("tasks");
        LongAccumulator aIters = sc.sc().longAccumulator("iterations");
        long jobid = _jobID.getNextID();
        if (isLocal) {
            RemoteParForSparkWorker.cleanupCachedVariables(jobid);
        }
        Map<String, Broadcast<CacheBlock<?>>> brInputs = null;
        if (ParForProgramBlock.ALLOW_BROADCAST_INPUTS) {
            brInputs = RemoteParForSpark.broadcastInputs(sec, brVars);
        }
        Map<String, String> serialLineage = DMLScript.LINEAGE ? ec.getLineage().serialize() : null;
        List out = sc.parallelize(tasks, tasks.size()).flatMapToPair((PairFlatMapFunction)new RemoteParForSparkWorker(jobid, prog, isLocal, clsMap, cpCaching, aTasks, aIters, brInputs, topLevelPF, serialLineage)).collect();
        LocalVariableMap[] results = RemoteParForUtils.getResults(out, LOG);
        Lineage[] lineages = DMLScript.LINEAGE ? RemoteParForUtils.getLineages(results) : null;
        int numTasks = aTasks.value().intValue();
        int numIters = aIters.value().intValue();
        RemoteParForJobReturn ret = new RemoteParForJobReturn(true, numTasks, numIters, results, lineages);
        Statistics.incrementNoOfCompiledSPInst();
        Statistics.incrementNoOfExecutedSPInst();
        if (DMLScript.STATISTICS) {
            Statistics.maintainCPHeavyHitters(jobname, System.nanoTime() - t0);
        }
        return ret;
    }

    private static Map<String, Broadcast<CacheBlock<?>>> broadcastInputs(SparkExecutionContext sec, Set<String> brVars) {
        HashMap result = new HashMap();
        for (String key : brVars) {
            Data var = sec.getVariable(key);
            if (var instanceof ScalarObject || var instanceof MatrixObject && ((MatrixObject)var).isPartitioned()) continue;
            result.put(key, sec.broadcastVariable((CacheableData)var));
        }
        return result;
    }
}

