/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.parser.ParForStatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.caching.CacheStatistics;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Stat;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.io.FileFormatProperties;
import org.apache.sysds.runtime.io.ListWriter;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageParser;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.runtime.util.LocalFileUtils;
import org.apache.sysds.runtime.util.ProgramConverter;
import org.apache.sysds.utils.Explain;
import org.apache.sysds.utils.Statistics;
import scala.Tuple2;

public class RemoteParForUtils {
    public static void incrementParForMRCounters(Reporter reporter, long deltaTasks, long deltaIterations) {
        if (deltaTasks > 0L) {
            reporter.incrCounter("SystemDS ParFOR Counters", Stat.PARFOR_NUMTASKS.toString(), deltaTasks);
        }
        if (deltaIterations > 0L) {
            reporter.incrCounter("SystemDS ParFOR Counters", Stat.PARFOR_NUMITERS.toString(), deltaIterations);
        }
        JobConf job = ConfigurationManager.getCachedJobConf();
        if (DMLScript.STATISTICS && !InfrastructureAnalyzer.isLocalMode(job)) {
            reporter.incrCounter("SystemDS ParFOR Counters", Stat.PARFOR_JITCOMPILE.toString(), Statistics.getJITCompileTime());
            reporter.incrCounter("SystemDS ParFOR Counters", Stat.PARFOR_JVMGC_COUNT.toString(), Statistics.getJVMgcCount());
            reporter.incrCounter("SystemDS ParFOR Counters", Stat.PARFOR_JVMGC_TIME.toString(), Statistics.getJVMgcTime());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_HITS_MEM.toString(), CacheStatistics.getMemHits());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_HITS_FSBUFF.toString(), CacheStatistics.getFSBuffHits());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_HITS_FS.toString(), CacheStatistics.getFSHits());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_HITS_HDFS.toString(), CacheStatistics.getHDFSHits());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_WRITES_FSBUFF.toString(), CacheStatistics.getFSBuffWrites());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_WRITES_FS.toString(), CacheStatistics.getFSWrites());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_WRITES_HDFS.toString(), CacheStatistics.getHDFSWrites());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_TIME_ACQR.toString(), CacheStatistics.getAcquireRTime());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_TIME_ACQM.toString(), CacheStatistics.getAcquireMTime());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_TIME_RLS.toString(), CacheStatistics.getReleaseTime());
            reporter.incrCounter("SystemDS Caching Counters", CacheStatistics.Stat.CACHE_TIME_EXP.toString(), CacheStatistics.getExportTime());
            CacheStatistics.reset();
        }
    }

    public static ArrayList<String> exportResultVariables(long workerID, LocalVariableMap vars, ArrayList<ParForStatementBlock.ResultVar> resultVars) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (ParForStatementBlock.ResultVar rvar : resultVars) {
            Data dat = vars.get(rvar._name);
            if (dat != null && dat.getDataType().isMatrixOrFrame()) {
                CacheableData cd = (CacheableData)dat;
                if (cd.isDirty()) {
                    cd.exportData();
                    ret.add(ProgramConverter.serializeDataObject(rvar._name, dat));
                }
                cd.freeEvictedBlob();
                continue;
            }
            if (!(dat instanceof ListObject)) continue;
            String fname = OptimizerUtils.getUniqueTempFileName();
            ListWriter.writeListToHDFS((ListObject)dat, fname, "binary", new FileFormatProperties(ConfigurationManager.getBlocksize()));
            ret.add(ProgramConverter.serializeDataObject(rvar._name, dat));
        }
        return ret;
    }

    public static void exportLineageItems(long workerID, LocalVariableMap vars, ArrayList<ParForStatementBlock.ResultVar> resultVars, Lineage lineage) throws IOException {
        for (ParForStatementBlock.ResultVar rvar : resultVars) {
            MatrixObject mo;
            Data dat = vars.get(rvar._name);
            if (dat == null || dat.getDataType() != Types.DataType.MATRIX || !(mo = (MatrixObject)dat).isDirty()) continue;
            LineageItem item = lineage.get(rvar._name);
            HDFSTool.writeStringToHDFS(Explain.explain(item), mo.getFileName() + ".lin");
        }
    }

    public static void cleanupWorkingDirectories() {
        CacheableData.cleanupCacheDir();
        CacheableData.disableCaching();
        LocalFileUtils.cleanupWorkingDirectory();
    }

    public static void cleanupWorkingDirectoriesOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new DeleteWorkingDirectoriesTask());
    }

    public static Lineage[] getLineages(LocalVariableMap[] results) {
        Lineage[] ret = new Lineage[results.length];
        try {
            for (int i = 0; i < results.length; ++i) {
                LocalVariableMap vars = results[i];
                ret[i] = new Lineage();
                for (Map.Entry<String, Data> e : vars.entrySet()) {
                    MatrixObject mo = (MatrixObject)e.getValue();
                    String lineage = HDFSTool.readStringFromHDFSFile(mo.getFileName() + ".lin");
                    ret[i].set(e.getKey(), LineageParser.parseLineageTrace(lineage, e.getKey()));
                }
            }
        }
        catch (IOException ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static LocalVariableMap[] getResults(List<Tuple2<Long, String>> out, Log LOG) {
        HashMap<Long, LocalVariableMap> tmp = new HashMap<Long, LocalVariableMap>();
        int countAll = 0;
        for (Tuple2<Long, String> entry : out) {
            Long key = (Long)entry._1();
            String val = (String)entry._2();
            if (!tmp.containsKey(key)) {
                tmp.put(key, new LocalVariableMap());
            }
            Object[] dat = ProgramConverter.parseDataObject(val);
            ((LocalVariableMap)tmp.get(key)).put((String)dat[0], (Data)dat[1]);
            ++countAll;
        }
        if (LOG != null) {
            LOG.debug((Object)("Num remote worker results (before deduplication): " + countAll));
            LOG.debug((Object)("Num remote worker results: " + tmp.size()));
        }
        return tmp.values().toArray(new LocalVariableMap[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupBufferPool(long workerID, boolean isLocal) throws IOException {
        Class<CacheableData> clazz = CacheableData.class;
        synchronized (CacheableData.class) {
            if (!CacheableData.isCachingActive() && !isLocal) {
                String uuid = IDHandler.createDistributedUniqueID();
                LocalFileUtils.createWorkingDirectoryWithUUID(uuid);
                CacheableData.initCaching(uuid);
                CacheableData.cacheEvictionLocalFilePrefix = CacheableData.cacheEvictionLocalFilePrefix + "_" + workerID;
                RemoteParForUtils.cleanupWorkingDirectoriesOnShutdown();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private static class DeleteWorkingDirectoriesTask
    extends Thread {
        private DeleteWorkingDirectoriesTask() {
        }

        @Override
        public void run() {
            RemoteParForUtils.cleanupWorkingDirectories();
        }
    }
}

