/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.util;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;

public class IDHandler {
    public static int extractIntID(String taskID) {
        int maxlen = (int)Math.log10(2.147483647E9);
        int intVal = (int)IDHandler.extractID(taskID, maxlen);
        return intVal;
    }

    public static long concatIntIDsToLong(int part1, int part2) {
        long value = (long)part1 << 32;
        return value |= (long)part2;
    }

    public static int extractIntIDFromLong(long val, int part) {
        int ret = -1;
        if (part == 1) {
            ret = (int)(val >>> 32);
        } else if (part == 2) {
            ret = (int)val;
        }
        return ret;
    }

    public static String createDistributedUniqueID() {
        Object uuid = null;
        try {
            String pid = IDHandler.obtainProcessID();
            InetAddress addr = InetAddress.getLocalHost();
            String host = addr.getHostAddress();
            uuid = pid + "_" + host;
        }
        catch (Exception ex) {
            uuid = "0_0.0.0.0";
        }
        return uuid;
    }

    public static String obtainProcessID() {
        String pname = ManagementFactory.getRuntimeMXBean().getName();
        String pid = pname.split("@")[0];
        return pid;
    }

    private static long extractID(String taskID, int maxlen) {
        char[] c = taskID.toCharArray();
        long value = 0L;
        int count = 0;
        for (int i = c.length - 1; i >= 0 && count < maxlen; --i) {
            if (c[i] < '0' || c[i] > '9') continue;
            long newVal = c[i] - 48;
            value += (newVal *= (long)Math.pow(10.0, count));
            ++count;
        }
        return value;
    }
}

