/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public interface MatrixBlockFromFrame {
    public static final Log LOG = LogFactory.getLog((String)MatrixBlockFromFrame.class.getName());
    public static final int blocksizeIJ = 32;

    public static MatrixBlock convertToMatrixBlock(FrameBlock frame) {
        int m = frame.getNumRows();
        int n = frame.getNumColumns();
        MatrixBlock mb = new MatrixBlock(m, n, false);
        mb.allocateDenseBlock();
        if (mb.getDenseBlock().isContiguous()) {
            MatrixBlockFromFrame.convertContiguous(frame, mb, m, n);
        } else {
            MatrixBlockFromFrame.convertGeneric(frame, mb, m, n);
        }
        mb.examSparsity();
        return mb;
    }

    private static void convertContiguous(FrameBlock frame, MatrixBlock mb, int m, int n) {
        long lnnz = 0L;
        double[] c = mb.getDenseBlockValues();
        for (int bi = 0; bi < m; bi += 32) {
            for (int bj = 0; bj < n; bj += 32) {
                int bimin = Math.min(bi + 32, m);
                int bjmin = Math.min(bj + 32, n);
                int i = bi;
                int aix = bi * n;
                while (i < bimin) {
                    for (int j = bj; j < bjmin; ++j) {
                        double d = frame.getDoubleNaN(i, j);
                        c[aix + j] = d;
                        lnnz += d != 0.0 ? 1L : 0L;
                    }
                    ++i;
                    aix += n;
                }
            }
        }
        mb.setNonZeros(lnnz);
    }

    private static void convertGeneric(FrameBlock frame, MatrixBlock mb, int m, int n) {
        long lnnz = 0L;
        DenseBlock c = mb.getDenseBlock();
        for (int bi = 0; bi < m; bi += 32) {
            for (int bj = 0; bj < n; bj += 32) {
                int bimin = Math.min(bi + 32, m);
                int bjmin = Math.min(bj + 32, n);
                for (int i = bi; i < bimin; ++i) {
                    double[] cvals = c.values(i);
                    int cpos = c.pos(i);
                    for (int j = bj; j < bjmin; ++j) {
                        double d = frame.getDoubleNaN(i, j);
                        cvals[cpos + j] = d;
                        lnnz += d != 0.0 ? 1L : 0L;
                    }
                }
            }
        }
        mb.setNonZeros(lnnz);
    }
}

