/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.encoding;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.ConstEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.EmptyEncoding;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;
import org.apache.sysds.runtime.compress.estim.encoding.SparseEncoding;

public class DenseEncoding
implements IEncode {
    private final AMapToData map;

    public DenseEncoding(AMapToData map) {
        this.map = map;
        map.getCounts();
    }

    @Override
    public DenseEncoding combine(IEncode e) {
        if (e instanceof EmptyEncoding || e instanceof ConstEncoding) {
            return this;
        }
        if (e instanceof SparseEncoding) {
            return this.combineSparse((SparseEncoding)e);
        }
        return this.combineDense((DenseEncoding)e);
    }

    protected DenseEncoding combineSparse(SparseEncoding e) {
        int maxUnique = e.getUnique() * this.getUnique();
        int size = this.map.size();
        int nVl = this.getUnique();
        AMapToData ret = MapToFactory.create(size, maxUnique);
        ret.copy(this.map);
        AIterator itr = e.off.getIterator();
        int fr = e.off.getOffsetToLast();
        int ir = itr.value();
        while (ir < fr) {
            ret.set(ir, ret.getIndex(ir) + (e.map.getIndex(itr.getDataIndex()) + 1) * nVl);
            ir = itr.next();
        }
        ret.set(fr, ret.getIndex(fr) + (e.map.getIndex(itr.getDataIndex()) + 1) * nVl);
        if (maxUnique + nVl > size) {
            return this.combineSparseHashMap(ret);
        }
        return this.combineSparseMapToData(ret, maxUnique, nVl);
    }

    private final DenseEncoding combineSparseHashMap(AMapToData ret) {
        int size = ret.size();
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>(size);
        for (int r = 0; r < size; ++r) {
            int prev = ret.getIndex(r);
            int v = m.size();
            Integer mv = m.putIfAbsent(prev, v);
            if (mv == null) {
                ret.set(r, v);
                continue;
            }
            ret.set(r, mv);
        }
        return new DenseEncoding(MapToFactory.resize(ret, m.size()));
    }

    private final DenseEncoding combineSparseMapToData(AMapToData ret, int maxUnique, int nVl) {
        int size = ret.size();
        AMapToData m = MapToFactory.create(maxUnique, maxUnique + nVl);
        int newUID = 1;
        for (int r = 0; r < size; ++r) {
            int prev = ret.getIndex(r);
            int mv = m.getIndex(prev);
            if (mv == 0) {
                mv = m.setAndGet(prev, newUID++);
            }
            ret.set(r, mv - 1);
        }
        return new DenseEncoding(MapToFactory.resize(ret, newUID - 1));
    }

    protected DenseEncoding combineDense(DenseEncoding other) {
        if (this.map == other.map) {
            return this;
        }
        AMapToData lm = this.map;
        AMapToData rm = other.map;
        int nVL = lm.getUnique();
        int nVR = rm.getUnique();
        int size = this.map.size();
        int maxUnique = nVL * nVR;
        AMapToData ret = MapToFactory.create(size, maxUnique);
        if (maxUnique > size) {
            return this.combineDenseWithHashMap(lm, rm, size, nVL, ret);
        }
        return this.combineDenseWithMapToData(lm, rm, size, nVL, ret, maxUnique);
    }

    protected final DenseEncoding combineDenseWithHashMap(AMapToData lm, AMapToData rm, int size, int nVL, AMapToData ret) {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>(size);
        for (int r = 0; r < size; ++r) {
            DenseEncoding.addValHashMap(lm.getIndex(r) + rm.getIndex(r) * nVL, r, m, ret);
        }
        return new DenseEncoding(MapToFactory.resize(ret, m.size()));
    }

    protected final DenseEncoding combineDenseWithMapToData(AMapToData lm, AMapToData rm, int size, int nVL, AMapToData ret, int maxUnique) {
        AMapToData m = MapToFactory.create(maxUnique, maxUnique + 1);
        int newUID = 1;
        for (int r = 0; r < size; ++r) {
            newUID = DenseEncoding.addValMapToData(lm.getIndex(r) + rm.getIndex(r) * nVL, r, m, newUID, ret);
        }
        return new DenseEncoding(MapToFactory.resize(ret, newUID - 1));
    }

    protected static int addValMapToData(int nv, int r, AMapToData map, int newId, AMapToData d) {
        int mv = map.getIndex(nv);
        if (mv == 0) {
            mv = map.setAndGet(nv, newId++);
        }
        d.set(r, mv - 1);
        return newId;
    }

    protected static void addValHashMap(int nv, int r, Map<Integer, Integer> map, AMapToData d) {
        int v = map.size();
        Integer mv = map.putIfAbsent(nv, v);
        if (mv == null) {
            d.set(r, v);
        } else {
            d.set(r, mv);
        }
    }

    @Override
    public int getUnique() {
        return this.map.getUnique();
    }

    @Override
    public EstimationFactors extractFacts(int nRows, double tupleSparsity, double matrixSparsity, CompressionSettings cs) {
        int largestOffs = 0;
        int[] counts = this.map.getCounts();
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] <= largestOffs) continue;
            largestOffs = counts[i];
        }
        if (cs.isRLEAllowed()) {
            return new EstimationFactors(this.map.getUnique(), nRows, largestOffs, counts, 0, nRows, this.map.countRuns(), false, false, matrixSparsity, tupleSparsity);
        }
        return new EstimationFactors(this.map.getUnique(), nRows, largestOffs, counts, 0, nRows, false, false, matrixSparsity, tupleSparsity);
    }

    @Override
    public boolean isDense() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("\n");
        sb.append("mapping: ");
        sb.append(this.map);
        return sb.toString();
    }
}

