/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.iterators.IteratorFactory;
import org.apache.sysds.runtime.frame.data.iterators.RowIterator;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameWriter;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.util.HDFSTool;

public class FrameWriterTextCSV
extends FrameWriter {
    public static final int BLOCKSIZE_J = 32;
    protected FileFormatPropertiesCSV _props = null;

    public FrameWriterTextCSV(FileFormatPropertiesCSV props) {
        this._props = props;
    }

    @Override
    public final void writeFrameToHDFS(FrameBlock src, String fname, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Frame dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        this.writeCSVFrameToHDFS(path, job, src, rlen, clen, this._props);
    }

    protected void writeCSVFrameToHDFS(Path path, JobConf job, FrameBlock src, long rlen, long clen, FileFormatPropertiesCSV csvprops) throws IOException {
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FrameWriterTextCSV.writeCSVFrameToFile(path, job, fs, src, 0, (int)rlen, csvprops);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeCSVFrameToFile(Path path, JobConf job, FileSystem fs, FrameBlock src, int rl, int ru, FileFormatPropertiesCSV props) throws IOException {
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
        int cols = src.getNumColumns();
        try {
            StringBuilder sb = new StringBuilder();
            props = props == null ? new FileFormatPropertiesCSV() : props;
            String delim = props.getDelim();
            if (rl == 0) {
                int j;
                if (props.hasHeader()) {
                    for (j = 0; j < cols; ++j) {
                        sb.append(src.getColumnNames()[j]);
                        if (j >= cols - 1) continue;
                        sb.append(delim);
                    }
                    sb.append('\n');
                }
                if (!src.isColumnMetadataDefault()) {
                    sb.append("#Meta\u00b7MV" + delim);
                    for (j = 0; j < cols; ++j) {
                        sb.append(src.getColumnMetadata(j).getMvValue() + (j < cols - 1 ? delim : ""));
                    }
                    sb.append("\n");
                    sb.append("#Meta\u00b7ND" + delim);
                    for (j = 0; j < cols; ++j) {
                        sb.append(src.getColumnMetadata(j).getNumDistinct() + (j < cols - 1 ? delim : ""));
                    }
                    sb.append("\n");
                }
                br.write(sb.toString());
                sb.setLength(0);
            }
            RowIterator<String> iter = IteratorFactory.getStringRowIterator(src, rl, ru);
            while (iter.hasNext()) {
                String[] row = (String[])iter.next();
                for (int bj = 0; bj < cols; bj += 32) {
                    for (int j = bj; j < Math.min(cols, bj + 32); ++j) {
                        if (row[j] != null) {
                            sb.append(row[j]);
                        }
                        if (j == cols - 1) continue;
                        sb.append(delim);
                    }
                    br.write(sb.toString());
                    sb.setLength(0);
                }
                sb.append('\n');
                br.write(sb.toString());
                sb.setLength(0);
            }
        }
        finally {
            IOUtilFunctions.closeSilently(br);
        }
    }
}

