/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class WeightedDivMM
extends Lop {
    public static final String OPCODE = "mapwdivmm";
    public static final String OPCODE_CP = "wdivmm";
    private int _numThreads = 1;
    private WDivMMType _weightsType = null;

    public WeightedDivMM(Lop input1, Lop input2, Lop input3, Lop input4, Types.DataType dt, Types.ValueType vt, WDivMMType wt, Types.ExecType et) {
        super(Lop.Type.WeightedDivMM, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        this.addInput(input4);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        input4.addOutput(this);
        this._weightsType = wt;
        this.setupLopProperties(et);
    }

    @Override
    public String toString() {
        return "Operation = WeightedDivMM";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String input4, String output) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        Types.ExecType et = this.getExecType();
        sb.append((Object)et);
        sb.append("\u00b0");
        if (et == Types.ExecType.CP) {
            sb.append(OPCODE_CP);
        } else {
            sb.append(OPCODE);
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(3).prepInputOperand(input4));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._weightsType);
        if (et == Types.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    public static enum WDivMMType {
        DIV_LEFT,
        DIV_RIGHT,
        DIV_LEFT_EPS,
        DIV_RIGHT_EPS,
        MULT_BASIC,
        MULT_LEFT,
        MULT_RIGHT,
        MULT_MINUS_LEFT,
        MULT_MINUS_RIGHT,
        MULT_MINUS_4_LEFT,
        MULT_MINUS_4_RIGHT;


        public boolean isBasic() {
            return this == MULT_BASIC;
        }

        public boolean isLeft() {
            return this == DIV_LEFT || this == DIV_LEFT_EPS || this == MULT_LEFT || this == MULT_MINUS_LEFT || this == MULT_MINUS_4_LEFT;
        }

        public boolean isRight() {
            return !this.isLeft() && !this.isBasic();
        }

        public boolean isMult() {
            return this == MULT_LEFT || this == MULT_RIGHT || this == MULT_MINUS_LEFT || this == MULT_MINUS_RIGHT || this == MULT_MINUS_4_LEFT || this == MULT_MINUS_4_RIGHT;
        }

        public boolean isMinus() {
            return this == MULT_MINUS_LEFT || this == MULT_MINUS_RIGHT || this == MULT_MINUS_4_LEFT || this == MULT_MINUS_4_RIGHT;
        }

        public boolean hasFourInputs() {
            return this == MULT_MINUS_4_LEFT || this == MULT_MINUS_4_RIGHT || this == DIV_LEFT_EPS || this == DIV_RIGHT_EPS;
        }

        public boolean hasScalar() {
            return this == DIV_LEFT_EPS || this == DIV_RIGHT_EPS;
        }

        public MatrixCharacteristics computeOutputCharacteristics(long Xrlen, long Xclen, long rank) {
            if (this.isBasic()) {
                return new MatrixCharacteristics(Xrlen, Xclen, -1, -1L);
            }
            return new MatrixCharacteristics(this.isLeft() ? Xclen : Xrlen, rank, -1, -1L);
        }
    }
}

