/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.IContainADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IdentityDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ADictBasedColGroup
extends AColGroupCompressed
implements IContainADictionary {
    private static final long serialVersionUID = -3737025296618703668L;
    protected final IDictionary _dict;

    protected ADictBasedColGroup(IColIndex colIndices, IDictionary dict) {
        super(colIndices);
        this._dict = dict;
        if (dict == null) {
            throw new NullPointerException("null dict is invalid");
        }
    }

    @Override
    public IDictionary getDictionary() {
        return this._dict;
    }

    @Override
    public final void decompressToDenseBlock(DenseBlock db, int rl, int ru, int offR, int offC) {
        if (this._dict instanceof IdentityDictionary) {
            MatrixBlockDictionary md = ((IdentityDictionary)this._dict).getMBDict();
            MatrixBlock mb = md.getMatrixBlock();
            if (mb.isInSparseFormat()) {
                this.decompressToDenseBlockSparseDictionary(db, rl, ru, offR, offC, mb.getSparseBlock());
            } else {
                this.decompressToDenseBlockDenseDictionary(db, rl, ru, offR, offC, mb.getDenseBlockValues());
            }
        } else if (this._dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary md = (MatrixBlockDictionary)this._dict;
            MatrixBlock mb = md.getMatrixBlock();
            if (mb.isInSparseFormat()) {
                this.decompressToDenseBlockSparseDictionary(db, rl, ru, offR, offC, mb.getSparseBlock());
            } else {
                this.decompressToDenseBlockDenseDictionary(db, rl, ru, offR, offC, mb.getDenseBlockValues());
            }
        } else {
            this.decompressToDenseBlockDenseDictionary(db, rl, ru, offR, offC, this._dict.getValues());
        }
    }

    @Override
    public final void decompressToSparseBlock(SparseBlock sb, int rl, int ru, int offR, int offC) {
        if (this._dict instanceof IdentityDictionary) {
            MatrixBlockDictionary md = ((IdentityDictionary)this._dict).getMBDict();
            MatrixBlock mb = md.getMatrixBlock();
            if (mb.isInSparseFormat()) {
                this.decompressToSparseBlockSparseDictionary(sb, rl, ru, offR, offC, mb.getSparseBlock());
            } else {
                this.decompressToSparseBlockDenseDictionary(sb, rl, ru, offR, offC, mb.getDenseBlockValues());
            }
        } else if (this._dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary md = (MatrixBlockDictionary)this._dict;
            MatrixBlock mb = md.getMatrixBlock();
            if (mb.isInSparseFormat()) {
                this.decompressToSparseBlockSparseDictionary(sb, rl, ru, offR, offC, mb.getSparseBlock());
            } else {
                this.decompressToSparseBlockDenseDictionary(sb, rl, ru, offR, offC, mb.getDenseBlockValues());
            }
        } else {
            this.decompressToSparseBlockDenseDictionary(sb, rl, ru, offR, offC, this._dict.getValues());
        }
    }

    protected abstract void decompressToDenseBlockSparseDictionary(DenseBlock var1, int var2, int var3, int var4, int var5, SparseBlock var6);

    protected abstract void decompressToDenseBlockDenseDictionary(DenseBlock var1, int var2, int var3, int var4, int var5, double[] var6);

    protected abstract void decompressToSparseBlockSparseDictionary(SparseBlock var1, int var2, int var3, int var4, int var5, SparseBlock var6);

    protected abstract void decompressToSparseBlockDenseDictionary(SparseBlock var1, int var2, int var3, int var4, int var5, double[] var6);

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._dict.write(out);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        return ret += this._dict.getExactSizeOnDisk();
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._dict.getInMemorySize();
        return size += 8L;
    }

    @Override
    public final AColGroup rightMultByMatrix(MatrixBlock right, IColIndex allCols) {
        IColIndex agCols;
        if (right.isEmpty()) {
            return null;
        }
        int nCol = right.getNumColumns();
        allCols = allCols == null ? ColIndexFactory.create(nCol) : allCols;
        IColIndex iColIndex = agCols = right.isInSparseFormat() ? this.rightMMGetColsSparse(right.getSparseBlock(), nCol, allCols) : this.rightMMGetColsDense(right.getDenseBlockValues(), nCol, allCols, right.getNonZeros());
        if (agCols == null) {
            return null;
        }
        int nVals = this.getNumValues();
        IDictionary preAgg = right.isInSparseFormat() ? this.rightMMPreAggSparse(nVals, right.getSparseBlock(), agCols, 0, nCol) : this._dict.preaggValuesFromDense(nVals, this._colIndexes, agCols, right.getDenseBlockValues(), nCol);
        return this.allocateRightMultiplication(right, agCols, preAgg);
    }

    protected abstract AColGroup allocateRightMultiplication(MatrixBlock var1, IColIndex var2, IDictionary var3);

    protected IColIndex rightMMGetColsDense(double[] b, int nCols, IColIndex allCols, long nnz) {
        if (nCols > 200 || (double)nnz > (double)b.length * 0.7) {
            return allCols;
        }
        HashSet<Integer> aggregateColumnsSet = new HashSet<Integer>();
        for (int k = 0; k < this._colIndexes.size(); ++k) {
            int rowIdxOffset = this._colIndexes.get(k) * nCols;
            for (int h = 0; h < nCols; ++h) {
                if (b[rowIdxOffset + h] == 0.0) continue;
                aggregateColumnsSet.add(h);
            }
        }
        if (aggregateColumnsSet.size() == nCols) {
            return allCols;
        }
        if (aggregateColumnsSet.size() == 0) {
            return null;
        }
        int[] aggregateColumns = aggregateColumnsSet.stream().mapToInt(x -> x).toArray();
        Arrays.sort(aggregateColumns);
        return ColIndexFactory.create(aggregateColumns);
    }

    protected IColIndex rightMMGetColsSparse(SparseBlock b, int retCols, IColIndex allCols) {
        HashSet<Integer> aggregateColumnsSet = new HashSet<Integer>();
        for (int h = 0; h < this._colIndexes.size(); ++h) {
            int colIdx = this._colIndexes.get(h);
            if (!b.isEmpty(colIdx)) {
                int[] sIndexes = b.indexes(colIdx);
                for (int i = b.pos(colIdx); i < b.size(colIdx) + b.pos(colIdx); ++i) {
                    aggregateColumnsSet.add(sIndexes[i]);
                }
            }
            if (aggregateColumnsSet.size() != retCols) continue;
            return allCols;
        }
        if (aggregateColumnsSet.size() == 0) {
            return null;
        }
        int[] aggregateColumns = aggregateColumnsSet.stream().mapToInt(x -> x).toArray();
        Arrays.sort(aggregateColumns);
        return ColIndexFactory.create(aggregateColumns);
    }

    private IDictionary rightMMPreAggSparse(int numVals, SparseBlock b, IColIndex aggregateColumns, int cl, int cu) {
        double[] ret = new double[numVals * aggregateColumns.size()];
        for (int h = 0; h < this._colIndexes.size(); ++h) {
            int colIdx = this._colIndexes.get(h);
            if (b.isEmpty(colIdx)) continue;
            double[] sValues = b.values(colIdx);
            int[] sIndexes = b.indexes(colIdx);
            int retIdx = 0;
            for (int i = b.pos(colIdx); i < b.size(colIdx) + b.pos(colIdx); ++i) {
                while (aggregateColumns.get(retIdx) < sIndexes[i]) {
                    ++retIdx;
                }
                int j = 0;
                int offOrg = h;
                while (j < numVals * aggregateColumns.size()) {
                    int n = j + retIdx;
                    ret[n] = ret[n] + this._dict.getValue(offOrg) * sValues[i];
                    j += aggregateColumns.size();
                    offOrg += this._colIndexes.size();
                }
            }
        }
        return Dictionary.create(ret);
    }

    @Override
    public final AColGroup copyAndSet(IColIndex colIndexes) {
        return this.copyAndSet(colIndexes, this._dict);
    }

    public final AColGroup copyAndSet(IDictionary newDictionary) {
        return this.copyAndSet(this._colIndexes, newDictionary);
    }

    protected abstract AColGroup copyAndSet(IColIndex var1, IDictionary var2);
}

