/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;

public class CommonThreadPool
implements ExecutorService {
    protected static final Log LOG = LogFactory.getLog((String)CommonThreadPool.class.getName());
    private static final int size = InfrastructureAnalyzer.getLocalParallelism();
    private static final ExecutorService shared = ForkJoinPool.commonPool();
    private static CommonThreadPool shared2 = null;
    private static int shared2K = -1;
    private static ExecutorService asyncPool = null;
    private final ExecutorService _pool;

    public CommonThreadPool(ExecutorService pool) {
        this._pool = pool;
    }

    public static ExecutorService get() {
        return shared;
    }

    public static synchronized ExecutorService get(int k) {
        if (size == k) {
            return shared;
        }
        if (Thread.currentThread().getName().equals("main")) {
            if (shared2 != null && shared2K == k) {
                return shared2;
            }
            if (shared2 == null) {
                shared2 = new CommonThreadPool(new ForkJoinPool(k));
                shared2K = k;
                return shared2;
            }
            return new CommonThreadPool(Executors.newFixedThreadPool(k));
        }
        return new CommonThreadPool(Executors.newFixedThreadPool(k));
    }

    public static boolean isSharedTPThreads(int k) {
        return size == k || shared2K == k || shared2K == -1;
    }

    public static <T> void invokeAndShutdown(ExecutorService pool, Collection<? extends Callable<T>> tasks) {
        try {
            List ret = pool.invokeAll(tasks);
            for (Future r : ret) {
                r.get();
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        finally {
            pool.shutdown();
        }
    }

    public static synchronized ExecutorService getDynamicPool() {
        if (asyncPool != null && !asyncPool.isShutdown() && !asyncPool.isTerminated()) {
            return asyncPool;
        }
        asyncPool = Executors.newCachedThreadPool();
        return asyncPool;
    }

    public static synchronized void shutdownAsyncPools() {
        if (asyncPool != null) {
            asyncPool.shutdown();
            asyncPool = null;
        }
        if (shared2 != null) {
            shared2.shutdown();
            shared2 = null;
            shared2K = -1;
        }
    }

    public final boolean isCached() {
        return this._pool.equals(shared) || this.equals(shared2);
    }

    @Override
    public void shutdown() {
        if (!this.isCached()) {
            this._pool.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        return !this.isCached() ? this._pool.shutdownNow() : null;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this._pool.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this._pool.invokeAll(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this._pool.execute(command);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this._pool.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this._pool.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this._pool.submit(task);
    }

    @Override
    public boolean isShutdown() {
        return this.isCached() || this._pool.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.isCached() || this._pool.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.isCached() || this._pool.awaitTermination(timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this._pool.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this._pool.invokeAny(tasks);
    }
}

