/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.cost;

public class FederatedCost {
    protected double _computeCost = 0.0;
    protected double _readCost = 0.0;
    protected double _inputTransferCost = 0.0;
    protected double _outputTransferCost = 0.0;
    protected double _inputTotalCost = 0.0;
    protected double _repetitions = 1.0;
    protected double _totalCost;

    public FederatedCost() {
    }

    public FederatedCost(double readCost, double inputTransferCost, double outputTransferCost, double computeCost, double inputTotalCost, double repetitions) {
        this._readCost = readCost;
        this._inputTransferCost = inputTransferCost;
        this._outputTransferCost = outputTransferCost;
        this._computeCost = computeCost;
        this._inputTotalCost = inputTotalCost;
        this._repetitions = repetitions;
        this._totalCost = this.calcTotal();
    }

    public double getTotal() {
        return this._totalCost;
    }

    private double calcTotal() {
        return (this._computeCost + this._readCost + this._inputTransferCost + this._outputTransferCost) * this._repetitions + this._inputTotalCost;
    }

    private void updateTotal() {
        this._totalCost = this.calcTotal();
    }

    public double getInputTotalCost() {
        return this._inputTotalCost;
    }

    public void setInputTotalCost(double inputTotalCost) {
        this._inputTotalCost = inputTotalCost;
    }

    public void addInputTotalCost(double additionalCost) {
        this._inputTotalCost += additionalCost;
        this.updateTotal();
    }

    public void addInputTotalCost(FederatedCost federatedCost) {
        this.addInputTotalCost(federatedCost.getTotal());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(" computeCost: ");
        builder.append(this._computeCost);
        builder.append("\n readCost: ");
        builder.append(this._readCost);
        builder.append("\n inputTransferCost: ");
        builder.append(this._inputTransferCost);
        builder.append("\n outputTransferCost: ");
        builder.append(this._outputTransferCost);
        builder.append("\n inputTotalCost: ");
        builder.append(this._inputTotalCost);
        builder.append("\n repetitions: ");
        builder.append(this._repetitions);
        builder.append("\n total cost: ");
        builder.append(this.getTotal());
        return builder.toString();
    }
}

